#pragma once

#include "RtlFunc.h"
#include "afxwin.h"


struct THREAD_PARAM {
    UCHAR	ucOpCode;
    UINT          uiFlashStartAddr;
    UINT          uiFlashLength;
    CHAR         *chImageFileName;
};


enum FLASH_OP_CODE{
	FLASH_DOWNLOAD 	= 1,
	FLASH_VERIFY		= 2,
	FLASH_ERASE		= 3,	
};


// CFlashDlg dialog
	
class CFlashDlg : public CDialog
{
	DECLARE_DYNAMIC(CFlashDlg)

public:
	CFlashDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CFlashDlg();

// Dialog Data
	enum { IDD = IDD_FLASH_DLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	bool CFlashDlg::GetImageFileName(CHAR *chImageName);

	DECLARE_MESSAGE_MAP()
public:
	CButton m_FlashDownload;
	CButton m_FlashVerify;
	afx_msg void OnImageFileBrowse();
	CString m_ImageFilePath;

	afx_msg void OnFlashDownload();
	afx_msg void OnFlashVerify();
	void SetOrQueryAutoInstallStatus(UCHAR SetOrQuery, CHAR* Enable);
	static UINT FlashThread(LPVOID pParam) ;
	void DoEvent()  ;
	afx_msg void OnFalshErase();
	afx_msg void OnCheckHex();

	CButton m_FlashErase;
	CEdit m_FlashEraseLength;
	CEdit m_FlashEraseStartAddr;
	CEdit m_FlashDLStartAddr;
	bool GetImageFileName(CHAR *chImageName, bool *bCopy);
	void DeleteCopyedFile(CHAR *chImageName);
	afx_msg void OnClose();

};
