// FlashDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MP819xVC.h"
#include "FlashDlg.h"
//#include "afxdialogex.h"

#define FLASH_IMAGE_FILEPATH  _T("C:\\Windows\\System32\\drivers\\")
#define READ_ISO_FILE_FROM_DRIVER

bool  bFlashOpInProgress = FALSE;
bool  bFlashOpFail = FALSE;

// CFlashDlg dialog

IMPLEMENT_DYNAMIC(CFlashDlg, CDialog)

CFlashDlg::CFlashDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFlashDlg::IDD, pParent)
{

}

CFlashDlg::~CFlashDlg()
{
}

void CFlashDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_FLASH_DOWNLOAD, m_FlashDownload);
	DDX_Control(pDX, IDC_FLASH_VERIFY, m_FlashVerify);
	DDX_Text(pDX, IDC_IMAGE_FILE_PATH, m_ImageFilePath);
	DDX_Control(pDX, IDC_FALSH_ERASE, m_FlashErase);
	DDX_Control(pDX, IDC_ERASE_LENGTH, m_FlashEraseLength);
	DDX_Control(pDX, IDC_ERASE_START_ADDR, m_FlashEraseStartAddr);
	DDX_Control(pDX, IDC_FLASH_DL_START_ADDR, m_FlashDLStartAddr);	
}


BEGIN_MESSAGE_MAP(CFlashDlg, CDialog)
	ON_BN_CLICKED(IDC_IMAGE_FILE_BROWSE, OnImageFileBrowse)
	ON_BN_CLICKED(IDC_FLASH_DOWNLOAD, OnFlashDownload)
	ON_BN_CLICKED(IDC_FLASH_VERIFY, OnFlashVerify)
	ON_BN_CLICKED(IDC_FALSH_ERASE, OnFalshErase)
	ON_BN_CLICKED(IDC_CHECK_HEX, OnCheckHex)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


// CFlashDlg message handlers
void CFlashDlg::SetOrQueryAutoInstallStatus(UCHAR SetOrQuery, CHAR* Enable)
{
	UCHAR EEValue = 0 , SetValue = 0;
	int 	    bResult = 0;
	ULONG Offset = 0;

	if (IS_HARDWARE_SERIES(8710B))//0x18[6] is 8188GU definition, ohter IC need revise???
	{
		Offset = 0x18;//EFUSE 0x18[6]: auto install enable, default is 0
		
		// Read value from EFUSE
		bResult = ReadEFuseByte((LPADAPTER)(Adapter.hFile), Offset,(UCHAR*)&EEValue);	
		if(bResult == FALSE)
		{
			goto Error;
		}

		if(EEValue == 0xFF)//0xFF means the Efuse byte is Empty, 
		{
			MessageBox(TEXT("Waring: The Efuse is Empty !! Please write the Efuse Manually" ));	
			*Enable = -1;//Empty
			return;
		}

		if(SetOrQuery == 0) //Query 
		{		
			if(EEValue != 0xFF && EEValue & 0x40 )//0xFF means the Efuse byte is Empty, so it is also diabled. 
				*Enable = 1; //Enabled
			else 
				*Enable = 0;//Disabled

			return;
		}
		else if(SetOrQuery == 1) //Set 
		{
			SetValue = *Enable;
			
			if(SetValue == 1)//Enable 		
				EEValue |= 0x40;
			else if(SetValue == 0)//Disable
				EEValue &= 0xBF;
			else
				goto Error;
			
			bResult = WriteEFuseByte((LPADAPTER)(Adapter.hFile), Offset, EEValue );	
			if(bResult == FALSE)
			{
				goto Error;
			}

			bResult = UpdateEFuse((LPADAPTER)(Adapter.hFile));
			if(bResult == FALSE)
			{
				goto Error;
			}
			
			return;
		}

	Error:
			MessageBox(TEXT("Fail to Set AutoInstall status !!" ));	
	}

}

BOOL CFlashDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//Init the Flash update button 
	m_FlashDownload.EnableWindow(false);
	m_FlashVerify.EnableWindow(false);
	//m_FlashErase.EnableWindow(false);

	((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT(""));
	
	return TRUE;
}



void CFlashDlg::OnImageFileBrowse()
{
	//const char pszFilter[] = _T("Image File|*.iso;*.bin|All Files (*.*)|*.*||");
	const char pszFilter[] = _T("All Files (*.*)|*.*||");
	//CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,pszFilter, this); //use this release Version will crash when ImageFileDLG->DoModal() 
	CFileDialog * ImageFileDLG = new CFileDialog(TRUE, NULL, NULL, OFN_HIDEREADONLY ,pszFilter, this);
	if(ImageFileDLG == NULL)
	{
		goto Error;
	}
	
	//ImageFileDLG->m_ofn.lpstrInitialDir = FLASH_IMAGE_FILEPATH;
	//Init the Flash update button 
	m_FlashDownload.EnableWindow(false);
	m_FlashVerify.EnableWindow(false);
	if(ImageFileDLG->DoModal() == IDOK)
	{
		m_ImageFilePath = ImageFileDLG->GetPathName();
		UpdateData(false);		
		if(m_ImageFilePath)
		{
			CString csImageFilePath = m_ImageFilePath.Right(4);
			CHAR * chImageFilePath = csImageFilePath.GetBuffer(csImageFilePath.GetLength()); 
			if (_tcscmp(strlwr(chImageFilePath), _T(".iso")) == 0 || _tcscmp(strlwr(chImageFilePath), _T(".bin")) == 0 || _tcscmp(strlwr(chImageFilePath), _T(".txt")) == 0)
			{
				m_FlashDownload.EnableWindow(true);
				m_FlashVerify.EnableWindow(true);
				//UpdateData(false);	
			}
	
			csImageFilePath.ReleaseBuffer();
		}
	}

	if(ImageFileDLG)
	{
		delete ImageFileDLG;
		ImageFileDLG = NULL;
	}
Error:
	return;
}


#ifdef READ_ISO_FILE_FROM_DRIVER
bool CFlashDlg::GetImageFileName(CHAR *chImageName, bool *bCopy)
{
	bool 	ret = false, bNeedCopy = false;
	TCHAR 	*chImageFileName = NULL, chDestFileName[MAX_PATH]={0};	
	CString 	sImageFileName, sFolder = FLASH_IMAGE_FILEPATH;
	int 		nFolderPos = 0, nFileNamePos, nFileNameCount=0;
	
	nFolderPos = m_ImageFilePath.Find(sFolder);//if not find, the return value is -1;

	if(nFolderPos != 0)//the file path is error. The image file must be in "C:\\Windows\\System32\\drivers\\",  otherwise driver cannot open the file.
	{
		//Win32Print("The file location is not correct: m_ImageFilePath %s, it must in C:\\Windows\\System32\\drivers\\!!\n",m_ImageFilePath);
		//goto Error;
		bNeedCopy = true;
	}
	
	if(bNeedCopy)
	{
		PVOID OldValue = NULL;
		HINSTANCE  hlibrary; 
		typedef    int        (__stdcall  *  Wow64DisableWow64FsRedirection)(LPVOID); 
		Wow64DisableWow64FsRedirection  f_Wow64DisableWow64FsRedirection  =  NULL; 
		typedef    int        (__stdcall  *  Wow64RevertWow64FsRedirection)(LPVOID); 
		Wow64RevertWow64FsRedirection  f_Wow64RevertWow64FsRedirection  =  NULL;

		hlibrary  =  LoadLibrary("Kernel32.dll"); 

		f_Wow64DisableWow64FsRedirection  =  (Wow64DisableWow64FsRedirection)GetProcAddress(hlibrary,"Wow64DisableWow64FsRedirection"); 
		if(!f_Wow64DisableWow64FsRedirection) {
			FreeLibrary(hlibrary);
			goto Error;;
		}

		f_Wow64RevertWow64FsRedirection  =  (Wow64RevertWow64FsRedirection)GetProcAddress(hlibrary,"Wow64RevertWow64FsRedirection"); 
		if(!f_Wow64RevertWow64FsRedirection) { 
			FreeLibrary(hlibrary);
			goto Error;
		} 	
   
		//get image file name
		nFileNamePos= m_ImageFilePath.ReverseFind(TEXT('\\'));
		sImageFileName = m_ImageFilePath.Right(m_ImageFilePath.GetLength() - nFileNamePos - 1 );
		strcpy(chImageName,sImageFileName);

		//copy file to "C:\\Windows\\System32\\drivers\\"
		strcat(chDestFileName, sFolder);
		strcat(chDestFileName, sImageFileName);
		
		f_Wow64DisableWow64FsRedirection(&OldValue); 

		*bCopy = (bool)CopyFile(m_ImageFilePath, chDestFileName, FALSE);

		f_Wow64RevertWow64FsRedirection(OldValue); 
   		FreeLibrary(hlibrary);
		
		if( *bCopy == 0)
		{
			Win32Print("GetLastError()= 0x%x\n",GetLastError());
			AfxMessageBox(TEXT("Fail: Image File must in C:\\Windows\\System32\\drivers\\ !!" ));
			goto Error;
		}
	}
	else
	{		
		// m_ImageFilePath is "C:\\Windows\\System32\\drivers\\image.iso" ,and sFolder is "C:\\Windows\\System32\\drivers\\"	
		nFileNameCount = m_ImageFilePath.GetLength() - sFolder.GetLength();
		
		// 4: FileName is "*.iso" or "*.bin"; 256 is MAX length 
		if(nFileNameCount <= 4 ||nFileNameCount >= MAX_PATH )
		{
			Win32Print("The file name is not correct: m_ImageFilePath %s, \n",m_ImageFilePath);
			goto Error;
		}
					
		strcpy(chImageName,m_ImageFilePath.Right(nFileNameCount));		
	}

	ret = true;

Error:
	if(ret == false)
		AfxMessageBox(TEXT("Fail to Get Flash Image File !!" ));	
	return ret;

}

void CFlashDlg::DeleteCopyedFile(CHAR *chImageName)
{
	TCHAR 	chDestFileName[MAX_PATH]={0};	
	CString 	sFolder = FLASH_IMAGE_FILEPATH;
	strcat(chDestFileName, sFolder);
	strcat(chDestFileName, chImageName);
	Win32Print("Delete file chDestFileName = %s\n", chDestFileName);	
	
	DeleteFile(chDestFileName);
}

#else
bool CFlashDlg::GetImageFileName(CHAR *chImageName, bool *bCopy)
{
	bool 	ret = true;
	CHAR 	*chImageFileName = NULL;		

	strcpy(chImageName,m_ImageFilePath);	
	
	return ret;

}
#endif

UINT CFlashDlg::FlashThread(LPVOID pParam)  
{  
	UINT ret = 0;
	THREAD_PARAM * pThreadParam  = (THREAD_PARAM *)pParam;

	if(pThreadParam == NULL)
		goto Error;

	if(pThreadParam->ucOpCode == FLASH_DOWNLOAD || pThreadParam->ucOpCode == FLASH_VERIFY)
	{
		ret = UpdateFlashImage((LPADAPTER)(Adapter.hFile),pThreadParam->ucOpCode,pThreadParam->uiFlashStartAddr, pThreadParam->chImageFileName);
		if(ret != 1)
		{
			AfxMessageBox(TEXT("Fail to download or verify flash image!!"));
			bFlashOpFail = true;
		}
	}
	else if(pThreadParam->ucOpCode == FLASH_ERASE)
	{
		ret =EraseFlash((LPADAPTER)(Adapter.hFile),pThreadParam->uiFlashStartAddr, pThreadParam->uiFlashLength);
		if(ret != 1)
		{
			AfxMessageBox(TEXT("Fail to download or Erase flash !!"));
			bFlashOpFail = true;
		}
	}
	
Error:
	return ret;
}


void CFlashDlg::DoEvent()  
{  
    MSG msg;  
    if(::PeekMessage(&msg,NULL,0,0,PM_REMOVE))   
    {  
        ::TranslateMessage(&msg);   
        ::DispatchMessage(&msg);  
    }  
}

void CFlashDlg::OnFlashDownload()
{
   	 CWinThread* pThread = NULL;
	 DWORD dwRet = 0;
	 THREAD_PARAM ThreadParam;
	
	int ret = 0;
	CHAR chImageFileName[MAX_PATH] = {0};	
	UINT    DLStartAddrLen = 0, DLStartAddr = 0;
	CHAR    chDLStartAddr[20] = {0};
	bool      bCopy = false;
	
	 m_FlashDownload.EnableWindow(FALSE);   
	 m_FlashVerify.EnableWindow(FALSE);
	 m_FlashErase.EnableWindow(FALSE);
	 
	ThreadParam.ucOpCode = FLASH_DOWNLOAD;
		
	DLStartAddrLen = m_FlashDLStartAddr.GetWindowTextA(chDLStartAddr, 10);
	// Translate offset to number.
	if(DLStartAddrLen == 0 || 
		sscanf(chDLStartAddr, TEXT("%X"), &DLStartAddr) == 0)
	{
	       ((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error: Fail to get Flash Download Start Address !!" ));
	  	goto Error;
	}

	Win32Print("DLStartAddr=0x%x chDLStartAddr = %s\n", DLStartAddr,chDLStartAddr);
	
	//Get the Image name		
	if(GetImageFileName(chImageFileName, &bCopy) == false)
	{	
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error: Fail to get the Image name !!" ));
		goto Error;
	}

	Win32Print("chImageFileName = %s\n", chImageFileName);	
	
 	ThreadParam.uiFlashStartAddr =  DLStartAddr;
	ThreadParam.chImageFileName =  chImageFileName;
	
 	pThread = AfxBeginThread(FlashThread,&ThreadParam);
	((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Download Flash is in progress! Maybe need a few minutes, Please Waiting......"));
	bFlashOpInProgress = TRUE;
	DoEvent();  
	do   
	{  
		dwRet = ::MsgWaitForMultipleObjects(1, &pThread->m_hThread, FALSE, INFINITE, QS_ALLINPUT);  
		if (dwRet != WAIT_OBJECT_0)  
		{  
		    DoEvent();  
		}  
	} while ((dwRet != WAIT_OBJECT_0) && (dwRet != WAIT_FAILED)); 
	
#ifdef READ_ISO_FILE_FROM_DRIVER
	if(bCopy)
		DeleteCopyedFile(chImageFileName);
#endif	
	if(bFlashOpFail)
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Download Flash is Fail!"));
	else		
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Download Flash is Success!"));
	bFlashOpInProgress = FALSE;


Error:

	 m_FlashDownload.EnableWindow(TRUE); 
	 m_FlashVerify.EnableWindow(TRUE);
	 m_FlashErase.EnableWindow(TRUE);
}


void CFlashDlg::OnFlashVerify()
{
   	 CWinThread* pThread = NULL;
	 DWORD dwRet = 0;
	 THREAD_PARAM ThreadParam;
	
	int ret = 0;
	CHAR chImageFileName[MAX_PATH] = {0};	
	UINT    DLStartAddrLen = 0, DLStartAddr = 0;
	CHAR    chDLStartAddr[20] = {0};
	bool      bCopy = false;

	 m_FlashDownload.EnableWindow(FALSE);   
	 m_FlashVerify.EnableWindow(FALSE);
	 m_FlashErase.EnableWindow(FALSE);
	 
	ThreadParam.ucOpCode = FLASH_VERIFY;
		
	DLStartAddrLen = m_FlashDLStartAddr.GetWindowTextA(chDLStartAddr, 10);
	// Translate offset to number.
	if(DLStartAddrLen == 0 || 
		sscanf(chDLStartAddr, TEXT("%X"), &DLStartAddr) == 0)
	{
	       ((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error: Fail to get Flash Verify Start Address !!" ));
	  	goto Error;
	}

	Win32Print("DLStartAddr=0x%x chDLStartAddr = %s\n", DLStartAddr,chDLStartAddr);
	
	//Get the Image name		
	if(GetImageFileName(chImageFileName, &bCopy) == false)
	{
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error: Fail to get the Image name !!" ));
		goto Error;
	}

	Win32Print("chImageFileName = %s\n", chImageFileName);

 	ThreadParam.uiFlashStartAddr =  DLStartAddr;
	ThreadParam.chImageFileName =  chImageFileName;
	
 	pThread = AfxBeginThread(FlashThread,&ThreadParam);
	((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Verify Flash is in progress! Please Waiting......"));
	bFlashOpInProgress = TRUE;

	DoEvent();  
	do   
	{  
		dwRet = ::MsgWaitForMultipleObjects(1, &pThread->m_hThread, FALSE, INFINITE, QS_ALLINPUT);  
		if (dwRet != WAIT_OBJECT_0)  
		{  
		    DoEvent();  
		}  
	} while ((dwRet != WAIT_OBJECT_0) && (dwRet != WAIT_FAILED)); 

#ifdef READ_ISO_FILE_FROM_DRIVER
	if(bCopy)
		DeleteCopyedFile(chImageFileName);
#endif	

	if(bFlashOpFail)
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Verify Flash is Fail!"));
	else		
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Verify Flash is Success!"));

	bFlashOpInProgress = FALSE;

Error:
	
	 m_FlashDownload.EnableWindow(TRUE); 
	 m_FlashVerify.EnableWindow(TRUE);
	 m_FlashErase.EnableWindow(TRUE);
	
}


void CFlashDlg::OnFalshErase()
{
   	 CWinThread* pThread = NULL;
	 DWORD dwRet = 0;
	 THREAD_PARAM ThreadParam;
	 
    int ret = 0;
    UINT    EraseStartAddrLen = 0, EraseLengthLen = 0;
    UINT    EraseStartAddr = 0, EraseLength = 0;
    CHAR    szEraseStartAddr[10] = {0}, szEraseLength[10]= {0};
    TCHAR    szFormatStr[10] = {0};

	 m_FlashDownload.EnableWindow(FALSE);   
	 m_FlashVerify.EnableWindow(FALSE);
	 m_FlashErase.EnableWindow(FALSE);

    EraseStartAddrLen = m_FlashEraseStartAddr.GetWindowText(szEraseStartAddr, 9);
    // Translate offset to number.
    if(EraseStartAddrLen == 0 ||
        sscanf(szEraseStartAddr, TEXT("%X"), &EraseStartAddr) == 0 )
    {
         ((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error:Fail to get Flash Erase Start Address !!" ));
	  goto Error;
    }
		
    EraseLengthLen = m_FlashEraseLength.GetWindowText(szEraseLength, 9);
	
    if(((CButton*)GetDlgItem(IDC_CHECK_HEX))->GetCheck())	
		strcpy(szFormatStr,  TEXT("%x"));
	else
		strcpy(szFormatStr,  TEXT("%d"));
	
    // Translate offset to number.
    if(EraseLengthLen == 0 ||
        sscanf(szEraseLength, szFormatStr, &EraseLength) == 0 )
    {    	  
         ((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error:Fail to get Flash Erase Length !!" ));
	  goto Error;
    }
	
    //check the Length is in Range?
    if (IS_HARDWARE_SERIES(8710B) )
    {   
        //check the Start Address is in Range?
    	if((EraseStartAddr & 0xFFF) != 0)
    	{
         	((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error: Flash Erase Start Address must 4K alignment !!" ));
		goto Error;
    	}
	//check the Erase Length is in Range?
    	if((EraseLength & 0xFFF) != 0)
	{
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Error: Erase Length must multiples of 4K Bytes !!" ));		
	  	goto Error;
    	}
    }	

    Win32Print("EraseStartAddr = 0x%x, EraseLength=0x%x\n",EraseStartAddr,  EraseLength);
	
	ThreadParam.ucOpCode = FLASH_ERASE;
	ThreadParam.uiFlashStartAddr = EraseStartAddr; 
	ThreadParam.uiFlashLength = EraseLength; 
	
 	pThread = AfxBeginThread(FlashThread,&ThreadParam);
	((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Erase Flash is in progress! Please Waiting......"));
	bFlashOpInProgress = TRUE;

	DoEvent();  
	do   
	{  
		dwRet = ::MsgWaitForMultipleObjects(1, &pThread->m_hThread, FALSE, INFINITE, QS_ALLINPUT);  
		if (dwRet != WAIT_OBJECT_0)  
		{  
		    DoEvent();  
		}  
	} while ((dwRet != WAIT_OBJECT_0) && (dwRet != WAIT_FAILED)); 

	if(bFlashOpFail)
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Erase Flash is Fail!"));
	else		
		((CButton*)GetDlgItem(IDC_FLASH_STATUS))->SetWindowText(TEXT("Erase Flash is Success!"));

	bFlashOpInProgress = FALSE;
Error:	
	 m_FlashDownload.EnableWindow(TRUE); 
	 m_FlashVerify.EnableWindow(TRUE);
	 m_FlashErase.EnableWindow(TRUE);
}


void CFlashDlg::OnCheckHex()
{
	if(((CButton*)GetDlgItem(IDC_CHECK_HEX))->GetCheck())
		((CButton*)GetDlgItem(IDC_STATIC_ERASE_LENGTH))->SetWindowText(TEXT("Erase Length:0x" ));
	else 
		((CButton*)GetDlgItem(IDC_STATIC_ERASE_LENGTH))->SetWindowText(TEXT("Erase Length: " ));

}


void CFlashDlg::OnClose()
{
	if(bFlashOpInProgress == TRUE)
		AfxMessageBox(TEXT("Flash Operation is in progress !!   Can not close the dialog!!     Please waiting..." ));
	else
		CDialog::OnClose();
}

