#ifndef   __USB_IO_H__
#define   __USB_IO_H__


#include <windows.h>
#include "devioctl.h"
#include <setupapi.h>
//#include <basetyps.h>
#include "usbdi.h"
#include <winioctl.h>
#include "..\RtlBluetoothMP.h"

//  Define BT HCI Max Pkt size
#define     HCI_CMD_LEN_MAX	0x102
#define     HCI_EVT_LEN_MAX	0x101
#define     HCI_ACL_LEN_MAX	0x424
#define     HCI_SCO_LEN_MAX	0x102
#define     HCI_BUF_LEN_MAX  HCI_ACL_LEN_MAX

#define LEN_0_BYTE					0
#define LEN_1_BYTE					1
#define LEN_2_BYTE					2
#define LEN_3_BYTE					3
#define LEN_4_BYTE					4
#define LEN_5_BYTE					5
#define LEN_6_BYTE					6
#define LEN_7_BYTE					7
#define LEN_8_BYTE					8

#define LEN_11_BYTE					11
#define LEN_14_BYTE					14
#define LEN_16_BYTE					16

#define LEN_512_BYTE					512


enum BT_HCI_EVENT_FIELD
{
	EVT_CODE = 0,
	EVT_PARA_LEN,
	EVT_HCI_CMD_NUM,
	EVT_CMD_OPCODE_0,
	EVT_CMD_OPCODE_1,
	EVT_STATUS,
	EVT_BYTE0,
	EVT_BYTE1,
	EVT_BYTE2,
	EVT_BYTE3,
};


static const GUID GUID_REALTEK_USB_DVBT =
{ 0x89110a6a, 0x2732, 0x4846, { 0xbe, 0xa1, 0x4c, 0x8f, 0xdc, 0x8f, 0x3, 0xd8 } };




#define USB_IOCTL_INDEX             0x0000
#define IOCTL_REGISTER_READ					CTL_CODE(FILE_DEVICE_UNKNOWN,     \
			USB_IOCTL_INDEX + 3, \
			METHOD_BUFFERED,         \
			FILE_ANY_ACCESS)
#define IOCTL_REGISTER_WRITE				CTL_CODE(FILE_DEVICE_UNKNOWN,     \
			USB_IOCTL_INDEX + 4, \
			METHOD_BUFFERED,         \
			FILE_ANY_ACCESS)

#define IOCTL_RTUSB_INTERFACE			  CTL_CODE(FILE_DEVICE_UNKNOWN,     \
			USB_IOCTL_INDEX + 7,  \
			METHOD_BUFFERED,         \
			FILE_ANY_ACCESS)

#define MAX_USB_PORT_NUMBER		2
#define NUM_HCI_COMMAND_BUFFER_LENGTH	1	//the number that the controller allows host to send command

typedef struct _USB_DEVICE_INFO
{
	HANDLE hDevice;				//device handle
	HANDLE hI0P0_Read_Intr;		//for HCI event
	HANDLE hI0P1_Write_Bulk;	//for out ACL
	HANDLE hI0P2_Read_Bulk;		//for in ACL
	HANDLE hI1P0_Write_ISO;		//for IN ISO
	HANDLE hI1P1_Read_ISO;		//for OUT ISO
#ifndef USE_CHAR_STR    
	wchar_t CompleteDeviceName[256];
#else
	char CompleteDeviceName[256];
#endif
}USB_DEVICE_INFO;

typedef struct _HCI_CMD_ACL_PACKETS_INFO
{
	//command
	unsigned char num_hci_command_packets;

	//acl (read buffer size)
	unsigned short hc_acl_data_packet_length;
	unsigned short hc_total_num_acl_data_packets;

	//sco (read buffer size)
	unsigned char hc_synchronous_data_packet_length;
	unsigned short hc_total_num_synchronous_data_packets;

	//LE
	unsigned short hc_le_data_packet_length;
	unsigned char hc_total_num_le_data_packets;
		
}HCI_CMD_ACL_PACKETS_INFO;



HANDLE
OpenOneDevice (
	IN HDEVINFO HardwareDeviceInfo,
	IN PSP_DEVICE_INTERFACE_DATA DeviceInfoData,
#ifndef USE_CHAR_STR    
    	IN wchar_t                    *devName
#else
    	IN char			    *devName
#endif    	 
	);



HANDLE
OpenUsbDevice(
	LPGUID pGuid,
	int USBPortNumber
	);



HANDLE
OpenPipe(
	int usb_port_idx,
#ifndef USE_CHAR_STR   	
	wchar_t *pipename
#else
	char *pipename
#endif	
	);



BOOL
Set_Interface1_Alternative_Number(
	int usb_port_idx,
	UINT8 alter_num,
	UINT8 inter_num
	);



int
RTK_Usb_Open(
	BASE_INTERFACE_MODULE *pBaseInterface
	);



int
RTKL_Usb_SendHCICommand(
	BASE_INTERFACE_MODULE *pBaseInterface,
	unsigned char *pWritingBuf,
	unsigned long Len
	);



int
RTKL_Usb_WaitHCIEvent(
	BASE_INTERFACE_MODULE *pBaseInterface,
	unsigned char *pReadingBuf,
	unsigned long  Len,
	unsigned long *pRetLen
	);



int
RTK_Usb_Close(
	BASE_INTERFACE_MODULE *pBaseInterface
	);



#endif

