// MPRtlBluetoothSample.cpp : Defines the entry point for the console application.
//mBT_DEVICE_REPORT

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <math.h>
#include <stdarg.h>
#include <windows.h>
#include <shellapi.h>
#include <time.h>


#define HCI_VENDOR_MP_READ_TX_POWER_INFO 0xfced

#define ESCAPE 27
//  Test 
#define HIT_ADDRESS_SET 0x000000c6967e
#define PKTTYPE_SET		BT_PKT_3DH5
#define WHITENCOEFF_SET 0x80            	 	//Disable
#define PKTCOUNT_SET		0            		//  infinite Tx packet count     
#define PAYLOADTYPE_SET  BT_PAYLOAD_TYPE_PRBS9

#define BT_TXDAC  0x0D     //  RTL8761A  : 0x0D            
                           //  RTL8822B/RTL8821C/RTL8723D :None
                           //  OTHER     :0X11						   

#define _RTK_INTRFACE_MODE_
#define AUTO_DOWN_LOAD_PATCH_CODE

#define DLL_MODE  0
#define FW_MODE   1


#define BYTE_SHIFT					8

#ifdef __cplusplus 
extern "C" { 
#endif
	/*------------------------------------------------------------------------
	/*  Note: The "RtlBluetoothMP.h" must be updated to the latest version.
	/*        please use MP Tool directory "RtlBluetoothMP.dll" file.         
	/*
	------------------------------------------------------------------------*/
#include "RtlBluetoothMP.h"
#include "bt_mp_dll_build.h"
#include "bt_user_func.h"
#include "Vendor_Interface\usbio.h"
#ifdef __cplusplus 
}
#endif


#ifdef DBG_ON
        static void DBGPRINTF(char *prompt, ...)
        {
        char buf[2048];
        va_list argptr;
        int cnt;

        va_start(argptr, prompt);
        cnt = vsprintf(buf, prompt, argptr);
        OutputDebugString(buf);
        va_end(argptr);
        return ;
        }
  
#else
	#define DBGPRINTF printf
#endif

//=========================  define ==========================================
//#define AUTO_DOWN_LOAD_PATCH_CODE
static DWORD t1,t2,tt;

//dll object
BASE_BTMPDLLObject mBaseDLLObject;
BASE_BTMPDLLObject *pBaseDLLObject=NULL;

//bt para , report , info
BT_PARAMETER mBT_PARAMETER;
BT_DEVICE_REPORT mBT_DEVICE_REPORT;
BT_CHIPINFO mBT_CHIPINFO;

//module
static BASE_INTERFACE_MODULE	*pBaseInterface=NULL;
BASE_INTERFACE_MODULE BaseInterfaceModuleMemory;
static BASE_BTMPDLL_MODULE *pBluetoothModule=NULL ;
BASE_BTMPDLL_MODULE BluetoothModuleMemory;


// 0 : max tx power index
// 1 : 1 M default tx power index 
// 2 : 2M default tx power index
// 3 : 3M default tx power index 
// 4 : LE default tx power index
#define MAX_TX_POWER_INDEX 0
#define DEFAULT_1M_TX_POWER_INDEX 1
#define DEFAULT_2M_TX_POWER_INDEX 2
#define DEFAULT_3M_TX_POWER_INDEX 3
#define DEFAULT_LE_TX_POWER_INDEX 4
unsigned char TxPowerLevelInfo[5];


unsigned long PACKHEADER_TABLE[9]=
{
0x33820,  //DH1
0x39858,  //DH3
0xA078,   //DH5
0x33820,  //2DH1
0xC050,   //2DH3
0x3F870,    //2DH5
0x15C40,  //3DH1
0x39858,  //3DH3 
0xA078	  //3DH5
	
	
};	


static int API_bt_GetChipInfo()
{

	BT_DEVICE_REPORT	*pBtReport=&mBT_DEVICE_REPORT;
	BT_CHIPINFO	        *pBTInfo=NULL;

	DBGPRINTF("\t=======================\n");
	
	if (pBluetoothModule == NULL)
	{
		DBGPRINTF(">>BluetoothModule is NULL...!!\n");
		goto error;
	}

	if (pBluetoothModule->ActionReport(pBluetoothModule,REPORT_CHIP,pBtReport) !=0)
	{
		DBGPRINTF(">>Get Chip Info is Fail...!!\n");
		goto error;
	}
	pBTInfo=  pBtReport->pBTInfo;
	memcpy(&mBT_CHIPINFO,pBTInfo,sizeof(BT_CHIPINFO));   
	DBGPRINTF("\tChipType = (%x)\n",pBTInfo->ChipType); 
	DBGPRINTF("\tHCI_SubVersion = 0x%x\n",pBTInfo->HCI_SubVersion); 
	DBGPRINTF("\tHCI_Version = 0x%x\n",pBTInfo->HCI_Version);
	DBGPRINTF("\tLMP_SubVersion = 0x%x\n",pBTInfo->LMP_SubVersion);
	DBGPRINTF("\tLMP_Version = 0x%x\n",pBTInfo->LMP_Version); 
	DBGPRINTF("\tVersion = %.2x\n",pBTInfo->Version+9); 
	DBGPRINTF("\tIs_After_PatchCode = %d\n",pBTInfo->Is_After_PatchCode);

	DBGPRINTF("\t=======================\n\n");
	
	return BT_FUNCTION_SUCCESS;

error:

	DBGPRINTF("<<API_bt_GetChipInfo : ERROR\n");
	
	return FUNCTION_ERROR;

}

static int API_bt_Download_PatchCode()
{
	BT_CHIPINFO	        *pBTInfo=&mBT_CHIPINFO;
	char *buffer = NULL;
	int lSize=0;
	int szLen=0;
	FILE *DataFile=NULL;
	/*------------------------------------------------------------------------
	/*  Note: The "patch code" must be updated to the latest version.
	/*        please use MP Tool directory file.         
	/*
	------------------------------------------------------------------------*/
	char tmp_FileName[][50]={
			{"BTPatchCode\\patch_rtl8723a.bin"}, // 0
			{"BTPatchCode\\patch_rtl8723b.bin"}, // 1
			{"BTPatchCode\\patch_rtl8821a.bin"}, // 2
			{"BTPatchCode\\patch_rtl8761a.bin"}, // 3
			{"BTPatchCode\\patch_rtl8703a.bin"}, // 4
			{"BTPatchCode\\patch_rtl8763a.bin"}, // 5
			{"BTPatchCode\\patch_rtl8703b.bin"}, // 6
			{"BTPatchCode\\patch_rtl8723c.bin"}, // 7
			{"BTPatchCode\\patch_rtl8822b.bin"}, // 8
			{"BTPatchCode\\patch_rtl8723d.bin"}, // 9
			{"BTPatchCode\\patch_rtl8821c.bin"}, // 10			
	};


	DBGPRINTF("+API_bt_Download_PatchCode\n");
	
	if (pBluetoothModule == NULL)
	{
		DBGPRINTF("  BluetoothModule is NULL...!!\n");
		goto error;
	}
	if (API_bt_GetChipInfo() !=0 )
	{
			DBGPRINTF("  Get Chip info error!!");
			goto error;
	}
	if(pBTInfo->Is_After_PatchCode)
	{
		DBGPRINTF("  Skip patch code !!\n");
		goto exit;
	}


	DataFile = fopen(tmp_FileName[pBTInfo->ChipType], "r+b");
 	if (DataFile == NULL)
	{
		DBGPRINTF("  Error File patch = %s..\n",tmp_FileName[pBTInfo->ChipType]);
		goto error;
	}	

	fseek(DataFile, 0, SEEK_END);
	lSize = ftell(DataFile);

	fseek(DataFile, 0, 0);

	buffer = (char *)malloc(lSize);
	if (!buffer)
	{
		DBGPRINTF("  Allocate File patch error = %s..\n",tmp_FileName[pBTInfo->ChipType]);
		goto error;
	}

	if (fread(buffer,1,lSize,DataFile) == 0)
	{
		goto error;
	}
	if (pBluetoothModule->DownloadPatchCode(pBluetoothModule,buffer,lSize,1) != BT_FUNCTION_SUCCESS)
	{
		DBGPRINTF("  Download patch code Faild!!..\n");
		goto error;
	}
	else
		DBGPRINTF("  Download patch code Success!!..\n");


	if (API_bt_GetChipInfo() !=0 )
	{
		DBGPRINTF("  Get Chip info error!!");
		goto error;
	}

exit:
	DBGPRINTF("-API_bt_Download_PatchCode\n");

	if (buffer)
		free(buffer);

	if (DataFile != NULL)
		fclose(DataFile);
	
	return BT_FUNCTION_SUCCESS;

error:

	DBGPRINTF("-API_bt_Download_PatchCode : ERROR\n");	
	if (buffer)
		free(buffer);

	if (DataFile != NULL)
		fclose(DataFile);
	
	return FUNCTION_ERROR;	

}

static int API_bt_SetDefaultTxDACTable()
{
	BT_PARAMETER 	*pParam=&mBT_PARAMETER;

	if (pBluetoothModule == NULL)
	{
		goto error;
	}

	pParam->ParameterIndex= SET_DEFAULT_TX_DAC_TABLE;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule)!=0)
	{
		goto error;
	}

	DBGPRINTF("  Set Default Tx DAC Table()\n");
	
	return BT_FUNCTION_SUCCESS;

error:

	DBGPRINTF("  Set Default Tx DAC Table() : ERROR\n");
	return FUNCTION_ERROR;

}



static int API_bt_SetDefaultPowerTable()
{
	BT_PARAMETER 	*pParam=&mBT_PARAMETER;

	if (pBluetoothModule == NULL)
	{
		goto error;
	}

	pParam->ParameterIndex= SET_DEFAULT_TX_GAIN_TABLE;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);	
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule)!=0)
	{
		goto error;
	}

	DBGPRINTF("  Set default Power Table()\n");
	
	return BT_FUNCTION_SUCCESS;

error:

	DBGPRINTF("  Set default Power Table() : ERROR\n");
	
	return FUNCTION_ERROR;
	
}

/* For RTL8723D/RTL8821C/RTL8822B */
void BT_GetTxDefaultPower()
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	unsigned char pData[512];
	unsigned char pEvtBuf[512];	

	printf("+BT_GetTxDefaultPower : ChipId= %d\n",pBTInfo->ChipType);


	memset(TxPowerLevelInfo, 0, LEN_5_BYTE);

	if(pBTInfo->ChipType < RTK_BT_CHIP_ID_RTL8822B)
	{
		TxPowerLevelInfo[MAX_TX_POWER_INDEX] = 7; // Max Power Index
		TxPowerLevelInfo[DEFAULT_1M_TX_POWER_INDEX ] = 6; // 1M 
		TxPowerLevelInfo[DEFAULT_2M_TX_POWER_INDEX ] = 6; // 2M
		TxPowerLevelInfo[DEFAULT_3M_TX_POWER_INDEX ] = 6; // 3M
		TxPowerLevelInfo[DEFAULT_LE_TX_POWER_INDEX ] = 6; // LE
			
		API_bt_SetDefaultPowerTable();
		API_bt_SetDefaultTxDACTable();

	}
	else if(pBTInfo->ChipType >= RTK_BT_CHIP_ID_RTL8822B)
	{
		if(pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, HCI_VENDOR_MP_READ_TX_POWER_INFO, LEN_0_BYTE, pData, 0x0E, pEvtBuf)==BT_FUNCTION_SUCCESS)
		{
			memcpy(TxPowerLevelInfo, pEvtBuf+EVT_BYTE0, LEN_5_BYTE);			
		}
		else
		{
			DBGPRINTF("  BT Read Tx Default Power Info failed..\n");
		}
	}

	DBGPRINTF("-Max Tx Power Index:(%d), Default Power Index:(1M %d),(2M %d),(3M %d),(LE %d)",TxPowerLevelInfo[0], TxPowerLevelInfo[1], TxPowerLevelInfo[2], TxPowerLevelInfo[3], TxPowerLevelInfo[4]);
		
	return ;	

}


void BT_PktTx(BASE_BTMPDLL_MODULE  *pBtModule,int Mode)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;

	DWORD                   t1,t2,tt;
	Mode =1; 
	char ch=0;
	int rtn=0;
	int Channel=0;
	int pkt_count=0;
	int power_index=0;
	printf("\nPlease input channel =");
	scanf("%d",&Channel);
	printf("\nPlease input PKT Count=");
	scanf("%d",&pkt_count);

	memset(pBtReport,0,sizeof(BT_DEVICE_REPORT));

	/*Setting Parameter*/
	pBtParam->mChannelNumber=(unsigned char)Channel&0xFF;
	pBtParam->mPacketType=PKTTYPE_SET;

	if(pBTInfo->ChipType >= RTK_BT_CHIP_ID_RTL8822B)
	{
		if(pBtParam->mPacketType<= BT_PKT_1DH5)
		{
			pBtParam->mTxGainIndex = TxPowerLevelInfo[DEFAULT_1M_TX_POWER_INDEX];
		}
		else if(pBtParam->mPacketType<= BT_PKT_2DH5)
		{
			pBtParam->mTxGainIndex = TxPowerLevelInfo[DEFAULT_2M_TX_POWER_INDEX];
		}
		else if(pBtParam->mPacketType<= BT_PKT_3DH5)
		{
			pBtParam->mTxGainIndex = TxPowerLevelInfo[DEFAULT_3M_TX_POWER_INDEX];
		}
		
		pBtParam->ParameterIndex=FW_PACKET_TX_START;
	}
	else
	{
		///////////////////////////////////////////////
		//BT Default Power Index
		//Name                   USB/PCIE       UART  
		//RTK_BT_CHIP_ID_RTL8723A  6         6
		//RTK_BT_CHIP_ID_RTL8723B  5         4
		//RTK_BT_CHIP_ID_RTL8821A  6         6
		//RTK_BT_CHIP_ID_RTL8761A  6         6
		//RTK_BT_CHIP_ID_RTL8703A  6         6
		//RTK_BT_CHIP_ID_RTL8763A  6         6
		//RTK_BT_CHIP_ID_RTL8703B  6         6
		//RTK_BT_CHIP_ID_RTL8723C  6         6
		//RTK_BT_CHIP_ID_RTL8822B  Get MAX_TX_POWER_INDEX
		//RTK_BT_CHIP_ID_RTL8723D  Get MAX_TX_POWER_INDEX
		//RTK_BT_CHIP_ID_RTL8821C  Get MAX_TX_POWER_INDEX		
		/////////////////////////////////////////////

		pBtParam->mTxGainIndex=0x6;
		pBtParam->ParameterIndex=PACKET_TX_START;
	}
	
	pBtParam->mTxPacketCount=pkt_count;
	pBtParam->mPayloadType=PAYLOADTYPE_SET;
	pBtParam->mTxDAC=BT_TXDAC; //Realtek Define 
	pBtParam->mWhiteningCoeffValue=WHITENCOEFF_SET;
	pBtParam->mPacketHeader= PACKHEADER_TABLE[PKTTYPE_SET];
	pBtParam->mHitTarget=HIT_ADDRESS_SET;
	pBtParam->mChannelNumber =Channel;

	printf("ActionControlExcute(%d)!!\n",pBtParam->ParameterIndex);
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	
	/*Excute the Parameter*/
	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute Pkt-Tx begin Fail!!\n");
		goto exit;
	}
	else
		printf("Excute Pkt-Tx begin Success!!\n");


	t1=GetTickCount();
	tt=0;
	printf("please ESC any is exit ...\n");

	while(1)
	{ 
		if ( kbhit())
		{
			ch=getch();
			if (ch == ESCAPE )
				break;
		}
		t2=GetTickCount();
		tt=labs(t2-t1);
		/*Report TX/RX info */
		pBtModule->ActionReport(pBtModule,REPORT_PKT_TX,pBtReport);

		printf("Excute Pkt-Tx Updata!!Tx Bits = %d Tx Count=%d (%d)\n"
			,pBtReport->TotalTXBits
			,pBtReport->TotalTxCounts
			,tt);
	
		Sleep(1000);

	}
	//Stop

	pBtParam->ParameterIndex=PACKET_TX_STOP;
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute Pkt-Tx Stop  Error!!\n");
	}
	else
		printf("Excute Pkt-Tx Stop  Success!!\n"); 

exit:
	return ;


}
void BT_PktRx(BASE_BTMPDLL_MODULE  *pBtModule,int Mode)
{

	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;
	DWORD                   t1,t2,tt; 
	float ber=0;
	float all_bits=0;
	int rtn=0;
	char ch=0;
	int Channel=0;
	printf("\nPlease input channel =");
	scanf("%d",&Channel);
	memset(pBtReport,0,sizeof(BT_DEVICE_REPORT));
	
	/*Setting Parameter*/
    	pBtParam->mChannelNumber=(unsigned char)Channel&0xFF;
    	pBtParam->mPacketType=PKTTYPE_SET;
	    pBtParam->mPayloadType=PAYLOADTYPE_SET; //BT_PAYLOAD_TYPE_ALL0
    	pBtParam->mWhiteningCoeffValue=WHITENCOEFF_SET;

        pBtParam->mHitTarget=HIT_ADDRESS_SET;

		if (Mode == FW_MODE) //RTL8723D/RTL8822B/RTL8821C
		pBtParam->ParameterIndex=FW_PACKET_RX_START;
		else //RTL8761A/RTL8723B/RTL8821A	
		pBtParam->ParameterIndex=PACKET_RX_START;	
		

	printf("ActionControlExcute(%d)!!\n",pBtParam->ParameterIndex);
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	/*Excute the Parameter*/
	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute Pkt-Rx begin Fail!!\n");
		goto exit;
	}
	else
		printf("Excute Pkt-Rx begin Success!!\n");


	t1=GetTickCount();
	tt=0;

	pBtParam->ParameterIndex =REPORT_CLEAR;
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute Reset RX Report Fail!!\n");
	}
	else
		printf("Excute Reset RX Report Success!!\n");
     
	 printf("Please click ESC key pressed to exit...\n");

	while(1)
	{ 

		if ( kbhit())
		{
			ch=getch();
			if (ch == ESCAPE )
	 		break;
		}
		t2=GetTickCount();
		tt=labs(t2-t1);

		/*Report TX/RX info */
		pBtModule->ActionReport(pBtModule,REPORT_RKT_RX,pBtReport);
		ber=0;
		all_bits=(float)(pBtReport->TotalRxErrorBits+pBtReport->TotalRXBits);

		if ((pBtReport->TotalRXBits ==0) || (pBtReport->TotalRxCounts==0))
			ber=1;
		else
			ber=(float)  ((float)(pBtReport->TotalRxErrorBits))/  ((float)(all_bits));
       	
			printf("Pkt-Rx [R1]:RX_Recv_PktCnt= %d Rx_PktCnt=%d Ber=%f\n",pBtReport->RXRecvPktCnts,pBtReport->TotalRxCounts,ber);   
			printf("Pkt-Rx [R2]:Total Rx_Bits = %d Total Rx_error_Bits=%d Total RX_BER=%f\n",pBtReport->TotalRXBits,pBtReport->TotalRxErrorBits,pBtReport->ber);
			printf("Pkt-Rx [R3]:RSSI=%d(%d)  \n",pBtReport->RxRssi,tt);
			Sleep(1000);

	}
	//Stop
	pBtParam->ParameterIndex=PACKET_RX_STOP;
	pBtModule->UpDataParameter(pBtModule,pBtParam);
        if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
        {
                printf("Excute Pkt-Rx Stop  Error!!\n");
        }
        else
                printf("Excute Pkt-Rx Stop  Success!!\n"); 
exit:
	return ;


}
void BT_ConTx(BASE_BTMPDLL_MODULE  *pBtModule,int Mode)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;

	char ch=0;

	DWORD                t1,t2,tt; 
	int Channel=0;
	printf("\nPlease input channel =");
	scanf("%d",&Channel);
	memset(pBtReport,0,sizeof(BT_DEVICE_REPORT));
	
	/*Setting Parameter*/
    	pBtParam->mChannelNumber=(unsigned char)Channel&0xFF;

    	pBtParam->mPacketType=BT_PKT_3DH5;
		
	if(pBTInfo->ChipType >= RTK_BT_CHIP_ID_RTL8822B)
	{
		if(pBtParam->mPacketType<= BT_PKT_1DH5)
		{
			pBtParam->mTxGainIndex = TxPowerLevelInfo[DEFAULT_1M_TX_POWER_INDEX];
		}
		else if(pBtParam->mPacketType<= BT_PKT_2DH5)
		{
			pBtParam->mTxGainIndex = TxPowerLevelInfo[DEFAULT_2M_TX_POWER_INDEX];
		}
		else if(pBtParam->mPacketType<= BT_PKT_3DH5)
		{
			pBtParam->mTxGainIndex = TxPowerLevelInfo[DEFAULT_3M_TX_POWER_INDEX];
		}
	}
	else
	{
		///////////////////////////////////////////////
		//BT Default Power Index
		//Name                   USB/PCIE       UART  
		//RTK_BT_CHIP_ID_RTL8723A  6         6
		//RTK_BT_CHIP_ID_RTL8723B  5         4
		//RTK_BT_CHIP_ID_RTL8821A  6         6
		//RTK_BT_CHIP_ID_RTL8761A  6         6
		//RTK_BT_CHIP_ID_RTL8703A  6         6
		//RTK_BT_CHIP_ID_RTL8763A  6         6
		//RTK_BT_CHIP_ID_RTL8703B  6         6
		//RTK_BT_CHIP_ID_RTL8723C  6         6
		//RTK_BT_CHIP_ID_RTL8822B  Get MAX_TX_POWER_INDEX
		//RTK_BT_CHIP_ID_RTL8723D  Get MAX_TX_POWER_INDEX
		//RTK_BT_CHIP_ID_RTL8821C  Get MAX_TX_POWER_INDEX		
		/////////////////////////////////////////////

		pBtParam->mTxGainIndex=0x6;
	}
    	pBtParam->mTxGainValue=0xFF;
    	pBtParam->mTxPacketCount=0;
    	pBtParam->mPayloadType=BT_PAYLOAD_TYPE_ALL0;
    	pBtParam->mWhiteningCoeffValue=WHITENCOEFF_SET; 
		pBtParam->mPacketHeader= PACKHEADER_TABLE[BT_PKT_3DH5];
		pBtParam->mHitTarget=0x0000009e8b33;
		
		if (Mode == FW_MODE) //RTL8723D/RTL8822B/RTL8821C
		pBtParam->ParameterIndex=FW_CONTINUE_TX_START;
		else //RTL8761A/RTL8723B/RTL8821A	
		pBtParam->ParameterIndex=CONTINUE_TX_START;
  	
   	printf("ActionControlExcute(%d)!!\n",pBtParam->ParameterIndex);
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	/*Excute the Parameter*/
	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute Con-Tx begin Fail!!\n");
		goto exit;
	}
	else
		printf("Excute Con-Tx begin Success!!\n");

	t1=GetTickCount();
	tt=0;

	while(1)
        { 
		t2=GetTickCount();
		tt=labs(t2-t1);

		if ( kbhit())
		{
			ch=getch();
			if (ch == ESCAPE )
	 			break;
		}
		/*Report TX/RX info */
		pBtModule->ActionReport(pBtModule,REPORT_CON_TX,pBtReport);

		printf("Excute Con-Tx Updata!!Tx Bits = %d Tx Count=%d (%d)\n",pBtReport->TotalTXBits
										,pBtReport->TotalTxCounts,tt);
		Sleep(1000);

	}
	//Stop
	pBtParam->ParameterIndex=CONTINUE_TX_STOP;
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
                printf("Excute Con-Tx Stop  Error!!\n");
	}
	else
                printf("Excute Con-Tx Stop  Success!!\n"); 
exit:
	return ;
}

void BT_HciReset(BASE_BTMPDLL_MODULE  *pBtModule)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;


	/*Setting Parameter*/
	pBtParam->ParameterIndex=HCI_RESET;

	pBtModule->UpDataParameter(pBtModule,pBtParam);

	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute HCI Reset Fail!!\n");
		goto exit;
	}
	else
		printf("Excute HCI Reset Success!!\n");
exit:
	return ;
}


void BT_TestMode(BASE_BTMPDLL_MODULE  *pBtModule)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;


	/*Setting Parameter*/
	pBtParam->ParameterIndex=TEST_MODE_ENABLE;

	pBtModule->UpDataParameter(pBtModule,pBtParam);

	if (pBtModule->ActionControlExcute(pBtModule) != BT_FUNCTION_SUCCESS)
	{
		printf("Excute Test Mode Fail!!\n");
		goto exit;
	}
	else
		printf("Excute Test Mode Success!!\n");
exit:
	return ;
}



void BT_ReadBDAddr(BASE_BTMPDLL_MODULE  *pBtModule)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;
	
	unsigned char *pPGRawData;
	unsigned char *pReportData;	

	pBtParam->ParameterIndex = READ_EFUSE_DATA;
	pPGRawData = pBtParam->mPGRawData;
	pReportData = pBtReport->ReportData;

	pPGRawData[0] = 0x01; // BT Efuse
	pPGRawData[1] = 0x3c;
	pPGRawData[2] = 0x00;
	pPGRawData[3] = 0x06;
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	if (pBtModule->ActionControlExcute(pBtModule) !=0)
	{
		printf("Excute BT_ReadBDAddr Fail!!\n");
	}
	else
	{
		memset(pReportData,0x00, MAX_USERAWDATA_SIZE);
		pBtModule->ActionReport(pBtModule, REPORT_LOGICAL_EFUSE, pBtReport);
		printf("BT_ReadBDAddr = 0x%.2x%.2x%.2x%.2x%.2x%.2x\n", pReportData[9], pReportData[8], pReportData[7], pReportData[6], pReportData[5], pReportData[4]);
	}

	return ;
}


void BT_WriteBDAddr(BASE_BTMPDLL_MODULE  *pBtModule)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;


	BT_PARAMETER		*pBtParam =&mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport=&mBaseModuleBtReportMemory;
	//BT_CHIPINFO	*pBTInfo=&mBT_CHIPINFO;

	printf("\nWriteBDAddr= 0x00E023345678\n");

	pBtParam->mPGRawData[0] = 0x01;  // BT Efuse
	pBtParam->mPGRawData[1] = 0x3c;  // offset low byte
	pBtParam->mPGRawData[2] = 0x00;  // offset high byte
	pBtParam->mPGRawData[3] = 0x06;  // len
	pBtParam->mPGRawData[4] = 0x78;  //BD ADDR data
	pBtParam->mPGRawData[5] = 0x56;  //BD ADDR data
	pBtParam->mPGRawData[6] = 0x34;  //BD ADDR data
	pBtParam->mPGRawData[7] = 0x23;  //BD ADDR data
	pBtParam->mPGRawData[8] = 0xe0;  //BD ADDR data
	pBtParam->mPGRawData[9] = 0x22; //BD ADDR data
	pBtParam->ParameterIndex = WRITE_EFUSE_DATA;
	pBtModule->UpDataParameter(pBtModule,pBtParam);
	if(pBtModule->ActionControlExcute(pBtModule)!=0)
	{
		printf("Excute BT_WriteBDAddr Fail!!\n");
	}
	else
	{
		printf("Excute BT_WriteBDAddr Success!!\n");

	}

	return ;
}


void BT_GetBDAddr()
{
	unsigned char	pEvt[512] = {0};
	unsigned char	para[256] = {0};
	if (pBluetoothModule == NULL)
	{
		DBGPRINTF(">>BluetoothModule is NULL...!!\n");
		goto error;
	}	
	memset(pEvt,0,512);
	if (pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule,0x1009,0,NULL,0x0e,pEvt) != 0)
	{
		printf("Get BD Addree Fail!!..\n");
		goto error;
	}
	printf("BD_ADDR=[0x%.2x%.2x%.2x%.2x%.2x%.2x]\n",pEvt[11],pEvt[10],pEvt[9],pEvt[8],pEvt[7],pEvt[6]);
error:

	return ;	
}



//////////////////////////////////
//Led No
// 0 : LED 0 is GPIO 4
// 1 : LED 1 is GPIO 5 

//Led Level
// 0 : output low   
// 1 : output high
// 2 : output Hi-Z or input
//////////////////////////////////
void BT_LedTest(BASE_BTMPDLL_MODULE  *pBtModule, unsigned char LedNo, unsigned char LedLevel)
{
	unsigned char pData[512];
	unsigned char pEvtBuf[512];

	pData[0] = LedNo;
	pData[1] = LedLevel;
	
	if(pBtModule == NULL)
	{
		return;
	}

	pBtModule->SendHciCommandWithEvent(pBtModule, 0xfc37, 2, pData, 0x0E, pEvtBuf);

	if(pEvtBuf[5] != 0)
	{
		DBGPRINTF(">>BT_LedTest : error\n");
	}
	else
	{
		DBGPRINTF(">>BT_LedTest : successful\n");
	}

	return;
	
}

void BT_LeTest_4_0_Start(int isTx)
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;

	unsigned char LeTest_Channel = 0; //from 0 ~39
	unsigned char LeTest_DataLen = 0x25; //from 0x00~0x25
	unsigned char LeTest_PayloadType =BT_LE_PAYLOAD_TYPE_PRBS9; //refer structure "BT_LE_PAYLOAD_TYPE"
	unsigned long LeTest_TxGainIndex = TxPowerLevelInfo[DEFAULT_LE_TX_POWER_INDEX];

	if (pBluetoothModule == NULL)
	{
		printf(">>BluetoothModule is NULL...!!\n");
		return;
	}

	if(isTx)
	{
		pParam->mChannelNumber= LeTest_Channel;
		pParam->mParamData[0] = LeTest_DataLen;
		pParam->mPayloadType= LeTest_PayloadType;
		pParam->mTxGainIndex = (unsigned char)(LeTest_TxGainIndex);
		pParam->ParameterIndex = LE_TX_DUT_TEST_CMD;
		printf(">>LeTest_Start : PKT TX\n");
	}
	else
	{
		pParam->mChannelNumber= LeTest_Channel;
		pParam->ParameterIndex = LE_RX_DUT_TEST_CMD;
		printf(">>LeTest_Start : PKT RX\n");
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		printf(">>ActionControlExcute(%d) Fail...!!\n", pParam->ParameterIndex);
		return;
	}
	
	return;
}


void BT_LeTest_5_0_Start(int isTx)
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;

	unsigned char LeTest_Channel = 0; //from 0 ~39
	unsigned char LeTest_DataLen = 0xff; //from 0x00~0xff
	unsigned char LeTest_PayloadType =BT_LE_PAYLOAD_TYPE_PRBS9; //refer structure "BT_LE_PAYLOAD_TYPE"
	unsigned long LeTest_TxGainIndex = TxPowerLevelInfo[DEFAULT_LE_TX_POWER_INDEX];

	if (pBluetoothModule == NULL)
	{
		printf(">>BluetoothModule is NULL...!!\n");
		return;
	}

	if(isTx)
	{
		pParam->mChannelNumber= LeTest_Channel;
		pParam->mParamData[0] = LeTest_DataLen;
		pParam->mPayloadType= LeTest_PayloadType;
		pParam->PHY = LE5_TX_2M_PHY;				//refer to "BT_LE5_TX_PHY"
		pParam->mTxGainIndex = (unsigned char)(LeTest_TxGainIndex);
		
		pParam->ParameterIndex = LE_TX_DUT_TEST_CMD;
		printf(">>LeTest_Start : PKT TX\n");
	}
	else
	{
		pParam->mChannelNumber= LeTest_Channel;
		pParam->PHY = LE5_RX_2M_PHY;				//refer to "BT_LE5_RX_PHY"
		pParam->ModulationIndex = STANDARD_MODULATION_INDEX; //refer to "BT_LE50_MODULATION_INDEX"
		
		pParam->ParameterIndex = LE_RX_DUT_TEST_CMD;
		printf(">>LeTest_Start : PKT RX\n");
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		printf(">>ActionControlExcute(%d) Fail...!!\n", pParam->ParameterIndex);
		return;
	}
	
	return;
}


void BT_LeTest_Start(int isTx)
{
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	if(pBTInfo->ChipType >= RTK_BT_CHIP_ID_RTL8763B)
	{
		//BT 5.0
		BT_LeTest_5_0_Start(isTx);
	}
	else
	{
		//BT 4.0
		BT_LeTest_4_0_Start(isTx);	
	}
	return;
}


//---------------------------------------------------------------------------



void BT_LeTest_Stop()
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;

	if (pBluetoothModule == NULL)
	{
		printf(">>BluetoothModule is NULL...!!\n");
		return;
	}

	pParam->ParameterIndex = LE_DUT_TEST_END_CMD;

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		printf(">>ActionControlExcute(%d) Fail...!!\n", pParam->ParameterIndex);
		return;
	}

	pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LE_RX, &mBT_DEVICE_REPORT);


	printf(">>Total Rx Packets %d\n", mBT_DEVICE_REPORT.TotalRxCounts);

	return;
}


void BT_ReadThermalMeter(unsigned char *pCurrThermalValue)
{
	BT_PARAMETER	     mBaseBtParamMemory;
	BT_CHIPINFO			 mBaseBTInfoMemory;
	BT_DEVICE_REPORT	 mBaseModuleBtReportMemory;

	BT_PARAMETER		*pBtParam = &mBaseBtParamMemory;
	BT_DEVICE_REPORT	*pBtReport = &mBaseModuleBtReportMemory;
	BT_CHIPINFO			*pBTInfo = &mBaseBTInfoMemory;


	DBGPRINTF(">>++BT_ReadThermalMeter()\n"); 
	

	if(pBluetoothModule->ActionReport(pBluetoothModule, REPORT_THERMAL, pBtReport)!= BT_FUNCTION_SUCCESS)
	{
			printf("Excute Read Thermal Meter Fail!!\n");
			
			goto error;
	}

	*pCurrThermalValue =(UINT8)pBtReport->CurrThermalValue; 

	printf("Thermal Value 0x%x",*pCurrThermalValue);

	return;

	DBGPRINTF("<<--BT_ReadThermalMeter()\n");

error:
	return;
}


void BT_WriteMpParamterToEfuse(unsigned char Index, unsigned char *pData)
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	unsigned char *pPGRawData;
	int n=0;

	DBGPRINTF(">>++RTKBT_WriteMpParamterToEfuse()\n");

	pParam->ParameterIndex = WRITE_EFUSE_DATA;
	pPGRawData = pParam->mPGRawData;
	memset(pPGRawData,0x00,256);

	
	if (Index == SET_INDEX_BT_ADDR)
	{
		if ((pData[0] != 0x00) || (pData[1] != 0x00) ||(pData[2] != 0x00)
		||  (pData[3] != 0x00)|| (pData[4] != 0x00) ||(pData[5] != 0x00))
		{
			pPGRawData[0] = 0x01; // BT Efuse
			pPGRawData[1] = 0x3c; // offset low byte
			pPGRawData[2] = 0x00; // offset high byte
			pPGRawData[3] = 0x06; // len
			for (n=0; n < 6; n++) // 6-byte mac addr
				pPGRawData[n+4]= pData[n];
		}
	}
	else if (Index == SET_INDEX_TX_POWER_DAC)
	{
		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x60; // offset low byte
		pPGRawData[2] = 0x01; // offset high byte
		pPGRawData[3] = 0x02; // len
		pPGRawData[4] = 0xfe; // low byte value
		pPGRawData[5] = pData[0]; // dac value
	}
	else if (Index == SET_INDEX_THERMAL)
	{
		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x80; // offset low byte
		pPGRawData[2] = 0x01; // offset high byte
		pPGRawData[3] = 0x02; // len
		pPGRawData[4] = 0x00; // low byte value
		pPGRawData[5] = pData[0]; // thermal value
	}
	else if(Index == SET_INDEX_XTAL)
	{
		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0xe6; // offset low byte
		pPGRawData[2] = 0x01; // offset hight byte
		pPGRawData[3] = 0x01; // len
		pPGRawData[4] = pData[0] & 0x3f; // 1-byte crystal	
	}
	else if(Index == SET_INDEX_USB_VID_PID)
	{
		pPGRawData[0] = 0x02; // SYS Efuse
		pPGRawData[1] = 0x24; // offset low byte
		pPGRawData[2] = 0x00; // offset high byte
		pPGRawData[3] = 0x04; // len
		for (n = 0; n < 4; n++) // 4-byte usb vid, pid
			pPGRawData[n+4] = pData[n];	
	}		
	else
	{
		DBGPRINTF(">>No Write efuse MP Data...\n");	
		return;
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);


	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		DBGPRINTF(">>Raw Data Exec Fail...\n");
		goto exit;
	}
	else
	{
		DBGPRINTF(">>Raw Data Exec Success...\n");
	}


exit:

	DBGPRINTF(">>--RTKBT_WriteMpParamterToEfuse\n");
	
	return;
}



void BT_ReadUserDefinedFromEfuse(unsigned char *pData)
{
	BT_PARAMETER *pBtParam=&mBT_PARAMETER;
	BT_DEVICE_REPORT *pBtReport= &mBT_DEVICE_REPORT;

	unsigned char *pReportData;
	unsigned char *pPGRawData;

	pPGRawData = pBtParam->mPGRawData;
	pReportData = pBtReport->ReportData;

	pBtParam->ParameterIndex = READ_EFUSE_DATA;
	
	memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

	pPGRawData[0] = 0x03;
	pPGRawData[1] = 0xF8;//0xF8;
	pPGRawData[2] = 0x01;
	pPGRawData[3] = 0x08;

	DBGPRINTF(">>++BT_ReadUserDefinedFromEfuse() : header : 0X%02X%02X%02X%02X\n", pPGRawData[0], pPGRawData[1], pPGRawData[2], pPGRawData[3]);
	
	pBluetoothModule->UpDataParameter(pBluetoothModule,pBtParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		DBGPRINTF(">>BT_ReadUserDefinedFromEfuse Exec Fail...\n");
	}
	else
	{
		memset(pReportData,0x00, MAX_USERAWDATA_SIZE);
		pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);
		DBGPRINTF("0X%02X%02X%02X%02X%02X%02X%02X%02X\n",pReportData[11], pReportData[10],pReportData[9], pReportData[8], pReportData[7], pReportData[6], pReportData[5], pReportData[4]);
		memcpy(pData, pReportData+LEN_4_BYTE, LEN_8_BYTE);
	}



	return;
}


void BT_WriteUserDefinedToEfuse()
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	unsigned char *pPGRawData;

	pPGRawData = pParam->mPGRawData;

	pParam->ParameterIndex = WRITE_EFUSE_DATA;
	
	memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

	pPGRawData[0] = 0x03; // BT Efuse
	pPGRawData[1] = 0xF8; // offset low byte
	pPGRawData[2] = 0x01; // offset high byte

	pPGRawData[3] = 0x08;  //Len 

	//***+user defined data 8 bytes***//
	pPGRawData[4] = 0x0a;
	pPGRawData[5] = 0x0b; 
	pPGRawData[6] = 0x0c; 
	pPGRawData[7] = 0x0d;
	pPGRawData[8] = 0x01;
	pPGRawData[9] = 0x02;
	pPGRawData[10] = 0x03;
	pPGRawData[11] = 0x04;
	//***-user defined data 8 bytes***//

	DBGPRINTF(">>++BT_WriteUserDefinedToEfuse() : header : 0X%02X%02X%02X%02X\n", pPGRawData[0], pPGRawData[1], pPGRawData[2], pPGRawData[3]);
	
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		DBGPRINTF(">>BT_WriteUserDefinedToEfuse Exec Fail...\n");
		goto exit;
	}
	else
	{
		DBGPRINTF(">>BT_WriteUserDefinedToEfuse Success...\n");
	}


exit:

	DBGPRINTF(">>BT_WriteUserDefinedToEfuse\n");
	
	return;
}



#define HCI_VENDOR_FT_SET_EFUSE_BYTES 0xFCEE
#define HCI_VENDOR_FT_GET_EFUSE_BYTES 0xFCEF

enum
{
	FW_R0_TYPE_10K = 10,		// 10K
	FW_R0_TYPE_15K = 15,		// 1.5k
};

#define READ_WRITE_EFUSE_REG_MAX_LEN 32


int
BTDevice_Fw_IO_Efuse_SetBytes(
	int R0Type,
	int Bank,
	int RegStartAddr,
	unsigned int ByteNum,	
	unsigned char *pWritingBytes
	)
{
	unsigned char pData[LEN_512_BYTE];
	unsigned char pEvtBuf[LEN_512_BYTE];

	pData[0] = Bank;
	pData[1] = ByteNum;
	pData[2] = R0Type;
	pData[3] = (unsigned char) (RegStartAddr&0xff);
	pData[4] = (unsigned char) ((RegStartAddr>>BYTE_SHIFT)&0xff);

	memcpy(pData+LEN_5_BYTE, pWritingBytes, ByteNum);


	if(pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, HCI_VENDOR_FT_SET_EFUSE_BYTES, ByteNum+LEN_5_BYTE, pData, 0x0E, pEvtBuf))
		goto error;

	return BT_FUNCTION_SUCCESS;

error:

	return FUNCTION_ERROR;

}



int
BTDevice_Fw_IO_Efuse_GetBytes(
	int R0Type,
	int Bank,
	int RegStartAddr,
	unsigned int ByteNum,
	unsigned char *pReadingBytes
	)
{

	unsigned char pData[LEN_512_BYTE];
	unsigned char pEvtBuf[LEN_512_BYTE];

	pData[0] = Bank;
	pData[1] = ByteNum;
	pData[2] = R0Type;
	pData[3] = (unsigned char) (RegStartAddr&0xff);
	pData[4] = (unsigned char) ((RegStartAddr>>BYTE_SHIFT)&0xff);

	if(pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, HCI_VENDOR_FT_GET_EFUSE_BYTES, LEN_5_BYTE, pData, 0x0E, pEvtBuf))
		goto error;

	memcpy(pReadingBytes, pEvtBuf+EVT_BYTE0, ByteNum);

	return BT_FUNCTION_SUCCESS;

error:

	return FUNCTION_ERROR;

}



int
BTDevice_Fw_Efuse_SetBytes(
	int Bank,
	int RegStartAddr,
	unsigned int ByteNum,	
	unsigned char *pWritingBytes
	)
{

	unsigned int i, j;

	unsigned int WritingByteNum, WritingByteNumRem;
	unsigned int RegWritingAddr;

	unsigned char pReadingBytes[READ_WRITE_EFUSE_REG_MAX_LEN];
	unsigned char times;	

	for(i = 0; i < ByteNum; i += READ_WRITE_EFUSE_REG_MAX_LEN)
	{	
		times = 0;
		
		// Set register reading address.
		RegWritingAddr = RegStartAddr + i;

		// Calculate remainder reading byte number.
		WritingByteNumRem = ByteNum - i;

		// Determine reading byte number.
		WritingByteNum = (WritingByteNumRem > READ_WRITE_EFUSE_REG_MAX_LEN) ? READ_WRITE_EFUSE_REG_MAX_LEN : WritingByteNumRem;
retry:
		times++;

		if( times == 1 )
		{
			//set LDO 1.5K 
			if(BTDevice_Fw_IO_Efuse_SetBytes(FW_R0_TYPE_15K, Bank, RegWritingAddr, WritingByteNum, pWritingBytes+i)!=BT_FUNCTION_SUCCESS)
				goto error;
		}
		else if( times == 2)
		{
			//set LDO 10K
			if(BTDevice_Fw_IO_Efuse_SetBytes(FW_R0_TYPE_10K, Bank, RegWritingAddr, WritingByteNum, pWritingBytes+i)!=BT_FUNCTION_SUCCESS)
				goto error;
		}
		else
		{
			DBGPRINTF(" BTDevice_Fw_Efuse_SetBytes : write error and retry\n");
			goto error;
		}

		if(BTDevice_Fw_IO_Efuse_GetBytes(FW_R0_TYPE_15K, Bank, RegWritingAddr, WritingByteNum, pReadingBytes)!=BT_FUNCTION_SUCCESS)
			goto error;

		for (j=0; j<WritingByteNum; j++)
		{
			if (pReadingBytes[j] != pWritingBytes[i+j])
			{
				goto retry;
			}
		}		

	}

	return BT_FUNCTION_SUCCESS;

error:
	return FUNCTION_ERROR;

}



int
BTDevice_Fw_Efuse_GetBytes(
	int Bank,
	int RegStartAddr,
	unsigned int ByteNum,
	unsigned char *pReadingBytes
	)
{
	unsigned int i;

	unsigned int ReadingByteNum, ReadingByteNumRem;
	unsigned int RegReadingAddr;

	for(i = 0; i < ByteNum; i += READ_WRITE_EFUSE_REG_MAX_LEN)
	{
		// Set register reading address.
		RegReadingAddr = RegStartAddr + i;

		// Calculate remainder reading byte number.
		ReadingByteNumRem = ByteNum - i;

		// Determine reading byte number.
		ReadingByteNum = (ReadingByteNumRem > READ_WRITE_EFUSE_REG_MAX_LEN) ? READ_WRITE_EFUSE_REG_MAX_LEN : ReadingByteNumRem;
		
		if(BTDevice_Fw_IO_Efuse_GetBytes(FW_R0_TYPE_15K, Bank, RegReadingAddr, ReadingByteNum, pReadingBytes+i)!=BT_FUNCTION_SUCCESS)
			goto error;		
	}

	return BT_FUNCTION_SUCCESS;

error:
	return FUNCTION_ERROR;


}


int BTDevice_SetThermalPowerTracking(unsigned char OnOff)
{

	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	if(pBluetoothModule == NULL)
	{
		DBGPRINTF(">>BluetoothModule is NULL...!!\n");
		goto error;
	}

	pParam->ParameterIndex = TX_POWER_TRACKING;

	pParam->mParamData[0] = 0; //set
	pParam->mParamData[1] = OnOff; //on(1) or off(0)

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		DBGPRINTF("Set Power Tracking failed");
		goto error;
 	}
	else
	{
		DBGPRINTF("Set Power Tracking : %d",OnOff);
	
 	}

	return BT_FUNCTION_SUCCESS;

error:
	return FUNCTION_ERROR;	
}


int BTDevice_BBPro_WriteToFlashConfig(unsigned char CrystalValue)
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	BT_DEVICE_REPORT *pModuleBtReport=&mBT_DEVICE_REPORT;

	if(pBluetoothModule == NULL)
	{
		DBGPRINTF(">>BluetoothModule is NULL...!!\n");
		goto error;
	}

	if(pModuleBtReport->pBTInfo->ChipType!=RTK_BT_CHIP_ID_RTL8763B)
	{
		goto error;
	}

	pParam->ParameterIndex = WRITE_FLASH_CONFIG;

	pParam->mParamData[0] = 0xa;
	pParam->mParamData[1] = 0x0;
	
	//0x5B, 0x04, 0x01, value, 0x7F
	pParam->mParamData[2] = 0x5B;
	pParam->mParamData[3] = 0x04;
	pParam->mParamData[4] = 0x01;
	pParam->mParamData[5] = CrystalValue;
	pParam->mParamData[6] = 0xFF;

	//0x45C
	pParam->mParamData[7] = 0x5C;
	pParam->mParamData[8] = 0x04;
	pParam->mParamData[9] = 0x01;
	pParam->mParamData[10] = CrystalValue;
	pParam->mParamData[11] = 0xFF;

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionControlExcute(pBluetoothModule) != BT_FUNCTION_SUCCESS)
		goto error;

	DBGPRINTF("Write Crystal value To Flash Config successfully....");

	return BT_FUNCTION_SUCCESS;

error:

	DBGPRINTF("Write Crystal value To Flash Config error....");
	
	return FUNCTION_ERROR;	
		  
}
	


int main(int argc, char* argv[])
{
	int PortNumber=4;
	int item=0;
	int bflag=0;
	unsigned char pData[MAX_DATA_LEN];

	unsigned char thermal;
	
	int HOST=1;  //0:usb ,1:uart 2:filter uart

	DBGPRINTF("============ MP RtlBluetooth DLL Sample Code ==========\n");
	// 
	//>>Load RtlBluetoothMP.dll
	/*------------------------------------------------------------------------
	/*  Note: The "RtlBluetoothMP.dll" must be updated to the latest version.
	/*        please use MP Tool directory "RtlBluetoothMP.dll" file.         
	/*
	------------------------------------------------------------------------*/
	//>>Build Software interface Module
	//>>Build Software Bluetooth Module 
	// 
	pBaseDLLObject = &mBaseDLLObject;
	if (BuildBTMPDLLObject(pBaseDLLObject,NULL)!=0)
	{
		DBGPRINTF(">>Build RtlBluetoothMP.dll Module Fail!!\n");
		goto exit;
	}
	
	DBGPRINTF(">>Load RtlBluetoothMP.dll Module Success!!\n");

	DBGPRINTF("\n\n");
	DBGPRINTF("*Interface Type : \n");
	DBGPRINTF("* 0. USB (Default) \n");
	DBGPRINTF("* 1. UART\n");
	DBGPRINTF("* 2. Filter Uart\n");
	DBGPRINTF("* Please Input interface Type: ");
	scanf("%d",&HOST);

	switch (HOST)
	{
		default: 
		case 0:	
			DBGPRINTF("* Please Input USB Port No. : ");
			scanf("%d",&PortNumber);
			break;
			
		case 1:
			DBGPRINTF("* Please Input UART Com Port No. : ");
			scanf("%d",&PortNumber);
			break;

		case 2:
			DBGPRINTF("* Use Filter UART Interface ...\n");
			break; 	
	}

	//Use Realtek default program
	//HOST : 0 is Usb  , 1 is Uart ,2 is Filter Uart ,3AND 4  is ADB HCI interface
	//

	if(pBaseDLLObject->BTMPAPI_BuildInterfaceRTK(
		&pBaseInterface,
		&BaseInterfaceModuleMemory,
		HOST,
		PortNumber,
		(unsigned long)115200,
		pData
		)!=0)
	{
		DBGPRINTF(" Build interface Module Fail!!\n");
		goto exit;
	}


	//
	//>>Build Software Bluetooth Module  
	//
	pBluetoothModule=&BluetoothModuleMemory;
	pBluetoothModule->BuildStatus=0;
	if (pBaseDLLObject->BTMPAPI_BuildBluetoothModule(pBluetoothModule,pBaseInterface,NULL,NULL,NULL) !=0)
	{
		DBGPRINTF(" Build BT Module Fail!!\n");
		goto exit;
	}
				
	if (pBluetoothModule->BuildStatus ==0)
	{
		DBGPRINTF(" Build BT Module status Fail!!\n");
		goto exit;
	}
	
	//
	//>>Device Open
	//>>download Paatch Code
	//>>initial device 
	//
	if (pBaseInterface->Close(pBaseInterface)!=0)
	{
		DBGPRINTF(" Close Device  Fail!!\n");
		goto exit;
	}


	if (pBaseInterface->Open(pBaseInterface)!=0)
	{
		DBGPRINTF(" Open Device Fail...\n");
		goto exit;
	}



#ifdef AUTO_DOWN_LOAD_PATCH_CODE

	if (API_bt_Download_PatchCode() !=0)
	{    
		DBGPRINTF(" RTKBT_OpenAdapter : Download patch code Fail...\n");
	}
	else
	{
		DBGPRINTF(" RTKBT_OpenAdapter : Download patch code Success...\n");	
	}
		
#endif	

	BT_GetTxDefaultPower();

	while (!bflag)
	{
		DBGPRINTF("\n");
		DBGPRINTF("---Test Item---\n");
		DBGPRINTF(" 0. Exit\n");
		DBGPRINTF(" 1. PKT TX\n");
		DBGPRINTF(" 2. PKT RX\n");
		DBGPRINTF(" 3. CON TX\n");
		DBGPRINTF(" 4. Hci Reset\n");
		DBGPRINTF(" 5. Read Thermal\n");
		DBGPRINTF(" 6. Enable DUT Test Mode - Direct Test Mode \n");		
		DBGPRINTF(" ----------------- LE TX/RX -----------------\n");
		DBGPRINTF(" 7. LE TX\n");
		DBGPRINTF(" 8. LE RX\n");
		DBGPRINTF(" 9. LE TX/RX Stop\n");
		DBGPRINTF(" ----------------- BT Only Chip -----------------\n");
		DBGPRINTF(" 10. Read efuse BD Addr  ---> BT Only Chip\n");
		DBGPRINTF(" 11. Write efuse BD Addr  ---> BT Only Chip\n");		
		DBGPRINTF(" 12. Write User Defined Data To Efuse ---> BT Only Chip\n");
		DBGPRINTF(" 13. Read User Defined Data From Efuse ---> BT Only Chip\n");
		DBGPRINTF(" 14. Fw Write User Defined Data To Efuse---> BT Only Chip\n");
		DBGPRINTF(" 15. Fw Read User Defined Data From Efuse ---> BT Only Chip\n");
		DBGPRINTF(" ----------------- BT function -----------------\n");
		DBGPRINTF(" 16. Get BD ADDRESS...\n");	
		DBGPRINTF(" 17. BT_GetChipInfo...\n");	
		DBGPRINTF(" 18. BT_GetDefault TX Power Index...\n");	
   
		DBGPRINTF("--------------\n");
		DBGPRINTF("Please Input Test Item:");

		scanf("%d",&item);   fflush(stdin);
		switch (item)
		{
			case 0: bflag=1;	break;
			case 1: BT_PktTx(pBluetoothModule,DLL_MODE); break;
			case 2: BT_PktRx(pBluetoothModule,DLL_MODE); break;
			case 3: BT_ConTx(pBluetoothModule,DLL_MODE); break;
			case 4: BT_HciReset(pBluetoothModule); break;
			case 5: BT_ReadThermalMeter(&thermal); break;	
			case 6:	BT_TestMode(pBluetoothModule); break;
			
			case 7: BT_LeTest_Start(1); break;
			case 8: BT_LeTest_Start(0); break;
			case 9: BT_LeTest_Stop(); break;
			
			case 10: BT_ReadBDAddr(pBluetoothModule); break;
			case 11: BT_WriteBDAddr(pBluetoothModule); break;


			case 12: BT_WriteUserDefinedToEfuse(); break;
			case 13: BT_ReadUserDefinedFromEfuse(pData); break;
		
/*			case 99:
				//+user defined data 8 bytes//
				pData[0] = 0xFF;
				pData[1] = 0xFF; 
				pData[2] = 0xFF; 
				pData[3] = 0xFF;
				pData[4] = 0xFF;
				pData[5] = 0xFF;
				pData[6] = 0xFF;
				pData[7] = 0xCC;
				//user defined data 8 bytes//
				BTDevice_Fw_Efuse_SetBytes(1, 0x01F8, LEN_8_BYTE, pData);
				DBGPRINTF("FW Write user defined efuse = 0X%02X%02X%02X%02X%02X%02X%02X%02X\n", pData[7], pData[6], pData[5], pData[4], pData[3], pData[2], pData[1], pData[0]);
				break;
*/
			case 14:
				BTDevice_Fw_Efuse_GetBytes(1, 0x01F8, LEN_8_BYTE, pData);
				DBGPRINTF("FW Read user defined  efuse = 0X%02X%02X%02X%02X%02X%02X%02X%02X\n", pData[7], pData[6], pData[5], pData[4], pData[3], pData[2], pData[1], pData[0]);
				break;

			case 15:

				BT_WriteBDAddr(pBluetoothModule);
				BT_ReadBDAddr(pBluetoothModule);

				//***+user defined data 8 bytes***//
				pData[0] = 0xFF;
				pData[1] = 0xFF; 
				pData[2] = 0xFF; 
				pData[3] = 0xFF;
				pData[4] = 0xFF;
				pData[5] = 0xFF;
				pData[6] = 0xFF;
				pData[7] = 0xCC;
				//***-user defined data 8 bytes***//
				BTDevice_Fw_Efuse_SetBytes(1, 0x01F8, LEN_8_BYTE, pData);

				BTDevice_Fw_Efuse_GetBytes(1, 0x01F8, LEN_8_BYTE, pData);
				DBGPRINTF(" 0X%02X%02X%02X%02X%02X%02X%02X%02X\n", pData[7], pData[6], pData[5], pData[4], pData[3], pData[2], pData[1], pData[0]);				
				break;
				
            case 16: BT_GetBDAddr(); break;
			case 17: API_bt_GetChipInfo(); break;
			case 18: BT_GetTxDefaultPower(); break;	
				
			default:
				DBGPRINTF("Error Select Test Item...\n");
			}	
           fflush(stdin);
        }

	//close
	pBaseInterface->Close(pBaseInterface);

	DBGPRINTF("Close Device Success..\n"); 

exit:
	
	if (pBaseDLLObject != NULL)
	{
		ReleaseBTPMPDLLObject(pBaseDLLObject);
	}
	
	DBGPRINTF(" ============ MP Sample end========== \n");
	DBGPRINTF("Please enter any key\n");

	getch();
	return 0;
}


