#ifndef RTKBTMPDLL_H
#define RTKBTMPDLL_H

#ifdef __cplusplus  
extern "C" {
#endif
#include "bt_mp_dll_build.h"
#include "RtlBluetoothMP.h"
#ifdef __cplusplus  
}
#endif

#define RTKBT_DYNAMIC_EXPORTS


#ifdef RTKBT_DYNAMIC_EXPORTS
#define API_RtKBTMP __declspec(dllexport)  //dynamic import
#else
#define API_RtKBTMP __declspec(dllimport)  //static import
#endif


#define LEN_0_BYTE 0
#define LEN_1_BYTE 1
#define LEN_5_BYTE 5

#define HCI_VENDOR_MP_READ_TX_POWER_INFO 0xfced

// 0 : max tx power index
// 1 : 1 M default tx power index 
// 2 : 2M default tx power index
// 3 : 3M default tx power index 
// 4 : LE default tx power index
#define MAX_TX_POWER_INDEX 0
#define DEFAULT_1M_TX_POWER_INDEX 1
#define DEFAULT_2M_TX_POWER_INDEX 2
#define DEFAULT_3M_TX_POWER_INDEX 3
#define DEFAULT_LE_TX_POWER_INDEX 4

unsigned char TxPowerLevelInfo[LEN_5_BYTE];

enum BT_HCI_EVENT_FIELD
{
	EVT_CODE = 0,
	EVT_PARA_LEN,
	EVT_HCI_CMD_NUM,
	EVT_CMD_OPCODE_0,
	EVT_CMD_OPCODE_1,
	EVT_STATUS,
	EVT_BYTE0,
	EVT_BYTE1,
	EVT_BYTE2,
	EVT_BYTE3,
};


typedef struct _RTKBT_TRXSTATISTICS
{
	unsigned long   RxBits;
	unsigned long   ErrorBits;
	float           RxBER;			// in %
	unsigned long   RSSI;			//in dBm
	float   CFO;				    //in KHz
	float   SignalQuality;
	unsigned long   TxBits;
} RTKBT_TRXSTATISTICS;


typedef struct _RTKBT_TRXPARAM
{
	UINT8      Rate;                 		// 1~3       
	UINT8      Channel;           		// 0~78
	UINT32     TxPktCnt;        		// 0: continue packet Tx 
	UINT8      TxPKtInterval;		//0~15-> 100ns~1600ns
	UINT8      PayloadType;      	 //0: ("All 0's"), 1:("All 1's"), 2:("0101"), 3:("1010"), 4:("0x0~0xf")  
	UINT16     PayloadLength;  		 // in bits, 1 ~ 8191
	UINT32     PacketHeader;            //0x0 ~ 0x3ffff
	UINT8      WhitenCoeff;		 // 0x0~ 0x7f, Whitening disable if out of this range
	char       BDAddress[13];           //13 hex digits
	UINT8      TxGainIndex;             // 1~7
} RTKBT_TRXPARAM;


typedef enum 
{
	eNoError=0,                //0
	eAdapterInitialFail,
	eInvalidHostType,
	eInvalidUSBPortNumber,
	eInvalidUARTPortNumber,
	eInvalidPCIePortNumber,  //5
	eInvalidUARTBaudRate,
	eNotRTKBTChip,
	eInvalidDataRate,
	eInvalidTxPktInterval,
	eInvalidChannelNumber,   //10
	eInvalidPayloadType,
	eInvalidPayloadLength,
	eInvalidPacketHeader,
	eInvalidBDAddress,
	eInvalidRegsiterType,   //15
	eInvalidTxIndex,
	eHCIResetFail,
	eEnableDUTModeError,
	eRedundancyTestAction,
	ePacketTxFail,   //20
	eContinueTxFail,
	ePacketRxFail,
	eStopFail,
	eCFOAdjustFail,
	eNotSupport,        //25
	eUnknowError,
	eNoHCIEventResponse,
	eHostInitFail,
	eInvalidTxGainIndex,
	eH5toH4TranslateFail,   //30
	eTestActionIsStillRunning,
    eH52H4Failed,
    eAdapterFromIsNotOpen ,
    eSettingModuleTypeFail,

	////////// new error define /////////
    eBtMpDllBuidFail,
    eBtOpenPorFail,
    eBtDownLoadPatchCodeFail,
    eBtModuleIsNull,
    eBtExecJobFail,
    eBtNoSuppost,
    eBtInvalidTestMode,
    eBtSetDefaultPowerFail,
    eErrorOfNumber  
}_ErrorCode;

#ifdef SET_INDEX_BT_ADDR
enum 
{
	SET_INDEX_BT_ADDR = 0,
	SET_INDEX_THERMAL,
	SET_INDEX_TX_POWER_DAC,
	SET_INDEX_XTAL,
	SET_INDEX_USB_VID_PID, //pData[]= 0xDA,0x0B,0x68,0x81 => VID:0BDA PID:8168
};
#endif

#ifdef __cplusplus  
 extern "C" 
 {                                      
#endif

API_RtKBTMP int		RTKBT_MP(void); 
API_RtKBTMP bool	RTKBT_OpenAdapter(UINT8 HostType, UINT8 PortNo, UINT32 Rate);
API_RtKBTMP bool	RTKBT_CloseAdapter();
API_RtKBTMP bool	RTKBT_HCIReset();
API_RtKBTMP UINT32  	RTKBT_GetLastError();
API_RtKBTMP bool	RTKBT_ClearCounter();
API_RtKBTMP bool	RTKBT_RadioOff();
API_RtKBTMP bool	RTKBT_ShowUI(bool IsShow);
API_RtKBTMP bool	RTKBT_BTTestMode(UINT8 Type);
API_RtKBTMP bool	RTKBT_GetStatistics(RTKBT_TRXSTATISTICS* statistics);
API_RtKBTMP bool	RTKBT_StartPacketTx();
API_RtKBTMP bool	RTKBT_StartContinueTx();
API_RtKBTMP bool	RTKBT_StartRx();
API_RtKBTMP bool	RTKBT_StartSignalToneTx(); 
API_RtKBTMP bool	RTKBT_StopTest();
API_RtKBTMP bool	RTKBT_SetTRxParameters(RTKBT_TRXPARAM params);
API_RtKBTMP UINT8  RTKBT_ReadThermalMeter();
API_RtKBTMP bool	RTKBT_QueryTRxStatus();
API_RtKBTMP bool	RTKBT_SetUARTType(int type);
API_RtKBTMP bool	RTKBT_H52H4(int PortNumber,int Baudrate,int TimeOut_mSec);
API_RtKBTMP bool	RTKBT_ModuleSelect(int ModuleType);
API_RtKBTMP int		RTKBT_GetComHandle(HANDLE *ComHandle,HANDLE *ComEventHandle);
API_RtKBTMP UINT8*	RTKBT_SendHCICmd(UINT16 nOpcode, UINT8 nLength, UINT8* lpParam, UINT8 nEventcode);
API_RtKBTMP bool	RTKBT_SetRTL8761XTAL(unsigned char Value); 
API_RtKBTMP bool	RTKBT_WriteReg(UINT32 type, UINT32 RegAddr, UINT32 RegValue, UINT32 bitmask);
API_RtKBTMP UINT32 	RTKBT_ReadReg(UINT32 type, UINT32 RegAddr, UINT32 bitmask);
API_RtKBTMP bool	RTKBT_TxPowerAdjust(UINT8 FineTuneIndex) ;  //CorseTuneIndex: TBD, FineTuneIndex:1~5
API_RtKBTMP bool RTKBT_WriteMpParamterToConfig(unsigned char Index, unsigned char *pData);
API_RtKBTMP bool RTKBT_WriteMpParamterToEfuse(unsigned char Index, unsigned char *pData);
API_RtKBTMP bool	RTKBT_WriteMpPowerOnFunctionToEfuse(int PowerOn_enable,int PowerOn_Active);



API_RtKBTMP bool RTKBT_LeTxTestStart(
	unsigned char LeTest_Channel,  //channel : 0~39
	unsigned char LeTest_DataLen, //Length_Of_Test_Data : 0x00~0x25
	unsigned char LeTest_PayloadType //Packet_Payload : reference "BT_LE_PAYLOAD_TYPE" in RtlBluetoothMP.h
	);


API_RtKBTMP bool RTKBT_LeRxTestStart(
	unsigned char LeTest_Channel
	);

API_RtKBTMP bool RTKBT_LeTxTestStop();

API_RtKBTMP bool RTKBT_LeRxTestStop(unsigned long *pRxCount);


// 0 : max tx power index
// 1 : 1 M default tx power index 
// 2 : 2M default tx power index
// 3 : 3M default tx power index 
// 4 : LE default tx power index
#define MAX_TX_POWER_INDEX 0
#define DEFAULT_1M_TX_POWER_INDEX 1
#define DEFAULT_2M_TX_POWER_INDEX 2
#define DEFAULT_3M_TX_POWER_INDEX 3
#define DEFAULT_LE_TX_POWER_INDEX 4
API_RtKBTMP bool RTKBT_GetTxPowerLevelInfo(unsigned char *pTxPowerLevelInfoValue);


#ifdef __cplusplus  
	}                                     
#endif


#endif
