//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop



#include "rtkbtTrxThreadUnit.h"

#include "FormMainUnit.h"
extern "C"
{
        #include "bt_mp_dll_build.h"
        #include "RtlBluetoothMP.h"
}
#pragma package(smart_init)

extern  void DBGPRINTF(char *prompt, ...);
//---------------------------------------------------------------------------

//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall rtkbtTrx::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------

__fastcall rtkbtTrx::rtkbtTrx(bool CreateSuspended)
        : TThread(CreateSuspended)
{
        TX_RX=0;
        pBluetoothModule=NULL;
        ReportUpdateTime=100;
	oldTotalRxCounts = 0;

	fp_cfo=fopen("CFO.ini","w");
		
}
//---------------------------------------------------------------------------
void rtkbtTrx::SetName()
{
        THREADNAME_INFO info;
        info.dwType = 0x1000;
        info.szName = "rtkbtTrx";
        info.dwThreadID = -1;
        info.dwFlags = 0;

        __try
        {
                 RaiseException( 0x406D1388, 0, sizeof(info)/sizeof(DWORD),(DWORD*)&info );
        }
        __except (EXCEPTION_CONTINUE_EXECUTION)
        {
        }
}
void rtkbtTrx::SetTxRxUpdata(BASE_BTMPDLL_MODULE *pSourceBluetoothModule,unsigned long Command,BT_PARAMETER *pBTParam)
{
   TX_RX= Command;
   pBluetoothModule=pSourceBluetoothModule;
   pParam=pBTParam;
   return ;
}
void rtkbtTrx::SetUpdateTime(int Time)
{
     ReportUpdateTime=Time;
     return ;
}
//---------------------------------------------------------------------------
void __fastcall rtkbtTrx::Execute()
{
	SetName();
	float ber=0;
	float cfo=0;
	
	String dstr;
	DWORD t1=0,t2=0,t=0;
	// BT_PARAMETER mParam;
	//  BT_PARAMETER *pParam=&mParam;
	BT_DEVICE_REPORT        mBaseModuleBtReportMemory;
	BT_DEVICE_REPORT	*pModuleBtReport=&mBaseModuleBtReportMemory;
	
	if (pParam == NULL)
	{
		goto exit;
	}
	if (pBluetoothModule == NULL)
	{
		goto exit;
	}

	t1=GetTickCount();
	pParam->ParameterIndex= TX_RX;
	while (!Terminated)
	{
		if (ReportUpdateTime >0)
		{
			t2=GetTickCount();
			t=abs(t2-t1);
			if (t< ReportUpdateTime)
			{
				Sleep(40);
				continue;
			}
		}

		if(Form_Main->DisableReportUpdateMenuItem->Checked == false)
		{
			switch (TX_RX)
			{
				case REPORT_RKT_RX:  //pkt-rx	
				case REPORT_FW_PACKET_RX:
					pBluetoothModule->ActionReport(pBluetoothModule, TX_RX, pModuleBtReport);
					ber=(float)(pModuleBtReport->TotalRxErrorBits)/(float)(pModuleBtReport->TotalRXBits+1);
					cfo=pModuleBtReport->Cfo;

					//print
					dstr.sprintf("%ld",pModuleBtReport->RxRssi);      Form_Main->StringGrid_RXReport->Cells[1][1] = dstr;
					dstr.sprintf("%ld",pModuleBtReport->TotalRXBits);   Form_Main->StringGrid_RXReport->Cells[1][2] = dstr;
					dstr.sprintf("%ld",pModuleBtReport->TotalRxErrorBits);   Form_Main->StringGrid_RXReport->Cells[1][3] = dstr;
					dstr.sprintf("%ld",pModuleBtReport->TotalRxCounts); Form_Main->StringGrid_RXReport->Cells[1][4] = dstr;
					dstr.sprintf("%lf",ber);				Form_Main->StringGrid_RXReport->Cells[1][5] = dstr;
					dstr.sprintf("%f kHz",cfo);			Form_Main->StringGrid_RXReport->Cells[1][6] = dstr;

					if(oldTotalRxCounts !=pModuleBtReport->TotalRxCounts)
					{
						oldTotalRxCounts = pModuleBtReport->TotalRxCounts;
						
						if(fp_cfo !=NULL)
						{
							fprintf(fp_cfo, "%f kHz\n", cfo);
							fflush(fp_cfo);
						}

					}
				break;

				case REPORT_CON_TX:
				case REPORT_LE_CONTINUE_TX:
				case REPORT_FW_CONTINUE_TX:
				case REPORT_FW_LE_CONTINUE_TX:
				case REPORT_PKT_TX:
				case REPORT_FW_PACKET_TX:
					pBluetoothModule->ActionReport(pBluetoothModule, TX_RX, pModuleBtReport);
					//print
					dstr.sprintf("%d",pModuleBtReport->TotalTXBits);           Form_Main->StringGrid_TXReport->Cells[1][1] = dstr;
					dstr.sprintf("%d",pModuleBtReport->TotalTxCounts);         Form_Main->StringGrid_TXReport->Cells[1][2] = dstr;
				break;
				
				default:
				goto exit;
	 		}
		}
		t1=t2;
	}
exit:

	fclose(fp_cfo);	

	return ;
}
//---------------------------------------------------------------------------
 
