//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ShowUnit.h"
#include "FormMainUnit.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------

//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall SowObject::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------

__fastcall SowObject::SowObject(bool CreateSuspended)
        : TThread(CreateSuspended)
{
        SettingOfTimeOut=3000;
        SettingMaxValue=500;
        Mode =0;
}
//---------------------------------------------------------------------------
void SowObject::ShowUIExecute()
{
        DWORD t1,t2,t=0;
        int n=100;
        int Progressvalue=1;

         t1=GetTickCount();
         n=0;
         Form_Main->CGauge_Show->MaxValue=SettingMaxValue;
         Form_Main->CGauge_Show->MinValue=0;
         Form_Main->CGauge_Show->Progress=0;
         Progressvalue= SettingOfTimeOut/SettingMaxValue+1;
        while (!Terminated)
        {
           t2=GetTickCount();
           t= abs(t2-t1);
           if( t < SettingOfTimeOut)
           {
                n=t/Progressvalue;
                Form_Main->CGauge_Show->Progress=n;
           }
        }
        return ;
}
void SowObject::SetName()
{
        THREADNAME_INFO info;
        info.dwType = 0x1000;
        info.szName = "SowObject";
        info.dwThreadID = -1;
        info.dwFlags = 0;

        __try
        {
                 RaiseException( 0x406D1388, 0, sizeof(info)/sizeof(DWORD),(DWORD*)&info );
        }
        __except (EXCEPTION_CONTINUE_EXECUTION)
        {
        }
}
//---------------------------------------------------------------------------
void __fastcall SowObject::Execute()
{
      //  DWORD t1,t2,t=0;
      //  int n=100;
     //   int Progressvalue=1;
        SetName();

        //---- Place thread code here ----
        switch (Mode)
        {
          case 1: PowerTrackProcess(); break;
          default :
           ShowUIExecute();
        }
        return ;
}
//---------------------------------------------------------------------------
void SowObject::SetTimeOutTime(int timeout,int Maxvalue)
{
       SettingOfTimeOut= timeout;
       SettingMaxValue=Maxvalue;
       return ;
}
//---------------------------------------------------------------------------
void SowObject::SetMode(int in)
{
       Mode = in;
       return ;
}
void SowObject::SetLeTestPara(int inChipIndex,int inLeTest_TxGainValue,unsigned long inLeTest_TxTestTime)
{
        LeTest_TxGainValue =inLeTest_TxGainValue ;
        ChipIndex =inChipIndex;
        LeTest_TxTestTime =inLeTest_TxTestTime;
       return ;
}


//---------------------------------------------------------------------------
void SowObject::PowerTrackProcess()
{
	String dstr;
        ///////  thermal ////////////////////////////////////////////////
        unsigned long newThermalValue=0,ThermalValue=0;
        unsigned int   h_index,l_index;
        unsigned char  BT_DEFAULT_TX_GAIN_TABLE[6][8] =
        {
	        {0x2d,0x30,0x6d,0x70,0xb0,0xcd,0xd0,0xce},	 //RTL8723A
	        {0x2b,0x2e,0x6b,0x6e,0x8b,0x8e,0xce,0xec},       //RTL8723B
	        {0x28,0x2b,0x48,0x4b,0xc8,0xcc,0xe9,0xee},       //RTL8821A
	        {0x0d,0x49,0x4d,0x69,0x89,0x8d,0xa9,0xc9},       //RTL8761A
	        {0x2b,0x2e,0x6b,0x6e,0x8b,0x8e,0xce,0xe9},       //RTL8703A
	        {0x0d,0x49,0x4d,0x69,0x89,0x8d,0xa9,0xc9},       //RTL8763A
        };
        ///////////////////////////////////////////////////////////////////////
        DWORD t_end, t_start,t;
        t_start = GetTickCount();
        FILE *fp = NULL;
        fp = fopen("ThermalTrack.ini","r+");
        char chipid[100];
        int th1,th2,v1,v2;
        int count =0;
        unsigned long  th_low,th_high;
        unsigned long  th_v1,th_v2;
        int flag=-1;
         Form_Main->Memo_msg->Lines->Add(">> Begin thermal control...");
        h_index = LeTest_TxGainValue +1;
        if (h_index >7) h_index =7;

        l_index = LeTest_TxGainValue -1;

        if (l_index>0x00FFFF)  l_index =0;
        th_high=19;
        th_low =10;
        th_v1 =  BT_DEFAULT_TX_GAIN_TABLE[ChipIndex][l_index];
        th_v2 =  BT_DEFAULT_TX_GAIN_TABLE[ChipIndex][h_index];
            if (fp !=NULL)
            {

                   while(!feof(fp))
                    {
                        memset(chipid,0,100);
                        fscanf(fp,"%s %x %x %x %x ",chipid,&th1,&v1,&th2,&v2);

                        flag =-1;
                        switch (ChipIndex)
                        {
                             case 0:  flag = strcmp(chipid , "RTL8723A")  ; break;
                             case 1:  flag = strcmp(chipid , "RTL8723B")  ; break;
                             case 2:  flag = strcmp(chipid , "RTL8821A")  ; break;
                             case 3:  flag = strcmp(chipid , "RTL8761A")  ; break;
                             case 4:  flag = strcmp(chipid , "RTL8703B")  ; break;
                             case 5:  flag = strcmp(chipid , "RTL8763A")  ; break;
                        }
                        if (flag ==0 )
                        {
                                th_high= th2;
                                th_low = th1;
                                th_v1 =  v1;
                                th_v2 =  v2;
                                break;
                        }
                        else
                        {
                                th_v1 =  BT_DEFAULT_TX_GAIN_TABLE[ChipIndex][l_index];
                                th_v2 =  BT_DEFAULT_TX_GAIN_TABLE[ChipIndex][h_index];
                        }

                    } //end while
                    fclose(fp) ;
                }
                while(!Terminated)
                {
                        t_end = GetTickCount();
                        t=abs(t_end-t_start);
                        if ((t>LeTest_TxTestTime)   &&   (LeTest_TxTestTime !=0))
                        {
                                break;
                        }
                        Sleep(200);
                        if (Form_Main->API_ReadThermalValue(&newThermalValue) ==0)
                        {
                           if (ThermalValue != newThermalValue)
                          {
                                count=0;
                                if (newThermalValue >= th_high)
                                {
                                        Form_Main->API_SetNewPowerValue(th_v2);
                                        dstr.sprintf("Thermal Value (up)= 0x%.2x(%2d) --> 0x%x",newThermalValue,newThermalValue ,th_v2);
                                }
                                else if (newThermalValue <= th_low)
                                {
                                        Form_Main->API_SetNewPowerValue(th_v1);
                                        dstr.sprintf("Thermal Value (down)= 0x%.2x(%2d) --> 0x%x",newThermalValue,newThermalValue ,th_v1);
                                }
                                else
                                {

                                       dstr.sprintf("Thermal Value = 0x%.2x(%2d)",newThermalValue,newThermalValue);

                                }
                                Form_Main->Memo_msg->Lines->Add(dstr);

                          } //end if (ThermalValue != newThermalValue)
                          ThermalValue =  newThermalValue;
                        }  //end if (Form_Main->API_ReadThermalValue(&newThermalValue) ==0)
                        count ++;
                        if (count > 15)
                        {

                         //  dstr.sprintf("Thermal Value = 0x%.2x(%2d)[%d] ",newThermalValue,newThermalValue,count);
                        //   Form_Main->Memo_msg->Lines->Add(dstr);
                           count =0;
                        }

                } //end  while(!Terminated)


          Form_Main->Memo_msg->Lines->Add(">> End thermal control...");
          TObject *Sender;
          Form_Main->Btn_LeTest_StopClick(Sender);
          return ;
}
//---------------------------------------------------------------------------
