#ifndef RTLBLUETOOTHMP_H
#define RTLBLUETOOTHMP_H

#include "windows.h"

#define _IsVCType_

#define REALTEKDLL_EXPORTS

	#ifdef REALTEKDLL_EXPORTS
		#define RTKBTMP_API __declspec(dllexport)
	#else
		#define RTKBTMP_API __declspec(dllimport)
	#endif

#ifndef _BT_VERIFY_DEFINE
#define _BT_VERIFY_DEFINE


typedef struct BT_VERIFY_PARMERTER_TAG BT_VERIFY_PARMERTER;  
typedef struct BT_VERIFY_REPORT_TAG    BT_VERIFY_REPORT;
typedef int (*BT_Verify_CALLBACK_FUNC)(BT_VERIFY_REPORT *pReport);
#define _IN_
#define _OUT_


enum BT_VERIFY_MSG{
	BT_VERIFY_ERROR= -1,
	BT_VERIFY_SUCCRESS =0,

	BT_SUT_OPEN_FAIL,
	BT_DUT_OPEN_FAIL,


};
enum VERIFY_PARAMTER_INDEX
{
	VERIFY_GET_LAST_ERROR=0,
	VERIFY_TEST_BEGIN,
	VERIFY_TEST_STOP,
	VERIFY_EFUSE_WRITE,
	VERIFY_EFUSE_READ,
	VERIFY_REG_WRITE,
	VERIFY_REG_READ,
	VERIFY_GET_CFOVALUE,
	VERIFY_SW_RESET

};
struct BT_VERIFY_REPORT_TAG{

	 //CFO
	 float mFloatData;
     unsigned long  pData[100];
	 unsigned long  CFO_Value;
	 int            Rssii;
     float          ber; 

	 int            VerifyTX_Rssi;
	 float          VerifyTX_ber;

	 int					  VerifyRX_Rssi;
	 unsigned long            VerifyRX_bits;
	 unsigned long            VerifyRX_error_bits;
	 float                    VerifyRX_ber;
};

struct BT_VERIFY_PARMERTER_TAG
{
	 //In
	 _IN_ int ParamterIndex; 
	 _IN_ int GoldSample_PortNumber;
	 _IN_ int InterfaceType;
	 _IN_ int PortNo ; 
	 _IN_ unsigned long	Baudrate;
 
	_IN_  unsigned long def_CFOVaule;

	//
	//BR/EDR TX Test
	 BOOL    Test_XTAL;
	 BOOL    Test_CALXTAL;
	 BOOL    Test_TX;
	 BOOL    Test_RX;
     


	 BT_Verify_CALLBACK_FUNC    pFunc;
	 unsigned char ExeMode; 

};


#endif

typedef int (*pfBTMPAPI_BluetoothVerify)(
										 BT_VERIFY_PARMERTER *pBTVerifyParam,
										 BT_VERIFY_REPORT *pBTVerifyReport
										 );  

 




#ifndef _FUNCIION_RETURN_
#define _FUNCIION_RETURN_

typedef enum
{
	BT_FUNCTION_SUCCESS = 0,
	FUNCTION_ERROR,

	FUNCTION_HCISEND_ERROR,
	FUNCTION_HCISEND_STAUTS_ERROR,
	FUNCTION_PARAMETER_ERROR,
	FUNCTION_PARAMETER_INVALID_CHANNEL,
	FUNCTION_NO_SUPPORT,
	FUNCTION_TRX_STATUS_ERROR,
	FUNCTION_RX_RUNNING,
	FUNCTION_TX_RUNNING,
	FUNCTION_RX_MAXCOUNT,

	FUNCTION_TX_FINISH,
	FUNCTION_RX_FINISH,

	////////////////////////
	FUNCTION_INTERFACE_ERROR,
	FUNCTION_PARSE_ERROR_ADB,
	NumOf_FUNCTION_RETURN_STATUS
}FUNCTION_RETURN_STATUS;
#endif


#ifndef BASE_INTERFACE_MODULE_TAG_LABEL
#define BASE_INTERFACE_MODULE_TAG_LABEL
/// Base interface module alias

typedef struct BASE_INTERFACE_MODULE_TAG BASE_INTERFACE_MODULE;

typedef int
(*BASE_FP_OPEN)(
	BASE_INTERFACE_MODULE *pBaseInterface
	);



typedef int
(*BASE_FP_SEND)(
	BASE_INTERFACE_MODULE *pBaseInterface,
	unsigned char *pWritingBuf,
	unsigned long Len
	);



typedef int
(*BASE_FP_RECV )(
	BASE_INTERFACE_MODULE *pBaseInterface,
	unsigned char *pReadingBuf,
	unsigned long  Len,
	unsigned long *pRetLen
	);



typedef int
(*BASE_FP_CLOSE)(
	BASE_INTERFACE_MODULE *pBaseInterface
	);



typedef void
(*BASE_FP_WAIT_MS)(
	BASE_INTERFACE_MODULE *pBaseInterface,
	unsigned long WaitTimeMs
	);





typedef void
(*BASE_FP_SET_USER_DEFINED_DATA_POINTER)(
	BASE_INTERFACE_MODULE *pBaseInterface,
	int UserDefinedData
	);



typedef void
(*BASE_FP_GET_USER_DEFINED_DATA_POINTER)(
	BASE_INTERFACE_MODULE *pBaseInterface,
	int *pUserDefinedData
	);


#define MAX_DATA_LEN	20

// Base interface module structure
struct BASE_INTERFACE_MODULE_TAG
{
	BASE_FP_OPEN Open;
	BASE_FP_SEND Send;
	BASE_FP_RECV Recv;
	BASE_FP_CLOSE Close;
	BASE_FP_WAIT_MS WaitMs;
	
	BASE_FP_SET_USER_DEFINED_DATA_POINTER   SetUserDefinedDataPointer;
	BASE_FP_GET_USER_DEFINED_DATA_POINTER   GetUserDefinedDataPointer;

	unsigned char InterfaceType;

	// User defined data
	unsigned long UserDefinedData;

	//for usb , uart
	unsigned char PortNo;		

	//for uart
	unsigned long Baudrate;
	unsigned char bUartProtocol;

	unsigned char pData[MAX_DATA_LEN];

};
#endif

//----------------------------------------------------------------------------------------------------
#ifndef BASE_BT_CONFIG
#define BASE_BT_CONFIG

#define MAX_TXGAIN_TABLE_SIZE   7
#define MAX_TXDAC_TABLE_SIZE	5

#define MP_DEBUG_MESSAGE_DATA_LEN 14
#define MP_FT_VALUE_DATA_LEN 12


typedef enum {
	MD_REG = 0,
	RF_REG,
	SYS_REG,
	BB_REG,
}BT_REG_TYPE;



typedef enum{
	REPORT_ALL = 0,
	REPORT_PKT_TX,
	REPORT_CON_TX,
	REPORT_RKT_RX,
	REPORT_TX_GAIN_TABLE,
	REPORT_TX_DAC_TABLE,
	REPORT_XTAL,
	REPORT_THERMAL,
	REPORT_BT_STAGE,
	REPORT_CHIP,
	REPORT_LOGICAL_EFUSE,
	REPORT_LE_RX,
	REPORT_LE_CONTINUE_TX,
	REPORT_FW_PACKET_TX,
	REPORT_FW_CONTINUE_TX,
	REPORT_FW_PACKET_RX,
	REPORT_FW_LE_CONTINUE_TX,	
	REPORT_TX_POWER_INFO,
	REPORT_GPIO3_0,
	REPORT_MP_DEBUG_MESSAGE,
	REPORT_MP_FT_VALUE,	
	REPORT_POWER_TRACKING,
	
}BT_REPORT_TAG;



typedef enum {
	HCI_RESET = 0,						// 0

	// test mode
	TEST_MODE_ENABLE,					// 1

	// efuse setting
	WRITE_EFUSE_DATA,					// 2  

	// set table
	SET_TX_GAIN_TABLE,				// 3  
	SET_TX_DAC_TABLE,					// 4
	SET_DEFAULT_TX_GAIN_TABLE,		//5  
	SET_DEFAULT_TX_DAC_TABLE,		//6 
	
	//set power
	SET_POWER_GAIN_INDEX,			//7
	SET_POWER_GAIN,					//8
	SET_POWER_DAC,					//9

	// set xtal
	SET_XTAL,							//10  

	// report clear
	REPORT_CLEAR,						//11

	// pkt tx
	PACKET_TX_START,					//12 
	PACKET_TX_UPDATE,					//13 
	PACKET_TX_STOP,					//14 

	// continue tx
	CONTINUE_TX_START,				//15 
	CONTINUE_TX_UPDATE,				//16 
	CONTINUE_TX_STOP,					//17 

	// pkt rx
	PACKET_RX_START,					//18 
	PACKET_RX_UPDATE,					//19 
	PACKET_RX_STOP,					//20 

	// hopping mode
	HOPPING_DWELL_TIME,				//21 

	// LE
	LE_TX_DUT_TEST_CMD,				//22 
	LE_RX_DUT_TEST_CMD,				//23 
	LE_DUT_TEST_END_CMD,				//24 

	READ_EFUSE_DATA,					//25

	SET_CONFIG_FILE_DATA,				//26
	CLEAR_CONFIG_FILE_DATA,			//27

	//LE Continue TX
	LE_CONTINUE_TX_START,				//28
	LE_CONTINUE_TX_STOP,				//29

	// FW pkt tx
	FW_PACKET_TX_START,				//30  
	FW_PACKET_TX_STOP,				//31 

	// FW pkt rx
	FW_PACKET_RX_START,				//32 
	FW_PACKET_RX_STOP,				//33 	

	// FW continue tx
	FW_CONTINUE_TX_START,			//34 
	FW_CONTINUE_TX_STOP,				//35 

	//FW LE Continue TX
	FW_LE_CONTINUE_TX_START,			//36
	FW_LE_CONTINUE_TX_STOP, 			//37
	
	FW_READ_TX_POWER_INFO,			//38

	SET_GPIO3_0,						//39
	
	SET_ANT_INFO,						//40	
	SET_ANT_DIFF_S0S1,				//41

	TX_POWER_TRACKING,			//42
	SET_K_TX_CH_PWR,					//43	

	WRITE_FLASH_CONFIG,				//44 fro BBPro flasg config	

	BT_ACTION_NUM
} BT_ACTIONCONTROL_TAG;




typedef enum
{
	BT_PAYLOAD_TYPE_ALL0 = 0,
	BT_PAYLOAD_TYPE_ALL1 = 1,
	BT_PAYLOAD_TYPE_0101 = 2,
	BT_PAYLOAD_TYPE_1010 = 3,
	BT_PAYLOAD_TYPE_0x0_0xF = 4,
	BT_PAYLOAD_TYPE_0000_1111 = 5,
	BT_PAYLOAD_TYPE_1111_0000 = 6,
	BT_PAYLOAD_TYPE_PRBS9 = 7,
	//////////////////////////////////
	BT_PAYLOAD_TYPE_NUM =8	
}BT_PAYLOAD_TYPE;


typedef enum
{
	BT_LE_PAYLOAD_TYPE_PRBS9 = 0,
	BT_LE_PAYLOAD_TYPE_1111_0000 = 1,
	BT_LE_PAYLOAD_TYPE_1010 = 2,
	BT_LE_PAYLOAD_TYPE_PRBS15 = 3,
	BT_LE_PAYLOAD_TYPE_ALL1 = 4,
	BT_LE_PAYLOAD_TYPE_ALL0 = 5,
	BT_LE_PAYLOAD_TYPE_0000_1111 = 6,	
	BT_LE_PAYLOAD_TYPE_0101 = 7,
	
}BT_LE_PAYLOAD_TYPE;



typedef enum
{
	BT_PKT_1DH1=0,
	BT_PKT_1DH3,	// 1
	BT_PKT_1DH5,
	BT_PKT_2DH1,
	BT_PKT_2DH3,
	BT_PKT_2DH5,
	BT_PKT_3DH1,
	BT_PKT_3DH3,
	BT_PKT_3DH5,	// 8
	BT_PKT_LE,
	//////////////////////////////////////////////////
	BT_PKT_TYPE_NULL,
	BT_PKT_LE_2M,			//11
	BT_PKT_LE_CODED_S8,	//12
	BT_PKT_LE_CODED_S2,	//13
	BT_PKT_TYPE_NUM
}BT_PKT_TYPE;



typedef enum
{
	BT_DUT_MODE = 0,
	BT_PSEUDO_MODE =1,
	/////////////////
	NUMBEROFBT_TEST_MODE
}BT_TEST_MODE;



typedef enum
{
	LE5_TX_1M_PHY = 1,
	LE5_TX_2M_PHY = 2,
	LE5_TX_CODED_PHY_S8 = 3,	//125K
	LE5_TX_CODED_PHY_S2 = 4,	//500K
}BT_LE5_TX_PHY;


typedef enum
{
	LE5_RX_1M_PHY = 1,
	LE5_RX_2M_PHY = 2,
	LE5_RX_CODED_PHY = 3,	
}BT_LE5_RX_PHY;


typedef enum
{
	STANDARD_MODULATION_INDEX = 0,
	STABLE_MODULATION_INDEX = 1,	
}BT_LE50_MODULATION_INDEX;



enum RTK_BT_CHIP_ID_GROUP_{
	RTK_BT_CHIP_ID_UNKNOWCHIP=0xFF,
	RTK_BT_CHIP_ID_RTL8723A=0,
	RTK_BT_CHIP_ID_RTL8723B=1,
	RTK_BT_CHIP_ID_RTL8821A=2,
	RTK_BT_CHIP_ID_RTL8761A=3,
	RTK_BT_CHIP_ID_RTL8703A=4,
	RTK_BT_CHIP_ID_RTL8763A=5,
	RTK_BT_CHIP_ID_RTL8703B=6,
	RTK_BT_CHIP_ID_RTL8723C=7,
	RTK_BT_CHIP_ID_RTL8822B=8,
	RTK_BT_CHIP_ID_RTL8723D=9,
	RTK_BT_CHIP_ID_RTL8821C=10,  
	RTK_BT_CHIP_ID_RTL8763B=11,  //BBPro
	/////////////////////////    
	NumOfRTKCHID
};



typedef struct BT_PARAMETER_TAG   BT_PARAMETER;
typedef struct BT_DEVICE_REPORT_TAG BT_DEVICE_REPORT;
typedef struct BT_CHIPINFO_TAG   BT_CHIPINFO;


enum 
{
	SET_INDEX_BT_ADDR = 0,
	SET_INDEX_THERMAL,
	SET_INDEX_TX_POWER_DAC,
	SET_INDEX_XTAL,
	SET_INDEX_USB_VID_PID,
};


#define MAX_USERAWDATA_SIZE       256


struct  BT_PARAMETER_TAG
{
	unsigned long ParameterIndex;

	unsigned char mPGRawData[MAX_USERAWDATA_SIZE];
	unsigned char mParamData[MAX_USERAWDATA_SIZE];	
	unsigned char mChannelNumber;
	unsigned long mPacketType;
	unsigned char mTxGainIndex;
	unsigned char mTxGainValue;
	unsigned long mTxPacketCount;
	unsigned long	mPayloadType;
	unsigned long  mPacketHeader;
	unsigned char mWhiteningCoeffValue;
	unsigned char mTxDAC;
	ULONG64 mHitTarget;

	unsigned char TXGainTable[MAX_TXGAIN_TABLE_SIZE];
	unsigned char TXDACTable[MAX_TXDAC_TABLE_SIZE];

	unsigned char bHoppingFixChannel;
	unsigned long Rtl8761Xtal;
	unsigned char ExeMode; 
	unsigned char PHY;				//for Le Enhanced bt 5.0
	unsigned char ModulationIndex;	//for Le Enhanced bt 5.0
};



struct BT_CHIPINFO_TAG 
{ 
	unsigned int HCI_Version;
	unsigned int HCI_SubVersion;
	unsigned int LMP_Version;
	unsigned int LMP_SubVersion;

	unsigned int ChipType;
	unsigned int Version;
	int Is_After_PatchCode;

};



struct BT_DEVICE_REPORT_TAG { 

	unsigned long	TotalTXBits;
	unsigned long	TotalTxCounts;

	unsigned long	RXRecvPktCnts;
	unsigned long	TotalRXBits;
	unsigned long	TotalRxCounts;
	unsigned long	TotalRxErrorBits;
	int RxRssi;
	float ber;
	float Cfo;

	unsigned char CurrTXGainTable[MAX_TXGAIN_TABLE_SIZE];
	unsigned char CurrTXDACTable[MAX_TXDAC_TABLE_SIZE];

	unsigned char CurrThermalValue;
	unsigned long CurrRtl8761Xtal;
	unsigned char CurrStage;
	
	BT_CHIPINFO	*pBTInfo;
	BT_CHIPINFO	 BTInfoMemory;
	unsigned char ReportData[MAX_USERAWDATA_SIZE];	
};

#endif
//----------------------------------------------------------------------------------------------------

  
typedef struct BASE_BTMPDLL_MODULE_TAG   BASE_BTMPDLL_MODULE; 

typedef int
(*BT_DLL_MODULE_FP_ACTION_REPORT)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	int ActiceItem,
	BT_DEVICE_REPORT *pReport
	);

typedef int
(*BT_DLL_MODULE_FP_UPDATA_PARAMETER)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	BT_PARAMETER 	*pParam
	);

typedef int
(*BT_DLL_MODULE_FP_ACTION_CONTROLEXCUTE)(													
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule
	);

typedef int
(*BT_DLL_MODULE_FP_ACTION_DLFW)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	char *pPatchcode,
	int patchLength,
	int Mode
	);

typedef int
  (*BT_DLL_MODULE_FP_SET_MD_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned char Addr,
	unsigned char Msb,
	unsigned char Lsb,
	const unsigned long UserValue
	);

typedef int
(*BT_DLL_MODULE_FP_GET_MD_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned char RegStartAddr,
	unsigned char Msb,
	unsigned char Lsb,
	unsigned long *pReadingValue
	);

typedef int
(*BT_DLL_MODULE_FP_SET_RF_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned char RegStartAddr,
	unsigned char Msb,
	unsigned char Lsb,
	const unsigned long WritingValue
	);

typedef int
(*BT_DLL_MODULE_FP_GET_RF_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned char RegStartAddr,
	unsigned char Msb,
	unsigned char Lsb,
	unsigned long *pReadingValue
	);

typedef int
(*BT_DLL_MODULE_FP_SEND_HCICOMMANDWITHEVENT)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned int  OpCode,
	unsigned char PayLoadLength,
	unsigned char *pPayLoad,
	unsigned char  EventType,
	unsigned char  *pEvent
	);

typedef int
(*BT_DLL_MODULE_FP_RECV_ANYEVENT)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned char  *pEvent
	);

typedef int
(*BT_DLL_MODULE_FP_SET_SYS_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned long Addr,
	unsigned char Msb,
	unsigned char Lsb,
	const unsigned long UserValue
	);

typedef int
(*BT_DLL_MODULE_FP_GET_SYS_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	unsigned long Addr,
	unsigned char Msb,
	unsigned char Lsb,
	unsigned long *pUserValue
	);

typedef int
(*BT_DLL_MODULE_FP_SET_BB_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	int Page,
	unsigned long RegStartAddr,
	unsigned char Msb,
	unsigned char Lsb,
	const unsigned long WritingValue
	);

typedef int
(*BT_DLL_MODULE_FP_GET_BB_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	int Page,
	unsigned long Addr,
	unsigned char Msb,
	unsigned char Lsb,
	unsigned long *pUserValue
	);

typedef int
(*BT_DLL_MODULE_FP_SET_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	int Type,
	int Page,
	unsigned long RegStartAddr,
	unsigned char Msb,
	unsigned char Lsb,
	const unsigned long WritingValue
	);

typedef int
(*BT_DLL_MODULE_FP_GET_REG_MASK_BITS)(
	BASE_BTMPDLL_MODULE  *pDLLBtBaseModule,
	int Type,
	int Page,
	unsigned long Addr,
	unsigned char Msb,
	unsigned char Lsb,
	unsigned long *pUserValue
	);


struct BASE_BTMPDLL_MODULE_TAG
{

	BT_DLL_MODULE_FP_UPDATA_PARAMETER UpDataParameter;
	BT_DLL_MODULE_FP_ACTION_CONTROLEXCUTE ActionControlExcute;
	BT_DLL_MODULE_FP_ACTION_REPORT ActionReport;
	BT_DLL_MODULE_FP_ACTION_DLFW DownloadPatchCode;
	BT_DLL_MODULE_FP_SET_MD_REG_MASK_BITS SetMdRegMaskBits;
	BT_DLL_MODULE_FP_GET_MD_REG_MASK_BITS GetMdRegMaskBits;	
	BT_DLL_MODULE_FP_SET_RF_REG_MASK_BITS SetRfRegMaskBits;
	BT_DLL_MODULE_FP_GET_RF_REG_MASK_BITS GetRfRegMaskBits;

	BT_DLL_MODULE_FP_SET_SYS_REG_MASK_BITS SetSysRegMaskBits;
	BT_DLL_MODULE_FP_GET_SYS_REG_MASK_BITS GetSysRegMaskBits;	
	BT_DLL_MODULE_FP_SET_BB_REG_MASK_BITS SetBBRegMaskBits;
	BT_DLL_MODULE_FP_GET_BB_REG_MASK_BITS GetBBRegMaskBits;

	BT_DLL_MODULE_FP_SET_REG_MASK_BITS SetRegMaskBits;
	BT_DLL_MODULE_FP_GET_REG_MASK_BITS GetRegMaskBits;
	
	BT_DLL_MODULE_FP_SEND_HCICOMMANDWITHEVENT SendHciCommandWithEvent;
	BT_DLL_MODULE_FP_RECV_ANYEVENT RecvAnyHciEvent;
	BASE_INTERFACE_MODULE *pBaseInterface;

	int BuildStatus;
};


//----------------------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------------------
//  Member
//----------------------------------------------------------------------------------------------------
#ifndef INTERFACE_TYPE
#define INTERFACE_TYPE
enum 
{
	TYPE_USB = 0,
	TYPE_UART,
	TYPE_FILTER_UART,
	TYPE_ADB_UART,
	TYPE_ADB_USB,
	TYPE_SOCKET_DEVICE_UART,
	TYPE_SOCKET_DEVICE_USB,
	TYPE_BUMBLE_BEE_USB
}INTERFACE_TYPE;

#endif


RTKBTMP_API
int BTMPAPI_BuildInterfaceVendor(
	BASE_INTERFACE_MODULE **ppBaseInterface,
	BASE_INTERFACE_MODULE *pBaseInterfaceModuleMemory,
	//Parmater
	unsigned int InterfaceType,
	unsigned char	PortNo,
	unsigned long Baudrate,
	unsigned char *pData,
	//basic fuction
	BASE_FP_OPEN Open,
	BASE_FP_SEND Send,
	BASE_FP_RECV Recv,
	BASE_FP_CLOSE Close,
	BASE_FP_WAIT_MS WaitMs
	);

RTKBTMP_API
int BTMPAPI_BuildInterfaceRTK(
	BASE_INTERFACE_MODULE **ppBaseInterface,
	BASE_INTERFACE_MODULE *pBaseInterfaceModuleMemory,
	unsigned int InterfaceType,
	unsigned char	PortNo,
	unsigned long Baudrate,
	unsigned char *pData	
	);

RTKBTMP_API int
BTMPAPI_BuildBluetoothModule(
	BASE_BTMPDLL_MODULE *pBaseBTMPDLLModule,
	BASE_INTERFACE_MODULE *pBaseInterface,
	void *pExtra,
	unsigned char *pTxGainTable,
	unsigned char *pTxDACTable
	);


//----------------------------------------------------------------------------------------------------
// DLL Control
//----------------------------------------------------------------------------------------------------

typedef int  (*pfBTMPAPI_BuildInterfaceVendor)(
	BASE_INTERFACE_MODULE **ppBaseInterface,
	BASE_INTERFACE_MODULE *pBaseInterfaceModuleMemory,
	//Parmater
	unsigned int InterfaceType,
	unsigned char	PortNo,
	unsigned long Baudrate,
	unsigned char *pIp,	
	//basic fuction
	BASE_FP_OPEN Open,
	BASE_FP_SEND Send,
	BASE_FP_RECV Recv,
	BASE_FP_CLOSE Close,
	BASE_FP_WAIT_MS WaitMs
	);

typedef int  (*pfBTMPAPI_BuildInterfaceRTK)(
	BASE_INTERFACE_MODULE **ppBaseInterface,
	BASE_INTERFACE_MODULE *pBaseInterfaceModuleMemory,
	unsigned int InterfaceType,
	unsigned char	PortNo,
	unsigned long Baudrate,
	unsigned char *pIp	
	);

typedef int (*pfBTMPAPI_BuildBluetoothModule)(
	BASE_BTMPDLL_MODULE *pBaseBTMPDLLModule,
	BASE_INTERFACE_MODULE *pBaseInterface,
	void *pExtra,
	unsigned char *pTxGainTable,
	unsigned char *pTxDACTable
	);

typedef struct  BASE_BTMPDLLObject{
	pfBTMPAPI_BuildBluetoothModule BTMPAPI_BuildBluetoothModule;
	pfBTMPAPI_BuildInterfaceRTK BTMPAPI_BuildInterfaceRTK;
	pfBTMPAPI_BuildInterfaceVendor BTMPAPI_BuildInterfaceVendor;
    pfBTMPAPI_BluetoothVerify  BTMPAPI_BluetoothVerify;

}BASE_BTMPDLLObject,*pBASE_BTMPDLLObject;

#endif
