//---------------------------------------------------------------------------

#ifndef FormMainUnitH
#define FormMainUnitH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <Grids.hpp>
#include "CGAUGES.h"
#include "ShowUnit.h"
#include <ExtCtrls.hpp>
#include <jpeg.hpp>
#include <ScktComp.hpp>
extern "C"
{
#include "RtlBluetoothMP.h"
}
#include <Dialogs.hpp>
#include "rtkbtTrxThreadUnit.h"

#define MAX_SBTN_NUM_BTAPP 16

#define LEN_0_BYTE 0
#define LEN_1_BYTE 1
#define LEN_2_BYTE 2
#define LEN_3_BYTE 3

#define LEN_5_BYTE 5
#define LEN_6_BYTE 6
#define LEN_7_BYTE 7

#define BYTE_SHIFT 8

#define HCI_VENDOR_MP_READ_TX_POWER_INFO 0xfced
#define HCI_VENDOR_MP_ENABLE_TX_POWER_TRACKING 0xFCE8
#define HCI_READ_BD_ADDR 0x1009


#define CONT_TX_ACTION 0
#define PKT_TX_ACTION 1
#define PKT_RX_ACTION 2
#define LE_CONT_TX_ACTION 3
#define SINGLE_TONE_ACTION 4


enum BT_HCI_EVENT_FIELD
{
	EVT_CODE = 0,
	EVT_PARA_LEN,
	EVT_HCI_CMD_NUM,
	EVT_CMD_OPCODE_0,
	EVT_CMD_OPCODE_1,
	EVT_STATUS,
	EVT_BYTE0,
	EVT_BYTE1,
	EVT_BYTE2,
	EVT_BYTE3,
};


typedef enum
{
	BBPRO_TPM = 0,
	BBPRO_IQM,

}BBPRO_MODE;

//---------------------------------------------------------------------------
class TForm_Main : public TForm
{
__published:	// IDE-managed Components
        TGroupBox *GroupBox3;
        TComboBox *Cbx_Interface;
        TComboBox *Cbx_Interface_port;
        TComboBox *Cbx_Interface_baudrate;
        TTabSheet *TabSheet_NONLINK;
        TTabSheet *TabSheet_RW;
        TComboBox *Cbx_Actionexec;
        TBitBtn *Btn_ActionExec;
        TPageControl *PageControl_Report;
        TTabSheet *TabSheet_TXReport;
        TBitBtn *Btn_ActionStop;
        TTabSheet *TabSheet_RxReport;
        TPageControl *PageControl4;
        TTabSheet *TabSheet7;
        TMemo *Memo_msg;
        TBitBtn *BitBtn3;
        TBitBtn *BitBtn_TestModeEnable;
        TTabSheet *TabSheet_Hopping;
        TBitBtn *Btn_ActionClearReport;
        TStaticText *StaticText13;
        TStaticText *StaticText15;
        TComboBox *Cbx_Hopping_PktType;
        TBitBtn *Btn_HoppingRun;
        TBitBtn *Btn_Hopping_Stop;
        TMainMenu *MainMenu1;
        TPopupMenu *PopupMenu_Msg;
        TMenuItem *SaveLogas1;
        TBitBtn *BitBtn14;
        TRadioButton *RadioButton_RF;
        TRadioButton *RadioButton_MD;
        TTabSheet *TabSheet8;
        TBitBtn *Btn_Dev_Open;
        TRadioButton *RadioButton_BT;
        TComboBox *Combo_BBRegPageNo;
        TRadioButton *RadioButton_MAC;
        TEdit *Edit_RW_ADDR;
        TStaticText *StaticText10;
        TStaticText *StaticText16;
        TStaticText *StaticText17;
        TEdit *Edit_RW_MSB;
        TEdit *Edit_RW_LSB;
        TEdit *Edit_RW_VALUE;
        TStaticText *StaticText18;
        TBitBtn *BitBtn8;
        TCheckBox *Cb_downloadpatch;
        TBitBtn *BitBtn15;
        TOpenDialog *OpenDialog1;
        TSaveDialog *SaveDialog1;
        TCheckBox *Ckb_Whitening;
        TStringGrid *StringGrid_RXReport;
        TStringGrid *StringGrid_TXReport;
        TBitBtn *BitBtn_GetChipInfo;
        TMenuItem *ClearLog1;
        TMenuItem *LoadLog1;
        TTabSheet *TabSheet_Efuse;
        TButton *Button_GetBTStage;
        TEdit *Edit_BT_Stage;
        TPopupMenu *PopupMenu_From;
        TMenuItem *Debug1;
        TMenuItem *TXRXThreadDisable1;
        TGroupBox *GroupBox_Show;
        TCGauge *CGauge_Show;
        TComboBox *ComboBox_Hopping_PayloadType;
        TStaticText *StaticText7;
        TEdit *Edit_Hopping_TxGainValue;
        TStaticText *StaticText19;
        TComboBox *ComboBox_Hopping_TxGainIndex;
        TStaticText *StaticText21;
        TStaticText *StaticText22;
        TComboBox *ComboBox_Hopping_TxDac;
        TBitBtn *BitBtn_PGMPData;
        TGroupBox *GroupBox2;
        TEdit *Edit_Efuse_BDAddr;
        TLabel *Label4;
        TEdit *Edit_Efuse_Thermal;
        TLabel *Label5;
        TLabel *Label6;
        TEdit *Edit_Efuse_Dac;
        TLabel *Label7;
        TComboBox *ComboBox_PowerOnActive;
        TLabel *Label8;
        TComboBox *ComboBox_PowerOnEnable;
        TPanel *Panel_LED;
        TTabSheet *TabSheet_LETest;
        TComboBox *ComboBox_LeTest_Channel;
        TStaticText *StaticText23;
        TStaticText *StaticText24;
        TComboBox *ComboBox_LeTest_PayloadType;
        TStaticText *StaticText25;
        TComboBox *ComboBox_LeTest_Action;
        TBitBtn *Btn_LeTest_Start;
        TBitBtn *Btn_LeTest_Stop;
        TStaticText *StaticText26;
        TEdit *Edit_LeTest_RxCount;
        TComboBox *ComboBox_LeTest_DataLen;
        TLabel *Label9;
        TEdit *Edit_Efuse_Xtal;
        TComboBox *ComboBox_LeTest_TxGainIndex;
        TStaticText *StaticText20;
        TTabSheet *TabSheet_LED;
        TStaticText *StaticText29;
        TStaticText *StaticText30;
        TComboBox *ComboBox_LedNo;
        TComboBox *ComboBox_LedLevel;
        TButton *Button_LedSet;
        TEdit *Edit_Ip_Addr;
        TBitBtn *Btn_Dev_Close;
        TCheckBox *CheckBox_Efuse_BDAddr;
        TCheckBox *CheckBox_Efuse_Thermal;
        TCheckBox *CheckBox_Efuse_Dac;
        TCheckBox *CheckBox_Efuse_Xtal;
        TCheckBox *CheckBox_Efuse_PowerOn;
        TButton *BitBtn_ReadEfuse;
        TBitBtn *Btn_LoadScript;
        TImage *Image1;
        TPageControl *Page_function;
        TBitBtn *BitBtn_TRXReadThermal;
        TSpeedButton *SpeedButton1;
        TMenuItem *EnableControlBTTxPowerIndex1;
        TTabSheet *TabSheet_CFO;
        TBitBtn *BitBtn_CFO_BEGIN;
        TBitBtn *BitBtn_CFO_STOP;
        TLabel *Label_CFO_RET;
        TGroupBox *GroupBox4;
        TCheckBox *CheckBox_CFO_Efuse;
        TEdit *Edit_CFO;
        TBitBtn *BitBtn_CFO_EFUSEWR;
        TBitBtn *BitBtn_CFO_EFUSERD;
        TBitBtn *BitBtn_CFO_REGWR;
        TBitBtn *BitBtn_CFO_REGRD;
        TBitBtn *BitBtn_GETCFO;
        TCheckBox *CheckBox_CALXTAL;
        TCheckBox *CheckBox_VERIFYTX;
        TCheckBox *CheckBox_VERIFYRX;
        TLabel *Label_VERIFY_TX;
        TLabel *Label_VERIFY_RX;
        TMenuItem *CFOPage1;
        TMenuItem *hermalRFProcess1;
        TCheckBox *CheckBox_CFO_NOCHANGE;
        TComboBox *ComboBox_CFO_TH;
        TLabel *Label1_CFOResult;
        TLabel *Label11;
        TLabel *Label12;
        TEdit *Edit_CFO_IN;
        TLabel *Label14;
        TPopupMenu *PopupMenu_CFO;
        TMenuItem *Debug2;
        TMenuItem *DebugRFProgram1;
        TGroupBox *GroupBox5;
        TEdit *Edit_tcpip;
        TBitBtn *BitBtn_SendTcpip;
        TMenuItem *Int1;
        TMenuItem *Internet1;
        TMenuItem *FWExeJobMode1;
        TMenuItem *GetIPHostName1;
        TServerSocket *ServerSocket1;
        TPageControl *PageControl2;
        TTabSheet *TabSheet_Para1;
        TStaticText *StaticText1;
        TComboBox *Cbx_NoLink_Ch;
        TStaticText *StaticText2;
        TStaticText *StaticText3;
        TStaticText *StaticText4;
        TComboBox *Cbx_PktType;
        TComboBox *Cbx_PayloadType;
        TEdit *Edit_PktCount;
        TComboBox *Cbx_TxGainIndex;
        TStaticText *StaticText6;
        TTabSheet *TabSheet_Para2;
        TTabSheet *TabSheet_Cal;
        TGroupBox *GroupBox1;
        TBitBtn *BitBtn_SetRtl8761Xtal;
        TButton *BitBtn_GetRtl8761Xtal;
        TComboBox *Cbx_RTL8761_XTAL;
        TButton *Button_SetPowerTracking;
        TCheckBox *Cb_ConfigFile;
        TTabSheet *TabSheet_PhysicalEfuse;
        TEdit *Edit_PhyEfuseValue;
        TButton *Button_PhysicalEfuseRead;
        TButton *Button_PhysicalEfuseWrite;
        TLabel *Label1;
        TLabel *Label2;
        TLabel *Label10;
        TEdit *Edit_PhyEfuseAddr;
        TEdit *Edit_PhyEfuseBank;
        TLabel *Label13;
        TLabel *Label15;
        TEdit *Edit_PhyEfuseLen;
        TCheckBox *CheckBox_Fw_TxRx_Mode;
        TPopupMenu *PopupMenu_RW;
        TMenuItem *DumpRFRegister1;
        TMenuItem *DumpModomRegister1;
        TMenuItem *Page01;
        TMenuItem *MDPage21;
        TBitBtn *Button_GetPowerTracking;
        TMenuItem *Dump1;
        TMenuItem *EnableEfusePage;
        TMenuItem *DisableReportUpdateMenuItem;
        TTabSheet *TabSheet_MPDebug;
        TMenuItem *EnableMPDebugPage_PopMenu;
        TStringGrid *StringGrid_MPDebugReport;
        TComboBox *ComboBox_MPDebugReport;
        TButton *Button_MPDebugReport;
        TButton *Button_ReadBDAddr;
        TTabSheet *TabSheet_SendHciCmd;
        TEdit *Edit_SendHciCmd_Data;
        TLabel *Label18;
        TEdit *Edit_SendHciCmd_Len;
        TLabel *Label17;
        TEdit *Edit_SendHciCmd_Opcode;
        TLabel *Label16;
        TButton *Button_SendHciCmd;
        TStaticText *StaticText9;
        TEdit *Edit_PktHeader;
        TStaticText *StaticText5;
        TComboBox *ComboBox_HitAddr;
        TCheckBox *CheckBox_WhiteningEnable;
        TBitBtn *BitBtn_ShowTxPower;
        TStaticText *StaticText11;
        TComboBox *ComboBox_LEE_ContTx_PHY;
        TStaticText *StaticText12;
        TStaticText *StaticText14;
        TComboBox *ComboBox_LEE_PHY;
        TComboBox *ComboBox_LEE_Modulation;
        TMenuItem *PageControl1;
        TButton *Button_Set_TPM_IQM;
        TButton *Button_Get_TPM_IQM;
        TRadioGroup *RadioGroup_BBPro_TPM_IQM;
        TTabSheet *TabSheet_DAC;
        TCheckBox *CheckBox_EnableTxDac;
        TStaticText *StaticText8;
        TComboBox *Cbx_TxDacIndex;
        TBitBtn *BitBtn1;
        TButton *Button_Dump_Reg;
        TMenuItem *Enable8723dAntInfo;
        TTabSheet *TabSheet_8723d_Ant_Info;
        TTabSheet *TabSheet_Ant_Info_8723d;
        TRadioGroup *RadioGroup_Ant_Info;
        TEdit *Edit_Diff_S0S1;
        TLabel *Label3;
        TButton *Button_Set_Diff_S0S1;
        TLabel *Label19;
        TRadioGroup *RadioGroup_PowerTracking;
        TTabSheet *LBT_TabSheet;
        TRadioButton *R_LBTMode1;
        TRadioButton *R_LBTMode2;
        TBitBtn *BitBtn2;
        TBitBtn *BitBtn4;
        TGroupBox *GroupBox6;
        TBevel *Bevel1;
        TButton *Button_BBPro_WriteToFlashConfig;
        TTabSheet *TabSheet_BBProFlash;
        TComboBox *ComboBox_MaxTxPowerofLegacy1M;
        TComboBox *ComboBox_MaxTxPowerofLegacy2M;
        TComboBox *ComboBox_MaxTxPowerofLegacy3M;
        TComboBox *ComboBox_TxPowerofLE1MLR;
        TComboBox *ComboBox_TxPowerofLE2M;
        TComboBox *ComboBox_TxPowerofLE2M_2402MHz;
        TComboBox *ComboBox_TxPowerofLE2M_2480MHz;
        TComboBox *ComboBox_BREDRPowerControlLevelNumber;
        TLabel *Label_MaxTxPowerofLegacy3M;
        TLabel *Label_MaxTxPowerofLegacy2M;
        TLabel *Label_MaxTxPowerofLegacy1M;
        TLabel *Label_TxPowerofL1MLR;
        TLabel *Label_TxPowerofLE2M;
        TLabel *Label_TxPowerofLE2M_2402MHz;
        TLabel *Label_TxPowerofLE2M_2480MHz;
        TLabel *Label_BREDRPowerControlLevelNumber;
        TComboBox *ComboBox_Flatness2402_2423MHz;
        TLabel *Label_Flatness2402_2423MHz;
        TLabel *Label22;
        TLabel *Label23;
        TComboBox *ComboBox_Flatness2424_2445MHz;
        TComboBox *ComboBox_Flatness2446_2463MHz;
        TComboBox *ComboBox_AdaptivityEnable;
        TComboBox *ComboBox_Flatness2464_2480MHz;
        TComboBox *ComboBox_AdaptivityAntennaGain;
        TComboBox *ComboBox_DefaultBREDRTxPowerLevel;
        TLabel *Label_Flatness2424_2445MHz;
        TLabel *Label_Flatness2446_2463MHz;
        TLabel *Label_Flatness2464_2480MHz;
        TLabel *Label_Adaptivity_LBT_Enable;
        TLabel *Label_Adaptivity_LBT_AntennaGain;
        TLabel *Label_DefaultBREDRTxPowerLevel;
        TButton *Button_WriteRFtoFlashConfig;
        TButton *Button1;
        TButton *Button2;
        TMenuItem *About1;
        TMenuItem *EnableReadWriteRegisterPage;
        TButton *Button_Show_SNR;
        TStaticText *StaticText27;
        TStaticText *StaticText28;
        TComboBox *ComboBox_Hopping_StartCh;
        TComboBox *ComboBox_Hopping_StopCh;
        TComboBox *ComboBox_Hopping_Type;
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall Btn_Dev_OpenClick(TObject *Sender);
        void __fastcall Cbx_InterfaceChange(TObject *Sender);
        void __fastcall Btn_HoppingRunClick(TObject *Sender);
        void __fastcall Btn_Hopping_StopClick(TObject *Sender);
        void __fastcall BitBtn15Click(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall Btn_Dev_CloseClick(TObject *Sender);
        void __fastcall BitBtn3Click(TObject *Sender);
        void __fastcall Btn_ActionExecClick(TObject *Sender);
        void __fastcall Btn_ActionStopClick(TObject *Sender);
        void __fastcall Btn_ActionClearReportClick(TObject *Sender);

        void __fastcall BitBtn8Click(TObject *Sender);
        void __fastcall BitBtn14Click(TObject *Sender);
        void __fastcall BitBtn_GetChipInfoClick(TObject *Sender);
        void __fastcall ClearLog1Click(TObject *Sender);
        void __fastcall SaveLogas1Click(TObject *Sender);
        void __fastcall LoadLog1Click(TObject *Sender);
        void __fastcall BitBtn_TestModeEnableClick(TObject *Sender);
        void __fastcall BitBtn_SetTxGainTable2DefaultClick(TObject *Sender);
        void __fastcall BitBtn_SetTxDACTable2DefaultClick(TObject *Sender);
        void __fastcall BitBtn_SetRtl8761XtalClick(TObject *Sender);
        void __fastcall BitBtn_ReadThermalClick(TObject *Sender);
        void __fastcall BitBtn_GetRtl8761XtalClick(TObject *Sender);
        void __fastcall Button_GetBTStageClick(TObject *Sender);
        void __fastcall TXRXThreadDisable1Click(TObject *Sender);
        void __fastcall BitBtn_PGMPDataClick(TObject *Sender);
        void __fastcall Btn_LeTest_StartClick(TObject *Sender);
        void __fastcall Btn_LeTest_StopClick(TObject *Sender);
        void __fastcall ComboBox_LeTest_ActionChange(TObject *Sender);
        void __fastcall Button_ToFactoryAreaClick(TObject *Sender);
        void __fastcall CheckBox_EnableTxDacClick(TObject *Sender);
        void __fastcall Button_LedSetClick(TObject *Sender);
        void __fastcall BitBtn_ReadEfuseClick(TObject *Sender);
        void __fastcall Btn_LoadScriptClick(TObject *Sender);
        void __fastcall FormKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall Edit_RW_MSBKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall Edit_RW_LSBKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall Edit_RW_MSBExit(TObject *Sender);
        void __fastcall Edit_RW_LSBExit(TObject *Sender);
        void __fastcall Edit_RW_VALUEKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall Edit_RW_VALUEExit(TObject *Sender);
        void __fastcall BitBtn_TRXReadThermalClick(TObject *Sender);
        void __fastcall SpeedButton1Click(TObject *Sender);
        void __fastcall BitBtn1Click(TObject *Sender);
        void __fastcall EnableControlBTTxPowerIndex1Click(TObject *Sender);
        void __fastcall BitBtn_CFO_BEGINClick(TObject *Sender);
        void __fastcall BitBtn_CFO_STOPClick(TObject *Sender);
        void __fastcall Page_functionChange(TObject *Sender);
        void __fastcall BitBtn_CFO_EFUSEWRClick(TObject *Sender);
        void __fastcall BitBtn_CFO_REGWRClick(TObject *Sender);
        void __fastcall BitBtn_CFO_REGRDClick(TObject *Sender);
        void __fastcall BitBtn_CFO_EFUSERDClick(TObject *Sender);
        void __fastcall BitBtn_GETCFOClick(TObject *Sender);
        void __fastcall CFOPage1Click(TObject *Sender);
        void __fastcall Debug2Click(TObject *Sender);
        void __fastcall DebugRFProgram1Click(TObject *Sender);
        void __fastcall FWExeJobMode1Click(TObject *Sender);
        void __fastcall Internet1Click(TObject *Sender);
        void __fastcall GetIPHostName1Click(TObject *Sender);
        void __fastcall ServerSocket1Accept(TObject *Sender,
          TCustomWinSocket *Socket);
        void __fastcall ServerSocket1ClientConnect(TObject *Sender,
          TCustomWinSocket *Socket);
        void __fastcall ServerSocket1ClientDisconnect(TObject *Sender,
          TCustomWinSocket *Socket);
        void __fastcall ServerSocket1ClientRead(TObject *Sender,
          TCustomWinSocket *Socket);
        void __fastcall BitBtn_SendTcpipClick(TObject *Sender);
        void __fastcall Cbx_PktTypeChange(TObject *Sender);
        void __fastcall Cbx_ActionexecChange(TObject *Sender);
        void __fastcall Button_SetPowerTrackingClick(TObject *Sender);
        void __fastcall Button_PhysicalEfuseReadClick(TObject *Sender);
        void __fastcall Button_PhysicalEfuseWriteClick(TObject *Sender);
        void __fastcall CheckBox_Fw_TxRx_ModeClick(TObject *Sender);
        void __fastcall Cbx_Hopping_PktTypeChange(TObject *Sender);
        void __fastcall DumpRFRegister1Click(TObject *Sender);
        void __fastcall Page01Click(TObject *Sender);
        void __fastcall Button_GetPowerTrackingClick(TObject *Sender);
        void __fastcall MDPage21Click(TObject *Sender);
        void __fastcall Dump1Click(TObject *Sender);
        void __fastcall EnableEfusePageClick(TObject *Sender);
        void __fastcall DisableReportUpdateMenuItemClick(TObject *Sender);
        void __fastcall EnableMPDebugPage_PopMenuClick(TObject *Sender);
        void __fastcall ComboBox_MPDebugReportChange(TObject *Sender);
        void __fastcall Button_MPDebugReportClick(TObject *Sender);
        void __fastcall Button_ReadBDAddrClick(TObject *Sender);
        void __fastcall Button_SendHciCmdClick(TObject *Sender);
        void __fastcall BitBtn_ShowTxPowerClick(TObject *Sender);
        void __fastcall Button_Set_TPM_IQMClick(TObject *Sender);
        void __fastcall Button_Get_TPM_IQMClick(TObject *Sender);
        void __fastcall Button_Dump_RegClick(TObject *Sender);
        void __fastcall Enable8723dAntInfoClick(TObject *Sender);
        void __fastcall Button_Set_Diff_S0S1Click(TObject *Sender);
        void __fastcall BitBtn2Click(TObject *Sender);
        void __fastcall BitBtn4Click(TObject *Sender);
        void __fastcall Button_BBPro_WriteToFlashConfigClick(
          TObject *Sender);
        void __fastcall Button_WriteRFtoFlashConfigClick(TObject *Sender);
        void __fastcall ComboBox_BREDRPowerControlLevelNumberChange(
          TObject *Sender);
        void __fastcall About1Click(TObject *Sender);
        void __fastcall EnableReadWriteRegisterPageClick(TObject *Sender);
        void __fastcall Button_Show_SNRClick(TObject *Sender);
        void __fastcall ComboBox_Hopping_TypeChange(TObject *Sender);
        void __fastcall ComboBox_Hopping_StartChChange(TObject *Sender);



private:	// User declarations

    TWndMethod OldFormWndProc;
    int __fastcall DeviceChgMsg(TMessage &Message);
	
public:		// User declarations
        __fastcall TForm_Main(TComponent* Owner);

public:
	//dll object
	BASE_BTMPDLLObject mBaseDLLObject;
	BASE_BTMPDLLObject *pBaseDLLObject;

	//bt para , report , info
	BT_PARAMETER mBT_PARAMETER;
	BT_DEVICE_REPORT mBT_DEVICE_REPORT;
	BT_CHIPINFO mBT_CHIPINFO;
	unsigned char isTPM;

	//module
	BASE_INTERFACE_MODULE *pBaseInterface;
	BASE_INTERFACE_MODULE BaseInterfaceModuleMemory;
	BASE_BTMPDLL_MODULE *pBluetoothModule;
	BASE_BTMPDLL_MODULE BluetoothModuleMemory;

	// 0 : max tx power index
	// 1 : 1 M default tx power index 
	// 2 : 2M default tx power index
	// 3 : 3M default tx power index 
	// 4 : LE default tx power index
	#define MAX_TX_POWER_INDEX 0
	#define DEFAULT_1M_TX_POWER_INDEX 1
	#define DEFAULT_2M_TX_POWER_INDEX 2
	#define DEFAULT_3M_TX_POWER_INDEX 3
	#define DEFAULT_LE_TX_POWER_INDEX 4
	unsigned char TxPowerLevelInfo[LEN_5_BYTE];

        void UI_Init();
        int  API_bt_LoadMpDll();
        void API_bt_releaseMpDll();
        void UI_Clear_TXReport(int Tx_Rx);
        int  API_bt_inface(int interface_type,int PortNo,int Baudrate,unsigned char *pIp);
        int  API_bt_Download_PatchCode(int Defaultpath_Flag,char *new_Filepath);
	int API_bt_ShowTxDefaultPower();		
        int  API_bt_GetChipInfo(unsigned int *ChipType) ;
        int  API_bt_HciReset();
        int  API_bt_SetPara1(BT_PARAMETER *pParam,int Exec);
        int  API_bt_SetPara2(BT_PARAMETER *pParam,int Exec);
        int  API_bt_SetPara3(BT_PARAMETER *pParam,int Exec);
        int  API_ReadCurrentTxDacValue(unsigned char  *TxDacValue);
	int API_bt_fw_read_power_info();
	int API_bt_get_power_index();
	int DetectAttachedPorts();
		

        rtkbtTrx  *Thread_TRX;
        void TrxFixObject(bool Fix);
	int TForm_Main::WriteMpParamterToConfig(unsigned char Index, unsigned char *pData);
	int WriteMpParamterToEfuse(unsigned char *BD_Addr,unsigned char ThermalValue,unsigned char TxPowerDac, unsigned char Xtal);
	int BaseWriteMpParamterToEfuse(unsigned char Index, unsigned char *pData);
	int WriteMpPowerOnFunctionToEfuse(int PowerOn_enable,int PowerOn_Active);
	SowObject *ShowUI;


        int  Register_Write(unsigned char regType,
                                unsigned long RegStartAddr,
                                unsigned char Page,
                                unsigned char Msb,
                                unsigned char Lsb,
                                unsigned long Value);
        int  Sctipt_Process(char *filename);

         TSpeedButton *sbtnArray[MAX_SBTN_NUM_BTAPP];
         TLabel       *sLabelArray[MAX_SBTN_NUM_BTAPP];
         int CreatsButtonArray();
         void __fastcall sButtonOnClick(TObject *Sender);
         void  Assign_DataToBtn();
         void  Assign_BtnToData();
         void  Assign_BtnShow();
         int   API_ReadThermalValue(unsigned long *Value);
         int   API_SetNewPowerValue(unsigned long Value);
         int   InterfaceType;
         void  MSGPRINTF(String dstr);
         void API_bt_GetBTDefaultTxPower(unsigned int ChipType,int *Power_Inde);
         int Verify_GetLastError(BT_VERIFY_PARMERTER *pCfoParamter);
         void DebugCFOUI();

         int   OpenDevice();
         void   CloseDevice();
        //---------------------------------------------------------------------------
        //
        //   Matlab  call BTAPP
        //

        //---------------------------------------------------------------------------
        int api_parse_str2buf(char *parse_str,char *pbuf,int *pbuf_len);
        int api_tcpip_bt_mp_parse_data(char *psur,ULONG *data,int max_dataNumber,int *dataNum,char *pdesc);
        int api_parse_tcpip_command(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen);
        void api_tcpip_GetHostNameAndIPAddress();

        int api_process_tcpip_command(char *pcmd, int Index,UINT8 *pRtn,UINT16 *pRtnLen);

        int api_tcpip_bt_mp_HciCmd_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen);
        int api_tcpip_bt_mp_RegRW_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen);
        int api_tcpip_bt_mp_rtlbtmp_enable_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen);
        int api_tcpip_bt_mp_Exec_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen);
        int api_tcpip_bt_mp_RecvEvtprocess(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen);
        void api_tcpip_bt_mp_InitDefaultParameter();

        BT_PARAMETER            tcpip_mBT_PARAMETER;
		unsigned char bFwTxRxMode;

	    unsigned char FormBTDebug_flag;
		BASE_FP_OPEN bt_debug_Open;
		BASE_FP_SEND bt_debug_Send;
		BASE_FP_RECV bt_debug_Recv;
		BASE_FP_CLOSE bt_debug_Close;
        BASE_FP_WAIT_MS bt_debug_WaitMs;

    BEGIN_MESSAGE_MAP
        MESSAGE_HANDLER(WM_DEVICECHANGE,TMessage,DeviceChgMsg)
    END_MESSAGE_MAP(inherited)		

};
//---------------------------------------------------------------------------
extern PACKAGE TForm_Main *Form_Main;
//---------------------------------------------------------------------------
#endif
