//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <dbt>
#include <initguid.h>
#include <direct.h>
#include <stdio.h>
#include <time.h>


#include "FormMainUnit.h"
#include "rtkbtTrxThreadUnit.h"
#include "rtkbtTScriptThread.h"
#include <stdio.h>

//#define ACTS_BUMBLEBEE
//#define ACTS_BUMBLEBEE_UART
#define DISABLE_CAL_PAGE

#define DISABLE_RadioGroup_Thermal

#define BBPRO_RF_TOOL 

/*///////////////////////////////////////////////////////////////////////*/


/*///////////////////////////////////////////////////////////////////////*/
extern "C"
{
        #include "bt_mp_dll_build.h"
        #include "RtlBluetoothMP.h"
       // #include "bt_Actsio.h"
}
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CGAUGES"
#pragma resource "*.dfm"
TForm_Main *Form_Main;

#define   DBG_ON

#ifdef DBG_ON

        void DBGPRINTF(char *prompt, ...)
        {
        char buf[16384];
        va_list argptr;
    //    int cnt;

        va_start(argptr, prompt);
        vsprintf(buf, prompt, argptr);
        OutputDebugString(buf);
        va_end(argptr);
        return ;
        }
#else
        void DBGPRINTF(char *prompt, ...)
        {
          return ;
        }
#endif


unsigned char TxGainTable[4][7]={
                                                {0x49,0x4d,0x69,0x89,0x8d,0xa9,0xa9},  //RTL8723A
                                                {0x49,0x4d,0x69,0x89,0x8d,0xa9,0xa9},  //RTL8723B
                                                {0x49,0x4d,0x69,0x89,0x8d,0xa9,0xa9},  //RTL8821A
                                                {0x49,0x4d,0x69,0x89,0x8d,0xa9,0xa9}   //RTL8761A
                };  //RTL8761 Table
unsigned char TxDACTable[4][5]={
                                                {0x10,0x11,0x12,0x13,0x14},   //RTL8723A
                                                {0x10,0x11,0x12,0x13,0x14},   //RTL8723B
                                                {0x10,0x11,0x12,0x13,0x14},   //RTL8821A
                                                {0x10,0x11,0x12,0x13,0x14}    //RTL8761A
                                                };

char InterFaceTypeDesc[][30] ={
	"USB" ,
	"COM UART",
	"Filter UART",
	"Adb for BT UART",
	"Adb for BT USB",
	"Socket for BT UART",
	"Socket for BT USB",
	"Bumble Bee USB"
};

#define InterFaceTypeDescNumber   8

#define VERSION_STR  ""



//DEFINE_GUID( GUID_CLASS_USBHUB,    0xf18a0e88, 0xc30c, 0x11d0, 0x88, 0x15, 0x00, \
//             0xa0, 0xc9, 0x06, 0xbe, 0xd8);
//DEFINE_GUID(GUID_CLASS_USB_DEVICE, 0xA5DCBF10L, 0x6530, 0x11D2, 0x90, 0x1F, 0x00, \
//             0xC0, 0x4F, 0xB9, 0x51, 0xED);


//HDEVNOTIFY      gNotifyDevHandle;
//HDEVNOTIFY      gNotifyHubHandle;



int CFO_CALLBACK(BT_VERIFY_REPORT *pReport);


static void bt_mp_skip_blanks(char **p)
{
	while (**p == ' ')
		(*p)++;
}

static unsigned int string_to_num(char **p, int DefaultValue)
{
	unsigned char NegativeNum;
	unsigned int Value = 0;
	unsigned char   UseDefault;

	NegativeNum = 0;
	UseDefault = 1;
	bt_mp_skip_blanks(p);

	if(**p == '0' &&*(*p+1) == 'x')
	{
		(*p) = (*p)+2;

		while ( ((**p)<= '9' && (**p)>= '0') ||
			((**p)<= 'f' && (**p)>= 'a') ||
			((**p)<= 'F' && (**p)>= 'A') )
		{
			if (**p >= 'a')
	 			Value = Value * 16 + (**p) - 'a' + 10;
			else if (**p >= 'A')
				Value = Value * 16 + (**p) - 'A' + 10;
			else
				Value = Value * 16 + (**p) - '0';

			UseDefault = 0;
			(*p)++;
		}
	}
	else if ( (**p) == '-')
	{
		(*p)++;
	
		while ( ((**p)<= '9' && (**p)>= '0') )
		{
			Value = Value * 10 + (**p) - '0';
			UseDefault = 0;
			(*p)++;
		}

		Value = (-1)*Value;
	}
	else
	{
		while ( ((**p)<= '9' && (**p)>= '0') )
		{
			Value = Value * 10 + (**p) - '0';
			UseDefault = 0;
			(*p)++;
		}
	
	}

	if(UseDefault)
		return DefaultValue;
	else
		return Value;
}


void TForm_Main::MSGPRINTF(String dstr)
{
	Memo_msg->Lines->Add(dstr);
	return;
}


#define MAX_KEY_LENGTH 255
#define MAX_VALUE_NAME 2048

int TForm_Main::DetectAttachedPorts()
{
	HKEY hKey;
	LONG retCode;
	String dstr;
	unsigned int ComNo;

	Cbx_Interface_port->Items->Clear();

	retCode = RegOpenKeyEx(
		HKEY_LOCAL_MACHINE,
		_T("HARDWARE\\DEVICEMAP\\SerialComm"),
		0,
		KEY_READ,
		&hKey);
	if (retCode == ERROR_SUCCESS)
	{
		DWORD    cSubKeys = 0;            // number of subkeys
		DWORD    cValues;				  // number of values for key

		retCode = RegQueryInfoKey(
			hKey,					// hKey: key handle
			NULL,					// lpClass: A pointer to a buffer that receives the user-defined class of the key
			NULL,					// lpcClass: A pointer to a variable that specifies the size of the buffer pointed to by the lpClass
			NULL,					// reserved
			&cSubKeys,				// lpcSubKeys: number of subkeys
			NULL,					// lpcMaxSubKeyLen: longest subkey size
			NULL,					// lpcMaxClassLen: longest class string
			&cValues,				// lpcValues: number of values for this key
			NULL,					// lpcMaxValueNameLen: longest key value name
			NULL,					// lpcMaxValueLen: longest key value data
			NULL,					// security descriptor
			NULL);					// last write time
		if (retCode != ERROR_SUCCESS)
		{
			dstr.sprintf("DetectAttachedPorts: RegQueryInfoKey failed, retCode %d\n", retCode);
			Memo_msg->Lines->Add(dstr);
			return 0;
		}
		//else
		//{
			//dstr.sprintf("DetectAttachedPorts: subkeys number: %d, key values num %d\n", cSubKeys, cValues);
			//Memo_msg->Lines->Add(dstr);
		//}

		// Enumerate the key values. 
		if (cValues)
		{
			TCHAR  achValue[MAX_VALUE_NAME];
			DWORD cchValue = MAX_VALUE_NAME;
			DWORD lpType = 0;
			BYTE lpData[MAX_VALUE_NAME];
			char *p;
			DWORD lpcbData = MAX_VALUE_NAME;

			for (DWORD i = 0, retCode = ERROR_SUCCESS; i < cValues; i++)
			{
				cchValue = MAX_VALUE_NAME;
				achValue[0] = '\0';
				lpcbData = MAX_VALUE_NAME;

				retCode = RegEnumValue(hKey, i,
					achValue,
					&cchValue,
					NULL,
					&lpType,
					lpData,
					&lpcbData);
				if (retCode == ERROR_SUCCESS)
				{
					dstr.sprintf("DetectAttachedPorts: (%d) %s\n",  i, (LPTSTR)lpData);
					Memo_msg->Lines->Add(dstr);

					if( (lpData[0]=='C') && (lpData[1]=='O') && (lpData[2]=='M') )
					{
						p = lpData+3;
						ComNo = string_to_num( &p, 0);
						dstr.sprintf("%d",  ComNo);
						
						Cbx_Interface_port->Items->Add(dstr);
					}
					
				}
			}
		} // cValues

	}

	Cbx_Interface_port->ItemIndex=0;

	return 0;
}




int __fastcall TForm_Main::DeviceChgMsg(TMessage &Message)
{
	switch (Message.WParam) 
	{
		case DBT_DEVICEARRIVAL:
			//Memo_msg->Lines->Add("sJF@˸m!");
			DetectAttachedPorts();
			//Button_DetectedModulePortNumClick(NULL);
		break;
		 
		case DBT_DEVICEREMOVECOMPLETE:
			DetectAttachedPorts();
			//Memo_msg->Lines->Add("F@˸m!");
			//Button_DetectedModulePortNumClick(NULL);
		break;
		 
		//case DBT_DEVNODES_CHANGED:
		//	Memo_msg->Lines->Add("DBT_DEVNODES_CHANGED");
		//break;
	}
	return 0;
}


__fastcall TForm_Main::TForm_Main(TComponent* Owner)
        : TForm(Owner)
{
	HFONT hFont;
	HIMAGELIST himl;
	HICON hicon;
	DEV_BROADCAST_DEVICEINTERFACE broadcastInterface;

        TObject *Sender;
	String dstr;
	int n=0;

	float AntennaGain;
        //---------------------------------------------------//
        FormBTDebug_flag=0;
                 //basic fuction
	bt_debug_Open= NULL;
	bt_debug_Send=NULL;
	bt_debug_Recv=NULL;
	bt_debug_Close=NULL;
	bt_debug_WaitMs=NULL;
    FormBTDebug_flag=0;
   
	GroupBox_Show->Visible=false;
       TabSheet_CFO->TabVisible= false;
	ShowUI=NULL;
      //  Form_Main->Caption = 
	UI_Init();
	//dll object
	pBaseDLLObject = NULL;
	//module
	pBluetoothModule=NULL;
	pBaseInterface=NULL;

	//pBluetoothModule=&BluetoothModuleMemory;
	//pBaseInterface=&BaseInterfaceModuleMemory;

	//UI
	Cbx_Interface->Items->Clear();
	for (n =0 ; n< LEN_3_BYTE; n++ )
	{
		dstr.sprintf("%s",InterFaceTypeDesc[n]);
		Cbx_Interface->Items->Add(dstr);

	}
	Cbx_Interface_port->Visible=true;
	Cbx_Interface_baudrate->Visible=false;
	Thread_TRX=NULL;
	Cbx_Actionexec->ItemIndex=0;
	Cbx_PayloadType->ItemIndex=0;
	Cbx_PktType->ItemIndex=0;
	Cbx_NoLink_Ch->ItemIndex=0;
	Cbx_Hopping_PktType->ItemIndex = 0;

	Cbx_Interface_port->ItemIndex=4;
	Cbx_Interface->ItemIndex=1;
	ComboBox_LeTest_Action->ItemIndex = 0;

	CheckBox_Fw_TxRx_Mode->Enabled = false;

	Btn_Dev_Close->Enabled=false;
        CreatsButtonArray();
        dstr.sprintf("Bluetooth RF Test Tool %s",VERSION_STR);
        Form_Main->Caption = dstr;
   //     Form_Main->Icon->lo
        Page_function->ActivePage = TabSheet_NONLINK;


        Cbx_RTL8761_XTAL->Visible=true;
        Label1_CFOResult->Visible=false;
        Application->Title = "Realtek Bluetooth RF Test Tool";
        TabSheet_PhysicalEfuse->TabVisible=false;


        LBT_TabSheet->TabVisible = false;


#ifdef ACTS_BUMBLEBEE
       Application->Title = "Bluetooth Test Tool"  ;
       Application->Icon->LoadFromFile("acts_logo_24.ico");
       CheckBox_VERIFYTX->Enabled=false;
       CheckBox_VERIFYRX->Enabled=false;
  //     TabSheet_CFO->TabVisible=true;
     //  PageControl5->Visible=false;
     //  Image1->Visible=false;
      //  TabSheet_NONLINK->TabVisible=false;
      //  TabSheet_Hopping->TabVisible=false;
       // TabSheet_RW->TabVisible=false;
        TabSheet_Efuse->TabVisible=false;
        TabSheet_LETest->TabVisible=true;

       // Cbx_Interface->Enabled=false;
       Form_Main->Width += 20;
       Cbx_Interface->Items->Clear();
       Cbx_Interface->Items->Add("BT ONLY UART");
       Cbx_Interface->Items->Add("ACT MP USB");
       Cbx_Interface->ItemIndex=1;
     //  Cbx_InterfaceChange(Sender);
   //    Page_function->ActivePage = TabSheet_CFO;
       Page_functionChange(Sender);
       Image1->AutoSize=true;
       Image1->Picture->LoadFromFile("acts.JPG");
       Image1->Left = Image1->Left+80;
    //   Btn_Dev_Open->Left =Btn_Dev_Open->Left -200;
    //   Btn_Dev_Close->Left=Btn_Dev_Close->Left-200;
     //  Cb_downloadpatch->Left=Cb_downloadpatch->Left-200;
    //   Image1->Height =Image1->Height =
     //  GroupBox3->Width = GroupBox3->Width -200;
       Form_Main->Icon->LoadFromFile("acts_logo_16.ico");
       FWExeJobMode1->Checked=false;


       BitBtn_TRXReadThermal->Visible=false;
       TabSheet_CFO->TabVisible= true;
Label_VERIFY_TX->Visible=false;
Label_VERIFY_RX->Visible=false;
CheckBox_VERIFYTX->Visible=false;
CheckBox_VERIFYRX->Visible=false;
Label1_CFOResult->Visible=true;
Label1_CFOResult->Caption="Ready....";
PageControl5->Visible=false;
 DebugCFOUI();
 Form_Main->Width = Memo_msg->Left+Memo_msg->Width+10;
 Form_Main->Height= Form_Main->Height +15;

  TabSheet_Cal->TabVisible=false;
  TabSheet_DAC->TabVisible=false;


#endif



#ifdef DISABLE_CAL_PAGE
       TabSheet_CFO->TabVisible= false;
#else
       TabSheet_CFO->TabVisible= true;
#endif

Edit_PktHeader->Enabled=false;
Label_VERIFY_TX->Visible=false;
Label_VERIFY_RX->Visible=false;
CheckBox_VERIFYTX->Visible=false;
CheckBox_VERIFYRX->Visible=false;
Label1_CFOResult->Visible=true;
Label1_CFOResult->Caption="Ready....";


Cbx_InterfaceChange(Sender);
api_tcpip_bt_mp_InitDefaultParameter();

	ComboBox_HitAddr->ItemIndex =1;
	Cbx_PayloadType->ItemIndex =7;
	ComboBox_MPDebugReportChange(Sender);
	TabSheet_Efuse->TabVisible = false;
	TabSheet_MPDebug->TabVisible = false;
	TabSheet_SendHciCmd->TabVisible = false;

	//BBpro
	TabSheet_Cal->TabVisible = false;
	TabSheet_DAC->TabVisible = false;
	TabSheet_RW->TabVisible = false;
	TabSheet_Hopping->TabVisible = true;
	TabSheet_Ant_Info_8723d->TabVisible = false;
        LBT_TabSheet->TabVisible = false;

#ifdef BBPRO_RF_TOOL
	Cb_downloadpatch->Visible = false;
	Cb_downloadpatch->Checked = false;
	Cb_ConfigFile->Visible = false;
#else
	Cb_downloadpatch->Visible = true;
	Cb_downloadpatch->Checked = true;
	Cb_ConfigFile->Visible = true;
#endif


	BitBtn15->Visible = false;
	BitBtn_GetChipInfo->Visible = false;
	Button_GetBTStage->Visible = false;
	Edit_BT_Stage->Visible = false;
	Btn_LoadScript->Visible = false;
	BitBtn_TRXReadThermal->Visible = false;
	Button_ReadBDAddr->Visible = false;
	BitBtn_ShowTxPower->Visible = false;
	Button_GetPowerTracking->Visible = false;
	Button_SetPowerTracking->Visible = false;
	RadioGroup_PowerTracking->Visible = false;
	ComboBox_LeTest_TxGainIndex->Enabled = true;
	CheckBox_EnableTxDac->Visible = false;
	StaticText8->Visible = false;
	BitBtn1->Visible = false;

	ComboBox_AdaptivityAntennaGain->Items->Clear();
	for (AntennaGain=-10; AntennaGain<=6; AntennaGain+=0.5)
	{
		dstr.sprintf("%.1f dBi",AntennaGain);
		ComboBox_AdaptivityAntennaGain->Items->Add(dstr);
	}
	ComboBox_AdaptivityAntennaGain->Items->Add("No Used");
	ComboBox_AdaptivityAntennaGain->ItemIndex = 20;

	ComboBox_BREDRPowerControlLevelNumberChange(NULL);


	DetectAttachedPorts();	

	Cbx_Hopping_PktTypeChange(NULL);

#if 0
	// Register to receive notification when a USB device is plugged in.
	broadcastInterface.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
	broadcastInterface.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;

	memcpy( &(broadcastInterface.dbcc_classguid),
			&(GUID_CLASS_USB_DEVICE),
			sizeof(struct _GUID));

	gNotifyDevHandle = RegisterDeviceNotification(Handle,
										&broadcastInterface,
										DEVICE_NOTIFY_WINDOW_HANDLE);

	// Now register for Hub notifications.
	memcpy( &(broadcastInterface.dbcc_classguid),
				&(GUID_CLASS_USBHUB),
				sizeof(struct _GUID));

#endif

#if 0
	TabSheet_NONLINK->TabVisible= false;
	TabSheet_Hopping->TabVisible= false;
	TabSheet_RW->TabVisible= false;
	TabSheet_LED->TabVisible= false;
	TabSheet_CFO->TabVisible= false;
	TabSheet_PhysicalEfuse->TabVisible= false;
#endif	
}



void TForm_Main::UI_Clear_TXReport(int Tx_Rx)
{
	int n=0;
	if ((Tx_Rx ==0) || (Tx_Rx >2))
	{
		StringGrid_TXReport->ColCount=2;
		StringGrid_TXReport->RowCount=3;

		for (n=0;n<StringGrid_TXReport->RowCount;n++)
			StringGrid_TXReport->RowHeights[n]=15;

		StringGrid_TXReport->Cells[0][0] = "Item";
		StringGrid_TXReport->Cells[1][0] = "Value";
		StringGrid_TXReport->Cells[0][1] = "Tx bits";
		StringGrid_TXReport->Cells[0][2] = "Tx Pkt Count";
		StringGrid_TXReport->ColWidths[0]=100;
		StringGrid_TXReport->ColWidths[1]=StringGrid_TXReport->Width- StringGrid_TXReport->ColWidths[0];

		StringGrid_TXReport->Cells[1][1]="000000";  //tx bits
		StringGrid_TXReport->Cells[1][2]="000000" ; //Tx Pkt Count
	}

	if ((Tx_Rx ==1) || (Tx_Rx >2))
	{
		StringGrid_RXReport->ColCount=2;
		StringGrid_RXReport->RowCount=7;
		StringGrid_RXReport->Cells[0][0] = "Item";
		StringGrid_RXReport->Cells[1][0] = "Value";

		StringGrid_RXReport->Cells[0][1] = "Rssi";
		StringGrid_RXReport->Cells[0][2] = "Rx bits";
		StringGrid_RXReport->Cells[0][3] = "Rx Error bits";
		StringGrid_RXReport->Cells[0][4] = "Rx Pkt Count";
		StringGrid_RXReport->Cells[0][5] = "ber";
		StringGrid_RXReport->Cells[0][6] = "cfo";

		StringGrid_RXReport->ColWidths[0]=100;
		StringGrid_RXReport->ColWidths[1]=StringGrid_TXReport->Width- StringGrid_TXReport->ColWidths[0];

		StringGrid_RXReport->Cells[1][1]="-90";     //Rssi
		StringGrid_RXReport->Cells[1][2]="000000" ; //Rx bits
		StringGrid_RXReport->Cells[1][3]="000000";  //Rx Error bits
		StringGrid_RXReport->Cells[1][4]="000000" ; //Rx Pkt Count
		StringGrid_RXReport->Cells[1][5]="000000";  //ber
		StringGrid_RXReport->Cells[1][6]="0";  //cfo
        
		for (n=0;n<StringGrid_RXReport->RowCount;n++)
			StringGrid_RXReport->RowHeights[n]=15;
	}
	return ;
}



void TForm_Main::UI_Init()
{
	int n=0;
	int i;
	
	String dstr;
	// channel
	Cbx_NoLink_Ch->Items->Clear();
	for (n=0;n<79;n++)
	{
		dstr.sprintf("%d",n);
		Cbx_NoLink_Ch->Items->Add(dstr);
	}
	Cbx_NoLink_Ch->ItemIndex=0;
	//-------------------------------
        //hopping page

       //	ComboBox_Hopping_PayloadType->Visible =true;
      //	ComboBox_Hopping_TxGainIndex->Visible=true;
      //	Edit_Hopping_TxGainValue->Visible=true;
      //	ComboBox_Hopping_TxDac->Visible=true;
     //	Cbx_TxDacIndex->Visible = false;

	ComboBox_Hopping_PayloadType->Enabled=false;
	ComboBox_Hopping_TxGainIndex->Enabled=false;
	Edit_Hopping_TxGainValue->Enabled=false;
	ComboBox_Hopping_TxDac->Enabled=false;
	Cbx_TxDacIndex->Enabled = false;
      //  Ckb_Whitening->Enabled=false;

	//port
	Cbx_Interface_port->Items->Clear();
	for (n=0;n<10;n++)
	{
		dstr.sprintf("%d",n);
		Cbx_Interface_port->Items->Add(dstr);
	}

	//Barudate
	Cbx_Interface_baudrate->ItemIndex=1;

	//TStringGrid *StringGrid_RXReport;
	//TStringGrid *StringGrid_TXReport;


	//report
	//==================================================================
	UI_Clear_TXReport(3);


	PageControl2->ActivePage= TabSheet_Para1;
	PageControl_Report->ActivePage= TabSheet_TXReport;


	ComboBox_LeTest_Channel->Items->Clear();
	for (i=0; i<=39; i++)
	{
		dstr.sprintf("%d",i);
		ComboBox_LeTest_Channel->Items->Add(dstr);
	}

	ComboBox_LeTest_Channel->ItemIndex = 0;
	ComboBox_LeTest_PayloadType->ItemIndex = 0;
	Edit_LeTest_RxCount->Enabled = false;



	ComboBox_LedNo->Items->Clear();
	ComboBox_LedLevel->Items->Clear();

	for( i=0; i<2; i++)
	{
		dstr.sprintf("%d",i);
		ComboBox_LedNo->Items->Add(dstr);
	}


	dstr.sprintf("0 : output low ");	
	ComboBox_LedLevel->Items->Add(dstr);
	dstr.sprintf("1 : output high ");	
	ComboBox_LedLevel->Items->Add(dstr);
	dstr.sprintf("2 : output Hi-Z or input  ");	
	ComboBox_LedLevel->Items->Add(dstr);

	ComboBox_LedNo->ItemIndex = 0;
	ComboBox_LedLevel->ItemIndex = 0;
	
	return ;
}



int TForm_Main::API_bt_LoadMpDll()
{
	// load dll
	pBaseDLLObject = &mBaseDLLObject;
#ifdef ACTS_BUMBLEBEE
	if (BuildBTMPDLLObject(pBaseDLLObject,NULL,1)!=0)
		return -1;
#else
	if (BuildBTMPDLLObject(pBaseDLLObject,NULL,0)!=0)
		return -1;
#endif
	return 0;
}



void TForm_Main::API_bt_releaseMpDll()
{
       if (!FormBTDebug_flag)
	ReleaseBTPMPDLLObject(pBaseDLLObject);

	return;
}



int TForm_Main::API_bt_inface(int interface_type,int PortNo,int Baudrate, unsigned char *pData)
{
	int rtn=0;


        if ((FormBTDebug_flag) &&
                (bt_debug_Open != NULL )
	        &&(bt_debug_Send !=NULL)
	        &&(bt_debug_Recv !=NULL)
	        &&(bt_debug_Close!=NULL)
	        &&(bt_debug_WaitMs!=NULL))
        {
            	rtn=pBaseDLLObject->BTMPAPI_BuildInterfaceVendor(
			&pBaseInterface,
			&BaseInterfaceModuleMemory,
	                //Parmater
	                0,
	                1,
	                115200,
	                NULL,
	                //basic fuction
	                bt_debug_Open,
	                bt_debug_Send,
	                bt_debug_Recv,
	                bt_debug_Close,
	                bt_debug_WaitMs
 
                );
        }
        else
        {
	rtn=pBaseDLLObject->BTMPAPI_BuildInterfaceRTK(
			&pBaseInterface,
			&BaseInterfaceModuleMemory,
			interface_type,
			PortNo,
			(unsigned long)Baudrate,
			pData
			);
        }
	if (rtn != 0)
		goto exit;

	if (pBaseInterface == NULL)
	{
 		rtn = -1;
		goto exit;
	}
	pBluetoothModule=&BluetoothModuleMemory;
	pBluetoothModule->BuildStatus=0;
	if (pBaseDLLObject->BTMPAPI_BuildBluetoothModule(
			&BluetoothModuleMemory,
			pBaseInterface,
			NULL,
			TxGainTable[3],
			TxDACTable[3]) !=0
			)
	{
		rtn = -1;
		goto exit;
	}


	if (pBluetoothModule->BuildStatus ==0)
		rtn = -1;
	
exit:           
	return rtn;
}



void __fastcall TForm_Main::FormClose(TObject *Sender,
      TCloseAction &Action)
{ 

	Btn_Dev_CloseClick(Sender);

	API_bt_releaseMpDll();

	return;
}
//---------------------------------------------------------------------------
int TForm_Main::API_ReadCurrentTxDacValue(unsigned char  *TxDacValue)
{
	String dstr,msg;
	unsigned long  TxDac=0;
	msg.sprintf(">>To updat current tx dac GUI Value...\n");
	if (pBluetoothModule->GetMdRegMaskBits(pBluetoothModule,0x38,7,3,&TxDac) !=0)
	{
		msg.sprintf(">>Read tx dac current value error..!!\n");
		//    ShowMessage(msg);
		return -1;
	}
	dstr.sprintf("0x%x",TxDac);
	Cbx_TxDacIndex->Text = dstr;
	ComboBox_Hopping_TxDac->Text=dstr;
	msg.sprintf(">>Read Tx dac current value = 0x%x!!\n",TxDac);
	Memo_msg->Lines->Add(msg);
	*TxDacValue = TxDac;
	return 0;

}

#define MAX_DESC_SIZE 50
typedef struct BT_DEF_TX_POWER_INDEX_STRUCT{
	char Desc[MAX_DESC_SIZE];
	int  Index_USB_PCIE;
	int  Index_UART;
}BT_DEF_TX_POWER_INDEX_STRUCT,*pBT_DEF_TX_POWER_INDEX_STRUCT;

void TForm_Main::API_bt_GetBTDefaultTxPower(unsigned int ChipType,int *Power_Inde)
{
	int Index = 0xFF;

	BT_DEF_TX_POWER_INDEX_STRUCT BT_DEF_TX_POWER_INDEX [NumOfRTKCHID]=
	{
		//Name                  USB/PCIE  ,UART
		{"RTK_BT_CHIP_ID_RTL8723A",6,6},
		{"RTK_BT_CHIP_ID_RTL8723B",6,4},
		{"RTK_BT_CHIP_ID_RTL8821A",7,7},
		{"RTK_BT_CHIP_ID_RTL8761A",6,6},
		{"RTK_BT_CHIP_ID_RTL8703A",6,6},
		{"RTK_BT_CHIP_ID_RTL8763A",6,6},
		{"RTK_BT_CHIP_ID_RTL8703B",6,6},
		{"RTK_BT_CHIP_ID_RTL8723C",6,6},
		{"RTK_BT_CHIP_ID_RTL8822B",6,6},
		{"RTK_BT_CHIP_ID_RTL8723D",6,6},
	};
   /////
    FILE *pf=NULL;

    pf = fopen("BTPowerIndex.ini", "r+");
    if (pf != NULL)
    {
        char sline[256],tmp1[256],tmp2[256],tmp3[256];
        String stmp1,stmp2,stmp3,stmp0;
        int n=0;

        while(1)
        {
          ZeroMemory(sline, sizeof(sline));
          ZeroMemory(tmp1, sizeof(tmp1));
          ZeroMemory(tmp2, sizeof(tmp2));
          ZeroMemory(tmp3, sizeof(tmp3));
           if(feof(pf))
                break;

          fgets(sline, 256, pf);
          if ( (sline[0] != '/') && (sline[1] != '/') && (sline[0] != NULL) && (sline[0] != '\n') )
          {

              sscanf(sline, "%s %s %s", tmp1, tmp2 ,tmp3);
              //Desc
              stmp1.sprintf("%s", tmp1);
              stmp1=stmp1.LowerCase();
              //usb/pcie
              if ((tmp2[0] == '/') &&  (tmp2[1] == '/'))
              stmp2.sprintf("6");
              else
              stmp2.sprintf("%s", tmp2);
              //uart
              if ((tmp3[0] == '/') &&  (tmp3[1] == '/'))
              stmp3.sprintf("6");
              else
              stmp3.sprintf("%s", tmp3);

              for (n=0;n<NumOfRTKCHID;n++)
              {
                 stmp0.sprintf("%s",BT_DEF_TX_POWER_INDEX[n].Desc);
                 stmp0=stmp0.LowerCase();
                 if (stmp0 == stmp1)
                 {
                    BT_DEF_TX_POWER_INDEX[n].Index_USB_PCIE = stmp2.ToInt();
                    BT_DEF_TX_POWER_INDEX[n].Index_UART=stmp3.ToInt();
                    break;
                 }
              }//end for (n=0;n<NumOfRTKCHID;n++)

          }//end  if ( (sline[0] != '/') && (sline[1] != '/') && (sline[0] != NULL) && (sline[0] != '\n') )
        }
       fclose(pf);
    }

    if (ChipType == RTK_BT_CHIP_ID_UNKNOWCHIP)
    {
        return ;
    }

    if (InterfaceType ==  TYPE_UART)
        Index = BT_DEF_TX_POWER_INDEX[ChipType].Index_UART;
    else
        Index = BT_DEF_TX_POWER_INDEX[ChipType].Index_USB_PCIE;

     if ((Index < 7) &&  (Power_Inde != NULL ))
     {
        *Power_Inde =  Index;
     }


     return ;

}


int TForm_Main::OpenDevice()
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	int  PortNo;
	int  Baudrate=115200;
	unsigned int ChipType=0xFF;
	int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
	int i;
	int rtn=-1;

	int Power_Index=0xFF;
	String dstr;
	unsigned char pData[MAX_DATA_LEN]; 

	if(Cbx_Interface->Text == "Adb for BT UART")//"Adb for BT UART"
	{
		AnsiString Str = Cbx_Interface_port->Text;
		memset(pData, 0, MAX_DATA_LEN);
		strcpy(pData, Str.c_str());	
	}
	else 
	{
		PortNo=StrToInt(Cbx_Interface_port->Text);
		
		AnsiString Str = Edit_Ip_Addr->Text;
		memset(pData, 0, MAX_DATA_LEN);
		strcpy(pData, Str.c_str());
	}

	Btn_Dev_Open->Enabled=false;
        	
	GroupBox_Show->Visible=true;
	Panel_LED->Color=clRed;
	Panel_LED->Caption="X";
	if (ShowUI != NULL)
	{
             ShowUI->Terminate();
             ShowUI =NULL;
	}
	ShowUI =  new SowObject(true);
	ShowUI->SetMode(0);
	switch (InterfaceType)
	{
			case 0:  ShowUI->SetTimeOutTime(1000,100);   break;
			case 1:  ShowUI->SetTimeOutTime(2500,250);     break;
			case 2:  ShowUI->SetTimeOutTime(1000,100);   break;
			case 3:  ShowUI->SetTimeOutTime(4000,400);    break;
			case 4:  ShowUI->SetTimeOutTime(4000,400);   break;
			default:
			ShowUI->SetTimeOutTime(3000,300);
	}
	// ShowUI->SetPara(5);
	ShowUI->Priority = tpNormal;
	ShowUI->Resume();

	Baudrate=BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
	if (API_bt_inface(InterfaceType,PortNo,Baudrate,pData) !=0)
	{
		Memo_msg->Lines->Add(">>Build interface Fail...");
		goto exit;
	}
	
	if(pBaseInterface->Open(pBaseInterface)!=0)
	{
		Memo_msg->Lines->Add("Open device Fail...");
		goto exit;
	}

	Memo_msg->Lines->Add(">>Open device Success...");

	if (Cb_downloadpatch->Checked && (Cb_downloadpatch->Visible==true) )
	{//download patch code

		if (API_bt_Download_PatchCode(1,NULL) !=0)
		{
			Memo_msg->Lines->Add(">>Download MP patch code  Fail...");
		}
		else
		{
			Memo_msg->Lines->Add(">>Download patch code  Success...");
		}
	}
	Sleep(100);
	if (API_bt_GetChipInfo(&ChipType) !=0)
	{
		Memo_msg->Lines->Add(">>Get Chip info error!!");
	}
	else
	{
		API_bt_GetBTDefaultTxPower(ChipType,&Power_Index);
		if (Power_Index < 7)
		{
			dstr.sprintf("%d", Power_Index);
			Cbx_TxGainIndex->Text = dstr;
			Cbx_TxGainIndex->Update();
			//if (!EnableControlBTTxPowerIndex1->Checked)
				//Cbx_TxGainIndex->Enabled=false;
			dstr.sprintf(">>BT Default Power Index = %d ",Power_Index);
			Memo_msg->Lines->Add(dstr);
		}
	}

	Panel_LED->Color=clLime;
	Panel_LED->Caption="O";

	pParam->ParameterIndex= SET_DEFAULT_TX_GAIN_TABLE;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	pBluetoothModule->ActionControlExcute(pBluetoothModule);

	pBluetoothModule->ActionReport(pBluetoothModule,REPORT_TX_GAIN_TABLE, &mBT_DEVICE_REPORT);

	ComboBox_LeTest_TxGainIndex->Text = "6";

        //to updat current tx dac GUI Value
        {
                unsigned char  TxDacValue=0;
                API_ReadCurrentTxDacValue( &TxDacValue);
        }
        rtn=0;
 exit:
	GroupBox_Show->Visible=false;
 	Btn_Dev_Close->Enabled=true;

	delete ShowUI;
	ShowUI =NULL;

	return rtn;
}



void __fastcall TForm_Main::Btn_Dev_OpenClick(TObject *Sender)
{
	unsigned char TxDacValue;	
	int  PortNo;
	int  Baudrate=115200;
	int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;
	int i;	
	String dstr;

	unsigned char pData[MAX_DATA_LEN];

	
	if(Cbx_Interface->Text == "Adb for BT UART")//"Adb for BT UART"
	{
		AnsiString Str = Cbx_Interface_port->Text;
		memset(pData, 0, MAX_DATA_LEN);
		strcpy(pData, Str.c_str());	
	}
	else 
	{
		PortNo=StrToInt(Cbx_Interface_port->Text);
		
		AnsiString Str = Edit_Ip_Addr->Text;
		memset(pData, 0, MAX_DATA_LEN);
		strcpy(pData, Str.c_str());
	}

	Cbx_TxGainIndex->Text  = "6";
	Btn_Dev_Open->Enabled=false;
        	
	GroupBox_Show->Visible=true;
	Panel_LED->Color=clRed;
	Panel_LED->Caption="X";
	if (ShowUI != NULL)
	{
		ShowUI->Terminate();
		ShowUI =NULL;
	}
	ShowUI =  new SowObject(true);
	ShowUI->SetMode(0);
	switch (InterfaceType)
	{
		case 0:  ShowUI->SetTimeOutTime(1000,100);   break;
		case 1:  ShowUI->SetTimeOutTime(2500,250);     break;
		case 2:  ShowUI->SetTimeOutTime(1000,100);   break;
		case 3:  ShowUI->SetTimeOutTime(4000,400);    break;
		case 4:  ShowUI->SetTimeOutTime(4000,400);   break;
		default:
			ShowUI->SetTimeOutTime(3000,300);
	}
	// ShowUI->SetPara(5);
	ShowUI->Priority = tpNormal;
	ShowUI->Resume();

	Baudrate=BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
	if (API_bt_inface(InterfaceType,PortNo,Baudrate,pData) !=0)
	{
		Memo_msg->Lines->Add(">>Build interface Fail...");
		goto exit;
	}

	if(pBaseInterface->Open(pBaseInterface)!=0)
	{
		Memo_msg->Lines->Add(">>Open device Fail...");
		goto exit;
	}
	
	Memo_msg->Lines->Add(">>Open device Success...");

	if (Cb_downloadpatch->Checked)
	{//download patch code

		if (API_bt_Download_PatchCode(1,NULL) !=0)
		{
			Memo_msg->Lines->Add(">>Download patch code  Fail...");
		}
		else
		{
			Memo_msg->Lines->Add(">>Download patch code  Success...");
		}
	}

	API_bt_GetChipInfo(NULL);

	API_bt_ShowTxDefaultPower();

	if(mBT_CHIPINFO.ChipType < RTK_BT_CHIP_ID_RTL8822B)
	{
		CheckBox_Fw_TxRx_Mode->Checked = false;		
		CheckBox_Fw_TxRx_Mode->Enabled = true;			
		bFwTxRxMode = 0;
	}
	else
	{
		CheckBox_Fw_TxRx_Mode->Checked = true;
		CheckBox_Fw_TxRx_Mode->Enabled = false;
		bFwTxRxMode = 0;
	}

	Panel_LED->Color=clLime;
	Panel_LED->Caption="O";

	//Read Dac	
	API_ReadCurrentTxDacValue( &TxDacValue);

	BitBtn_GetChipInfoClick(Sender); 
	ComboBox_LeTest_ActionChange(Sender);	

	if(pModuleBtReport->pBTInfo->ChipType==RTK_BT_CHIP_ID_RTL8763B)
	{
		ComboBox_LeTest_DataLen->Items->Clear();

		for (i=0; i<=0xFF; i++)
		{
			dstr.sprintf("0x%x",i);
			ComboBox_LeTest_DataLen->Items->Add(dstr);
		}

		ComboBox_LeTest_DataLen->ItemIndex = 0xFF;	
	}
	else
	{

		ComboBox_LeTest_DataLen->Items->Clear();

		for (i=0; i<=0x25; i++)
		{
			dstr.sprintf("0x%x",i);
			ComboBox_LeTest_DataLen->Items->Add(dstr);
		}

		ComboBox_LeTest_DataLen->ItemIndex = 0x25;
	}

 	if(mBT_CHIPINFO.ChipType==RTK_BT_CHIP_ID_RTL8763B)
	{
		//BBpro
		TabSheet_Cal->TabVisible = true;
		//xtal
		Cbx_RTL8761_XTAL->Items->Clear();
		for (i=0; i<128; i++)
		{
			dstr.sprintf("0x%.2x",i);
			Cbx_RTL8761_XTAL->Items->Add(dstr);
		}
		Cbx_RTL8761_XTAL->ItemIndex=0x3f;

		
		TabSheet_DAC->TabVisible = false;
		
		TabSheet_RW->TabVisible = false;
		TabSheet_Hopping->TabVisible = true;
		TabSheet_SendHciCmd->TabVisible = false;
              LBT_TabSheet->TabVisible = true;
		BitBtn15->Visible = false;
		BitBtn_GetChipInfo->Visible = false;
		Button_GetBTStage->Visible = false;
		Edit_BT_Stage->Visible = false;
		Btn_LoadScript->Visible = false;
		BitBtn_TRXReadThermal->Visible = false;
		Button_ReadBDAddr->Visible = false;
		BitBtn_ShowTxPower->Visible = false;
		Button_GetPowerTracking->Visible = false;
		Button_SetPowerTracking->Visible = false;
		RadioGroup_PowerTracking->Visible = false;
		ComboBox_LeTest_TxGainIndex->Enabled = true;
		CheckBox_EnableTxDac->Visible = false;
		StaticText8->Visible = false;
		Cbx_TxDacIndex->Visible = false;
		BitBtn1->Visible = false;
		Button_BBPro_WriteToFlashConfig->Visible = true;

		StaticText11->Visible = true;
		ComboBox_LEE_ContTx_PHY->Visible = true;
		StaticText12->Visible = true;
		ComboBox_LEE_PHY->Visible = true;
		StaticText14->Visible = true;
		ComboBox_LEE_Modulation->Visible = true;
		TabSheet_BBProFlash->Visible = true;

		LBT_TabSheet->TabVisible = true;

	}
	else
	{
		//the others 
		if(mBT_CHIPINFO.ChipType==RTK_BT_CHIP_ID_RTL8761A)
		{
			TabSheet_Cal->TabVisible = true;
			//xtal
			Cbx_RTL8761_XTAL->Items->Clear();
			for (i=0; i<64; i++)
			{
				dstr.sprintf("0x%.2x",i);
				Cbx_RTL8761_XTAL->Items->Add(dstr);
			}
			Cbx_RTL8761_XTAL->ItemIndex=0x20;
		}

		if(mBT_CHIPINFO.ChipType < RTK_BT_CHIP_ID_RTL8822B)
		{
			TabSheet_DAC->TabVisible = true;
		}
		
		TabSheet_RW->TabVisible = true;
		TabSheet_Hopping->TabVisible = true;
		TabSheet_LED->TabVisible= false;
		TabSheet_SendHciCmd->TabVisible = false;		
	        LBT_TabSheet->TabVisible = false;
		BitBtn15->Visible = true;
		BitBtn_GetChipInfo->Visible = true;
		Button_GetBTStage->Visible = true;
		Edit_BT_Stage->Visible = true;
		Btn_LoadScript->Visible = true;
		BitBtn_TRXReadThermal->Visible = true;
		Button_ReadBDAddr->Visible = true;
		BitBtn_ShowTxPower->Visible = true;
		Button_GetPowerTracking->Visible = true;
		Button_SetPowerTracking->Visible = true;
		RadioGroup_PowerTracking->Visible = true;
		ComboBox_LeTest_TxGainIndex->Enabled = true;
		CheckBox_EnableTxDac->Visible = true;
		StaticText8->Visible = true;
		Cbx_TxDacIndex->Visible = true;
		BitBtn1->Visible = true;

		StaticText11->Visible = false;
		ComboBox_LEE_ContTx_PHY->Visible = false;
		StaticText12->Visible = false;
		ComboBox_LEE_PHY->Visible = false;
		StaticText14->Visible = false;
		ComboBox_LEE_Modulation->Visible = false;
		Button_BBPro_WriteToFlashConfig->Visible = false;
		TabSheet_BBProFlash->Visible = false;

	}

        Button_Get_TPM_IQMClick(Sender);     

 exit:

	GroupBox_Show->Visible=false;

 	Btn_Dev_Close->Enabled=true;

	delete ShowUI;
	ShowUI =NULL;

	api_tcpip_bt_mp_InitDefaultParameter();

	return ;

}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Cbx_InterfaceChange(TObject *Sender)
{
	int i;
	String dstr;
	int Index = Cbx_Interface->ItemIndex;

	Cbx_RTL8761_XTAL->Visible=true;
	Edit_CFO->Text = "0x20";

	switch(Index)
	{
		case TYPE_USB: //usb
			Cbx_Interface_port->Items->Clear();
			for (i=0; i<10; i++)
			{
				dstr.sprintf("%d",i);
				Cbx_Interface_port->Items->Add(dstr);
			}
			
			Cbx_Interface_port->Visible=false;
			Label19->Visible=false;
			Cbx_Interface_port->ItemIndex=1;
			Cbx_Interface_baudrate->Visible=false;
			Edit_Ip_Addr->Visible=false;

			InterfaceType =  TYPE_USB ;
		break;

		case TYPE_UART: //COM uart
			Cbx_Interface_port->Items->Clear();
			for (i=0; i<10; i++)
			{
				dstr.sprintf("%d",i);
				Cbx_Interface_port->Items->Add(dstr);
			}
			Label19->Visible=true;		
			Cbx_Interface_port->Visible=true;
			Cbx_Interface_port->ItemIndex=4;			
			Cbx_Interface_baudrate->Visible=true;
			Edit_Ip_Addr->Visible=false;

			InterfaceType =  TYPE_UART ;
		break;

		case TYPE_FILTER_UART: //Filter UART
			Cbx_Interface_port->Visible=false;
			Label19->Visible=false;
			Cbx_Interface_baudrate->Visible=false;
			Edit_Ip_Addr->Visible=false;

			InterfaceType =  TYPE_FILTER_UART ;
		break;

		case TYPE_ADB_UART: //ADB  UART
			Cbx_Interface_port->Items->Clear();
			for (i=0; i<5; i++)
			{
				dstr.sprintf("/dev/ttyS%d",i);
				Cbx_Interface_port->Items->Add(dstr);
			}
			
			Cbx_Interface_port->Visible=true;
			Label19->Visible=true;			
			Cbx_Interface_port->ItemIndex=1;
			Cbx_Interface_baudrate->Visible=false;
			Edit_Ip_Addr->Visible=false;

			InterfaceType =  TYPE_ADB_UART ;
		break;

		case TYPE_ADB_USB: //ADB  USB
			Cbx_Interface_port->Visible=false;
			Label19->Visible=false;
			Cbx_Interface_baudrate->Visible=false;
			Edit_Ip_Addr->Visible=false;

			InterfaceType =  TYPE_ADB_USB ;
		break;

  		case TYPE_SOCKET_DEVICE_UART:
			Cbx_Interface_port->Items->Clear();
			for (i=0; i<10; i++)
			{
				dstr.sprintf("%d",i);
				Cbx_Interface_port->Items->Add(dstr);
			}
			
			Cbx_Interface_port->Visible=true;
			Cbx_Interface_port->ItemIndex=1;
			Label19->Visible=true;
			Cbx_Interface_baudrate->Visible=false;
			Edit_Ip_Addr->Visible=true;

			InterfaceType =  TYPE_SOCKET_DEVICE_UART ;
		break;
		
		case TYPE_SOCKET_DEVICE_USB:
			Cbx_Interface_port->Visible=false;
			Label19->Visible=false;	
			Cbx_Interface_baudrate->Visible=false;
			Edit_Ip_Addr->Visible=true;
			InterfaceType =  TYPE_SOCKET_DEVICE_USB ;
		break;


	}

	return ;
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::Btn_HoppingRunClick(TObject *Sender)
{

	BT_PARAMETER 	*pParam=&mBT_PARAMETER;
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;	

	unsigned char  PayloadType = ComboBox_Hopping_PayloadType->ItemIndex;
	unsigned char  TxGainValue =  StrToInt(Edit_Hopping_TxGainValue->Text);
	unsigned char  TxGainIndex = ComboBox_Hopping_TxGainIndex->ItemIndex;
	unsigned char  TxDac = StrToInt(ComboBox_Hopping_TxDac->Text);
	
	pParam->mPacketType =(BT_PKT_TYPE)( Cbx_Hopping_PktType->ItemIndex);
	String dstr;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return ;
	}

	if( (pModuleBtReport->pBTInfo->ChipType==RTK_BT_CHIP_ID_RTL8763B) && (isTPM ==1))
	{
		if(pParam->mPacketType == 3)
			pParam->mPacketType = BT_PKT_LE; //only 1M and LE
	}

        Btn_HoppingRun->Enabled = false;

	if (Ckb_Whitening->Checked)
	{
		pParam->mWhiteningCoeffValue=0x7f;
	}
	else
	{
		pParam->mWhiteningCoeffValue=0x80;
	}
	
	if (ComboBox_Hopping_Type->Text== "Hopping")
	{
		pParam->bHoppingFixChannel= 0;
		pParam->mParamData[0] = StrToInt(ComboBox_Hopping_StartCh->Text);
		pParam->mParamData[1] = StrToInt(ComboBox_Hopping_StopCh->Text);
	}
	else
	{
		pParam->bHoppingFixChannel= 1;
		pParam->mChannelNumber=StrToInt(ComboBox_Hopping_StartCh->Text);
	}

	pParam->mPayloadType = PayloadType;
	pParam->mTxGainIndex = TxGainIndex;
	pParam->mTxGainValue = TxGainValue;
	pParam->mTxDAC = TxDac;

	//update
	pParam->ParameterIndex = HOPPING_DWELL_TIME;
	//  int siz = sizeof(BT_PARAMETER);
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	//dwell time command

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Run hopping mode failed");
                Btn_HoppingRun->Enabled = true;
	}
	else
	{
		Memo_msg->Lines->Add("Run hopping mode");
                Btn_Hopping_Stop->Enabled = true;
	}

	return ;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Btn_Hopping_StopClick(TObject *Sender)
{
	//dwell time command
	BT_PARAMETER 	*pParam=&mBT_PARAMETER;
	String dstr;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}
        
        Btn_Hopping_Stop->Enabled = false;
                
	pParam->ParameterIndex = HCI_RESET;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Stop hopping mode failed...");
                Btn_Hopping_Stop->Enabled = true;
	}
        else
        {
        	Memo_msg->Lines->Add("Stop hopping mode");
                Btn_HoppingRun->Enabled = true;
        }
}
//---------------------------------------------------------------------------

int TForm_Main::API_bt_HciReset()
{
	BT_PARAMETER 	*pParam=&mBT_PARAMETER;
	String dstr;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}
	pParam->ParameterIndex = HCI_RESET;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		dstr.sprintf(">>HCI Reset Fail...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}
        dstr.sprintf(">>HCI Reset Succress...!!\n");Memo_msg->Lines->Add(dstr);
	TrxFixObject(true);
	return 0;

}
//---------------------------------------------------------------------------
int TForm_Main::API_bt_GetChipInfo(unsigned int *ChipType)
{
	String dstr;
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;
	BT_CHIPINFO	        *pBTInfo=NULL;
        if (ChipType !=NULL)
                *ChipType = 0xFF;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}

	if (pBluetoothModule->ActionReport(pBluetoothModule,REPORT_CHIP,pModuleBtReport) !=0)
	{
		dstr.sprintf(">>Get Chip Info is Fail...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}
	pBTInfo=  pModuleBtReport->pBTInfo;
    if (pBTInfo == NULL)
    {
		dstr.sprintf(">>Get Chip Info is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
          goto exit;
	}
	memcpy(&mBT_CHIPINFO,pBTInfo,sizeof(BT_CHIPINFO));   Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>ChipType=(%x)\n",pBTInfo->ChipType); Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>HCI_SubVersion=0x%x\n",pBTInfo->HCI_SubVersion); Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>HCI_Version=0x%x\n",pBTInfo->HCI_Version); Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>LMP_SubVersion=0x%x\n",pBTInfo->LMP_SubVersion); Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>LMP_Version=0x%x\n",pBTInfo->LMP_Version); Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>Version=%.2x\n",pBTInfo->Version+9); Memo_msg->Lines->Add(dstr);
	dstr.sprintf(">>Is_After_PatchCode=%d\n",pBTInfo->Is_After_PatchCode);Memo_msg->Lines->Add(dstr);
        if (ChipType !=NULL)
        *ChipType=pBTInfo->ChipType;
exit:
	return 0;

}


int TForm_Main::API_bt_fw_read_power_info()
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	String dstr;
	int i;
	
	pParam->ParameterIndex = FW_READ_TX_POWER_INFO;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionControlExcute(pBluetoothModule) != BT_FUNCTION_SUCCESS)
		goto error;

	pBluetoothModule->ActionReport(pBluetoothModule,REPORT_TX_POWER_INFO, &mBT_DEVICE_REPORT);
		
	memcpy(TxPowerLevelInfo, mBT_DEVICE_REPORT.ReportData, LEN_5_BYTE);

	dstr.sprintf(">>BT Max Tx Power Index:%d,  Default Power Index:(1M %d),(2M %d),(3M %d),(LE %d)",TxPowerLevelInfo[0], TxPowerLevelInfo[1], TxPowerLevelInfo[2], TxPowerLevelInfo[3], TxPowerLevelInfo[4]);
	Memo_msg->Lines->Add(dstr);

	Cbx_TxGainIndex->Items->Clear();

	if(pBTInfo->ChipType == RTK_BT_CHIP_ID_RTL8763B)
	{
		for ( i=0; i<=TxPowerLevelInfo[MAX_TX_POWER_INDEX]; i++)
		{
			dstr.sprintf("%d", i);
			Cbx_TxGainIndex->Items->Add(dstr);
		}
	}
	else
	{
		for ( i=0; i<=TxPowerLevelInfo[MAX_TX_POWER_INDEX]; i++)
		{
			dstr.sprintf("%d", i);
			Cbx_TxGainIndex->Items->Add(dstr);
		}
	}
	
	dstr.sprintf("%d", TxPowerLevelInfo[DEFAULT_1M_TX_POWER_INDEX]);
	Cbx_TxGainIndex->Text = dstr;

	return 0;

error:

	Memo_msg->Lines->Add(">>FW Read Power Info : ERROR");

	return 1;

}


int TForm_Main::API_bt_get_power_index()
{
    //	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;
	int Power_Index=0xff;
	String dstr;
	int i;

	API_bt_GetBTDefaultTxPower(pBTInfo->ChipType, &Power_Index);
	if (Power_Index < 7)
	{
		ComboBox_LeTest_TxGainIndex->Items->Clear();
		for ( i=0; i<LEN_7_BYTE; i++)
		{
			dstr.sprintf("%d", i+1);
			ComboBox_LeTest_TxGainIndex->Items->Add(dstr);
		}

		Cbx_TxGainIndex->Items->Clear();
		for ( i=0; i<LEN_7_BYTE; i++)
		{
			dstr.sprintf("%d", i+1);
			Cbx_TxGainIndex->Items->Add(dstr);
		}

		dstr.sprintf("%d", Power_Index);
		Cbx_TxGainIndex->Text = dstr;
		ComboBox_LeTest_TxGainIndex->Text  = dstr;
		Cbx_TxGainIndex->Update();
			
		dstr.sprintf(">>BT Default Power Index = %d ",Power_Index);
		Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf(">>ERROR : BT Default Power Index = %d ",Power_Index);
		Memo_msg->Lines->Add(dstr);
	}

        return 0;

}


int TForm_Main::API_bt_ShowTxDefaultPower()
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	String dstr;
	int i;

	unsigned char pData[512];
	unsigned char pEvtBuf[512];	

	dstr.sprintf(">>API_bt_ShowTxDefaultPower  ChipId= %d ",pBTInfo->ChipType);
	Memo_msg->Lines->Add(dstr);

	if(pBTInfo->ChipType < RTK_BT_CHIP_ID_RTL8822B)
	{
		API_bt_get_power_index();		
		pParam->ParameterIndex = SET_DEFAULT_TX_GAIN_TABLE;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		pBluetoothModule->ActionControlExcute(pBluetoothModule);
		pBluetoothModule->ActionReport(pBluetoothModule,REPORT_TX_GAIN_TABLE, &mBT_DEVICE_REPORT);

	}
	else if(pBTInfo->ChipType >= RTK_BT_CHIP_ID_RTL8822B)
	{
		API_bt_fw_read_power_info();

		ComboBox_LeTest_TxGainIndex->Items->Clear();
		for ( i=0; i<=TxPowerLevelInfo[MAX_TX_POWER_INDEX]; i++)
		{
			dstr.sprintf("%d", i);
			ComboBox_LeTest_TxGainIndex->Items->Add(dstr);
		}

		dstr.sprintf("%d", TxPowerLevelInfo[DEFAULT_LE_TX_POWER_INDEX]);
		ComboBox_LeTest_TxGainIndex->Text = dstr;		
	}
        return 0;
}


#define MAX_SET_CONFIG_FILE_SIZE  58


int TForm_Main::API_bt_Download_PatchCode(int Defaultpath_Flag,char *new_Filepath)
{
        int patch_type=0;
	char tmp_FileName[][50]={
		{"BTPatchCode\\patch_rtl8723a.bin"}, // 0
		{"BTPatchCode\\patch_rtl8723b.bin"}, // 1
		{"BTPatchCode\\patch_rtl8821a.bin"}, // 2
		{"BTPatchCode\\patch_rtl8761a.bin"}, // 3
		{"BTPatchCode\\patch_rtl8703a.bin"}, // 4
		{"BTPatchCode\\patch_rtl8763a.bin"}, // 5
		{"BTPatchCode\\patch_rtl8703b.bin"}, // 6
		{"BTPatchCode\\patch_rtl8723c.bin"}, // 7
		{"BTPatchCode\\patch_rtl8822b.bin"}, // 8
		{"BTPatchCode\\patch_rtl8723d.bin"}, // 9
		{"BTPatchCode\\patch_rtl8821c.bin"}, // 10
	};
	char app_FileName[][50]={
		{"BTPatchCode\\app_8761att.bin"}, // 0
        };
	BT_CHIPINFO	        *pBTInfo=&mBT_CHIPINFO;
        BT_PARAMETER            *pParam=&mBT_PARAMETER;
	char *buffer =NULL;
        AnsiString file_path;
	int lSize=0;
	int rtn=0;
        int n=0;
        int config_len=0;
	String dstr;
	FILE *DataFile=NULL;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}
//	if (Defaultpath_Flag)
	{
		if (API_bt_GetChipInfo(NULL) !=0 )
		{
			Memo_msg->Lines->Add(">>Get Chip info error!!");
			rtn=-1;
			goto exit;
		}
	}

	if((pBTInfo->Is_After_PatchCode) &&  (InterfaceType !=  TYPE_BUMBLE_BEE_USB ))  //bumble must to download
	{
		Memo_msg->Lines->Add(">>Skip patch code !!");
		rtn=0;
		goto exit;

	}
	////////////////////////////////////////////////////////////////////////////////////
	//config File
	//API_bt_Download_PatchCode
	if (Cb_ConfigFile->Checked)
	{
		char *pConbuffer =NULL;
		int ConfigSize=0;
		FILE *ConfigFile=NULL;
		int  ConfigFileMaxIndex =0;
		ConfigFile = fopen("mp_config.bin", "r+b");
		if (ConfigFile == NULL)
		{
			dstr.sprintf(">>Error config File path = mp_config.bin..\n");
			Memo_msg->Lines->Add(dstr);
		}
		else
		{
			fseek(ConfigFile, 0, SEEK_END);
			ConfigSize = ftell(ConfigFile);
			fseek(ConfigFile, 0, SEEK_SET);
			if (ConfigSize > 256 )
			{
				dstr.sprintf(">>[ERROR]Config file size > 256 \n");
				Memo_msg->Lines->Add(dstr);
				goto exit;
			}
			pConbuffer = (char *)malloc(ConfigSize);
			if (pConbuffer ==NULL)
			{
				dstr.sprintf(">>Faild to malloc the config file buffer..\n");
				Memo_msg->Lines->Add(dstr);
			}
			else
			{
				if (fread(pConbuffer,1,ConfigSize,ConfigFile) == 0)
				{
					dstr.sprintf(">>read config file error = mp_config.bin..\n");
					Memo_msg->Lines->Add(dstr);
				}
				else
				{
					int cur_len=0;
					int pcur=0;
                                        if (ConfigSize>=6)
                                        {
                                                config_len =  (pConbuffer[5]<<8)+pConbuffer[4];
                                                if (config_len != (ConfigSize-6))
                                                {
                                                 
                                                  dstr.sprintf(">>Config Len= %d ConfigSize=%d no match -->ConfigSize = %d(Config Len +6)",config_len,ConfigSize);
                                                  ConfigSize = (config_len+6);
                                                }
                                                else
                                                {
                                                   dstr.sprintf(">>Config Len= %d ConfigSize=%d ",config_len,ConfigSize);
                                                }
                                        }
					//64 -6
					ConfigFileMaxIndex = (ConfigSize / MAX_SET_CONFIG_FILE_SIZE) +1;    //config packet
					dstr.sprintf(">>SetConfig file:: begin --> total_index = %d total_len=%d\n",ConfigFileMaxIndex,ConfigSize);
					Memo_msg->Lines->Add(dstr);
					//new Config File process   0xa5,0xb5,total_index, total_len ,current_index,current_len
					for (n=0;n<ConfigFileMaxIndex;n++)
					{
						if (ConfigSize <= MAX_SET_CONFIG_FILE_SIZE)
						{
							cur_len = ConfigSize;
						}
						else if ( (ConfigSize - pcur) < MAX_SET_CONFIG_FILE_SIZE )
						{
							cur_len = MAX_SET_CONFIG_FILE_SIZE;
						}
						else
						{
							cur_len = ConfigSize - pcur;
						}

						pParam->mParamData[0] = 0xa5;
						pParam->mParamData[1] = 0xb5;
						pParam->mParamData[2] = ConfigFileMaxIndex;
						pParam->mParamData[3] = ConfigSize;
						pParam->mParamData[4] = n;
						pParam->mParamData[5] = cur_len;
						memcpy(&pParam->mParamData[6],&pConbuffer[pcur], cur_len );

						pcur += cur_len;
						pParam->ParameterIndex = SET_CONFIG_FILE_DATA;
						pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
						if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
						{
							Memo_msg->Lines->Add(">>Set config File Error...");
							goto Config_fail;
						}
						else
						{
							dstr.sprintf(">>SetConfig::current_index = %d ,current_len = %d \n",n,cur_len);
							Memo_msg->Lines->Add(dstr);
						}

					}
				}
			}
		}

Config_fail:

		if (pConbuffer != NULL)
			free(pConbuffer);
		if (ConfigFile !=NULL)
			fclose(ConfigFile);
		dstr.sprintf(">>SetConfig file:: End --> FileName:mp_config.bin\n");
		Memo_msg->Lines->Add(dstr);

	}

	//////////////////////////////////////////////////////////////
        patch_type =0;
	if (Defaultpath_Flag)
	{
                if( (pBTInfo->ChipType == RTK_BT_CHIP_ID_RTL8761A) && ((pBTInfo->Version+9) == 0x0e))
                { //8761att app patch

                        int  message_btn=Application->MessageBox("Download MP Patch Code..\nYes :MP        Patch Code \nNo :Normal Patch Code", "Patch Code select",32+ MB_YESNOCANCEL);
                        if (message_btn == IDNO)
                        {
                                patch_type =1;
                        }else if (message_btn == IDCANCEL)
                        {

  	                	Memo_msg->Lines->Add(">>Skip patch code !!");
	                	rtn=0;
	                	goto exit;
                        }
                        else
                        {
                            patch_type =0;
                        }


                }

                if (patch_type == 1)
                {
                        AnsiString cur_exe_path =  ExtractFilePath(Application->ExeName);

                        file_path.sprintf(("%s%s"),cur_exe_path,app_FileName[0]);
                        DataFile = fopen(file_path.c_str(), "r+b");


                }
                else
                {
                //20160804  Dean add
                //Get cur_rtlbtapp.exe path
                AnsiString cur_exe_path =  ExtractFilePath(Application->ExeName);

                file_path.sprintf(("%s%s"),cur_exe_path,tmp_FileName[pBTInfo->ChipType]);
                DataFile = fopen(file_path.c_str(), "r+b");
                //
	       //	DataFile = fopen(tmp_FileName[pBTInfo->ChipType], "r+b");

               }
	}
	else
	{
		if (new_Filepath == NULL)
		{
			Memo_msg->Lines->Add(">>Path is NULL!!");
			rtn=-1;
			goto exit;
		}
		else
		{
			DataFile = fopen(new_Filepath, "r+b");
		}	
	}

 	if (DataFile == NULL)
	{
		dstr.sprintf(">>Error File path = %s..\n",file_path.c_str());
		Memo_msg->Lines->Add(dstr);
		rtn= -1;
		goto exit;
	}
	else
	{
		dstr.sprintf(">>Open File path = %s..\n",file_path.c_str());
		Memo_msg->Lines->Add(dstr);
		fseek(DataFile, 0, SEEK_END);
		lSize = ftell(DataFile);
		fseek(DataFile, 0, SEEK_SET);
	}

	buffer = (char *)malloc(lSize);
	if (buffer ==NULL)
	{
		dstr.sprintf(">>allocate File patch error = %s..\n",file_path.c_str());    //tmp_FileName[pBTInfo->ChipType
		Memo_msg->Lines->Add(dstr);
		rtn= -1;
		goto exit;
	}
	
	if (fread(buffer,1,lSize,DataFile) == 0)
	{
		dstr.sprintf(">>read file error = %s..\n",file_path.c_str());
		Memo_msg->Lines->Add(dstr);
		rtn= -1;
		goto exit;
	}

	if (pBluetoothModule->DownloadPatchCode(pBluetoothModule,buffer,lSize,1) != BT_FUNCTION_SUCCESS)
	{
		Memo_msg->Lines->Add(">>Download patch code Faild!!..\n");

		rtn= -1;
		goto exit;
	}
	else
	{

		Memo_msg->Lines->Add(">>Download patch code Success!!\n");
                if (patch_type == 1)
                {
                 ShowMessage(">>Download Normal patch Code Succress<< ");
                }
	}

exit:
 	if (buffer !=NULL)
		free(buffer);
	if (DataFile !=NULL)
		fclose(DataFile);

	return rtn;

}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn15Click(TObject *Sender)
{
	OpenDialog1->Options.Clear();
	OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist;
	OpenDialog1->Filter = "Bin files (*.bin)|*.bin|All files (*.*)|*.*";
	OpenDialog1->FileName="rlt8723a_chip_b_cut_bt40_fw_asic_rom_patch.bin";
	OpenDialog1->FilterIndex=0;
	if(OpenDialog1->Execute())
	{
		if (API_bt_Download_PatchCode(0,OpenDialog1->FileName.c_str()) !=0)
		{
			Memo_msg->Lines->Add(">>Select patch code download error!!");
		}
		API_bt_ShowTxDefaultPower();		
#if 1
		if(mBT_CHIPINFO.ChipType < RTK_BT_CHIP_ID_RTL8822B)
		{
			CheckBox_Fw_TxRx_Mode->Checked = false;		
			CheckBox_Fw_TxRx_Mode->Enabled = true;			
			bFwTxRxMode = 0;
		}
		else
		{
			CheckBox_Fw_TxRx_Mode->Checked = true;
			CheckBox_Fw_TxRx_Mode->Enabled = false;
			bFwTxRxMode = 0;
		}				
#endif
	}

	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::FormCreate(TObject *Sender)
{
	Memo_msg->Lines->Clear();
        String dstr,VerStr;

#ifdef ACTS_BUMBLEBEE
        VerStr="ACTSBluetoothRF.dll";
#else
        VerStr="RtlBluetoothMP.dll";
#endif
	if (API_bt_LoadMpDll() !=0)
	{
		Btn_Dev_Open->Enabled=false;
		Btn_Dev_Close->Enabled=false;

                dstr.sprintf(">>Load %s Fail!!",VerStr) ;


                Memo_msg->Lines->Add(dstr);

                BitBtn_CFO_BEGIN->Enabled=false;
                BitBtn_GETCFO->Enabled=false;
                TabSheet8->Enabled=false;
                Btn_Dev_Open->Enabled=false;
                BitBtn_CFO_STOP->Enabled=false;
           BitBtn_CFO_REGWR->Enabled = false;
           BitBtn_CFO_REGRD->Enabled = false;
           BitBtn_CFO_EFUSEWR->Enabled = false;
           BitBtn_CFO_EFUSERD->Enabled = false;
               // ShowMessage(dstr);
	}
	else
	{
                dstr.sprintf(">>Load %s Success!!",VerStr) ;
		Memo_msg->Lines->Add(dstr);
                BitBtn_CFO_BEGIN->Enabled=true;
                BitBtn_GETCFO->Enabled=true;
                TabSheet8->Enabled=true;
                 Btn_Dev_Open->Enabled=true;
                 BitBtn_CFO_STOP->Enabled=true;
           BitBtn_CFO_REGWR->Enabled = true;
           BitBtn_CFO_REGRD->Enabled = true;
           BitBtn_CFO_EFUSEWR->Enabled = true;
           BitBtn_CFO_EFUSERD->Enabled = true;

	}
}
//---------------------------------------------------------------------------

void  TForm_Main::CloseDevice()
{
        TObject *Sender;
   	Btn_Dev_Close->Enabled=false;
	if (pBaseInterface != NULL)
	{
		Sleep(100);
		Btn_ActionStopClick(Sender) ;
		pBaseInterface->Close(pBaseInterface);
	}
	Memo_msg->Lines->Add(">>Close Device Success!!");
	Panel_LED->Color=clRed;
	Panel_LED->Caption="X";

  	Btn_Dev_Open->Enabled=true;

         return ;

}
void __fastcall TForm_Main::Btn_Dev_CloseClick(TObject *Sender)
{
        CloseDevice();

	return;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::BitBtn3Click(TObject *Sender)
{
	Btn_ActionStopClick(Sender);
	API_bt_HciReset();
        return ;
}

//---------------------------------------------------------------------------
void __fastcall TForm_Main::Btn_ActionExecClick(TObject *Sender)
{
	BT_PARAMETER *pParam=&mBT_PARAMETER;

	pParam->mChannelNumber = Cbx_NoLink_Ch->ItemIndex;
	pParam->mPacketType = Cbx_PktType->ItemIndex;
	pParam->mPayloadType = Cbx_PayloadType->ItemIndex;
	pParam->mTxPacketCount = StrToInt(Edit_PktCount->Text);
	pParam->mTxGainIndex = StrToInt(Cbx_TxGainIndex->Text);
	pParam->mPacketHeader = StrToInt(Edit_PktHeader->Text);
	pParam->mTxDAC = StrToInt(Cbx_TxDacIndex->Text);
	pParam->PHY = ComboBox_LEE_ContTx_PHY->ItemIndex + 1; //from 1

	if(CheckBox_WhiteningEnable->Checked == true)
	{
		pParam->mWhiteningCoeffValue = 0x7f;
	}
	else
	{
		pParam->mWhiteningCoeffValue = 0x80;
	}
	
	//hit address
        pParam->mHitTarget= StrToInt64(ComboBox_HitAddr->Text);
		
	
	unsigned long trx_updata=0;
	String dstr;

	Cbx_Actionexec->Enabled=false;
	Btn_ActionExec->Enabled=false;
	Btn_ActionClearReport->Enabled=false;
	TrxFixObject(false);
	
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);

		goto exit;
	}
	
	if ((CheckBox_EnableTxDac->Checked)&& (pParam->mTxDAC!=0))
	{
		pParam->ParameterIndex = SET_POWER_DAC;  
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if(pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>Set Dac Fail...!!\n");Memo_msg->Lines->Add(dstr);
			return;
		}
	}

	if (FWExeJobMode1->Checked)
	{
		pParam->ExeMode = 1;
	}
	else
	{
		pParam->ExeMode = 0;
	}
	
	switch (Cbx_Actionexec->ItemIndex)
	{
		case CONT_TX_ACTION : //Cont Tx
			if(bFwTxRxMode == 0)
			{
				pParam->ParameterIndex = CONTINUE_TX_START;
				trx_updata=REPORT_CON_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;
			}
			else
			{
				pParam->ParameterIndex = FW_CONTINUE_TX_START;
				trx_updata=REPORT_FW_CONTINUE_TX;				
				PageControl_Report->ActivePage=TabSheet_TXReport;
			}

			break;

		case PKT_TX_ACTION : //Pkt Tx
			if(bFwTxRxMode == 0)
			{
				pParam->ParameterIndex = PACKET_TX_START;
				trx_updata=REPORT_PKT_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;
			}
			else
			{
				pParam->ParameterIndex = FW_PACKET_TX_START;
				trx_updata=REPORT_FW_PACKET_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;
			}

			break;
			
		case PKT_RX_ACTION : //Pkt Rx
			if(bFwTxRxMode == 0)
			{		
				pParam->ParameterIndex = PACKET_RX_START;
				trx_updata=REPORT_RKT_RX;
				PageControl_Report->ActivePage=TabSheet_RxReport;
			}
			else
			{
				pParam->ParameterIndex = FW_PACKET_RX_START;
				trx_updata=REPORT_FW_PACKET_RX;
				PageControl_Report->ActivePage=TabSheet_RxReport;			
			}
			
			break;
			
		case SINGLE_TONE_ACTION :  //Single Tone
			if(bFwTxRxMode == 0)
			{				
				pParam->ParameterIndex = CONTINUE_TX_START;
				trx_updata=REPORT_CON_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;

				pParam->mTxPacketCount=0;
				pParam->mWhiteningCoeffValue=0x80;
				pParam->mPayloadType= BT_PAYLOAD_TYPE_ALL0;
				pParam->mPacketType= BT_PKT_3DH5;
			}
			else
			{
				pParam->ParameterIndex = FW_CONTINUE_TX_START;
				trx_updata=REPORT_FW_CONTINUE_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;

				pParam->mTxPacketCount=0;
				pParam->mWhiteningCoeffValue=0x80;
				pParam->mPayloadType= BT_PAYLOAD_TYPE_ALL0;
				pParam->mPacketType= BT_PKT_3DH5;
			}

			break;

		case LE_CONT_TX_ACTION :	//LE Cont Tx

			if(mBT_CHIPINFO.ChipType ==RTK_BT_CHIP_ID_RTL8763B)
			{
				switch(pParam->PHY)
				{
					case LE5_TX_1M_PHY:
						pParam->mPacketType = BT_PKT_LE;
						break;
								
					case LE5_TX_2M_PHY:
						pParam->mPacketType = BT_PKT_LE_2M;
						break;
								
					case LE5_TX_CODED_PHY_S8:
						pParam->mPacketType = BT_PKT_LE_CODED_S8;
						break;

					case LE5_TX_CODED_PHY_S2:
						pParam->mPacketType = BT_PKT_LE_CODED_S2;
						break;
				}
			}

			if(bFwTxRxMode == 0)
			{
				pParam->ParameterIndex = LE_CONTINUE_TX_START;
				trx_updata=REPORT_LE_CONTINUE_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;
			}
			else
			{
				pParam->ParameterIndex = FW_LE_CONTINUE_TX_START;
				trx_updata=REPORT_FW_LE_CONTINUE_TX;
				PageControl_Report->ActivePage=TabSheet_TXReport;
			}

			break;
		
		default:
			dstr.sprintf(">>Error ActionControlExcute...!!");Memo_msg->Lines->Add(dstr);
			return;
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		dstr.sprintf(">>ActionControlExcute(%s) Fail...!!\n",Cbx_Actionexec->Text);Memo_msg->Lines->Add(dstr);
		return;
	}

	//thread enable
	if (!TXRXThreadDisable1->Checked)
	{
		if (Thread_TRX == NULL)
		{
			Thread_TRX = new rtkbtTrx(true);
			Thread_TRX->SetTxRxUpdata(pBluetoothModule,trx_updata,pParam);
			Thread_TRX->Priority = tpHigher;//tpNormal;
			Thread_TRX->Resume();
		}
		dstr.sprintf(">>Enable TRX Thread Mode...!!",Cbx_Actionexec->Text);Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf(">>Disable TRX Thread Mode...!!",Cbx_Actionexec->Text);Memo_msg->Lines->Add(dstr);
	}
	
	dstr.sprintf(">>ActionControlExcute(%s) Success...!!",Cbx_Actionexec->Text);Memo_msg->Lines->Add(dstr);
	return;
	
exit:
	Cbx_Actionexec->Enabled=true;
	Btn_ActionExec->Enabled=true;
	Btn_ActionClearReport->Enabled=true;
	return;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Btn_ActionStopClick(TObject *Sender)
{
	//BT_PARAMETER mParam;
	//BT_PARAMETER *pParam= &mParam;
	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER; 
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if (FWExeJobMode1->Checked)
	{
		pParam->ExeMode = 1;
	}
	Btn_ActionStop->Enabled = false;
	if (Thread_TRX!=NULL)
	{
		Thread_TRX->Terminate();
		Sleep(100);
		delete(Thread_TRX);
		Thread_TRX=NULL;

		switch (Cbx_Actionexec->ItemIndex)
		{
			case CONT_TX_ACTION :
				if(bFwTxRxMode == 0)
				{
					pParam->ParameterIndex=CONTINUE_TX_STOP; 
				}
				else
				{
					pParam->ParameterIndex=FW_CONTINUE_TX_STOP; 
				}
				break;

			case PKT_TX_ACTION : 
				if(bFwTxRxMode == 0)
				{
					pParam->ParameterIndex=PACKET_TX_STOP; 
				}
				else
				{
					pParam->ParameterIndex=FW_PACKET_TX_STOP; 
				}
				break;

			case PKT_RX_ACTION :
				if(bFwTxRxMode == 0)
				{			
					pParam->ParameterIndex=PACKET_RX_STOP;
				}
				else
				{
					pParam->ParameterIndex=FW_PACKET_RX_STOP;
				}
				break;

			case SINGLE_TONE_ACTION :
				if(bFwTxRxMode == 0)
				{
					pParam->ParameterIndex=CONTINUE_TX_STOP;
				}
				else
				{
					pParam->ParameterIndex=FW_CONTINUE_TX_STOP;
				}
				break;

			case LE_CONT_TX_ACTION :
				if(bFwTxRxMode == 0)
				{
					pParam->ParameterIndex=LE_CONTINUE_TX_STOP;
				}
				else
				{
					pParam->ParameterIndex=FW_LE_CONTINUE_TX_STOP;
				}
				break;

		 	default:
				dstr.sprintf(">>Error ActionControlExcute...!!");Memo_msg->Lines->Add(dstr);
			goto exit;
		}
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if(pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>ActionControlExcute(%s) Fail...!!\n",Cbx_Actionexec->Text);Memo_msg->Lines->Add(dstr);
		}
		else
		{
			dstr.sprintf(">>ActionControlExcute(%s) Stop...!!\n",Cbx_Actionexec->Text);Memo_msg->Lines->Add(dstr);
		}

        }
	Cbx_Actionexec->Enabled=true;
	Btn_ActionExec->Enabled=true;
	Btn_ActionClearReport->Enabled=true;
	TrxFixObject(true);

exit:
	Btn_ActionStop->Enabled = true;
	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Btn_ActionClearReportClick(TObject *Sender)
{
	//BT_PARAMETER mParam;
	//BT_PARAMETER *pParam=&mParam;
	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER; 
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		goto exit;
	}

        Btn_ActionClearReport->Enabled=false;

	pParam->ParameterIndex= REPORT_CLEAR;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		dstr.sprintf(">>ActionControlExcute(REPORT_CLEAR) Fail...!!");Memo_msg->Lines->Add(dstr);
		goto exit;
	}
	else
	{
		dstr.sprintf(">>ActionControlExcute(REPORT_CLEAR) Success...!!");Memo_msg->Lines->Add(dstr);
	}
 exit:
	dstr.sprintf("00000000.0");
	StringGrid_RXReport->Cells[1][1] = dstr;
	StringGrid_RXReport->Cells[1][2] = dstr;
	StringGrid_RXReport->Cells[1][3] = dstr;
	StringGrid_RXReport->Cells[1][4] = dstr;
	StringGrid_RXReport->Cells[1][5] = dstr;
	StringGrid_TXReport->Cells[1][1] = dstr;
	StringGrid_TXReport->Cells[1][2] = dstr;
        Btn_ActionClearReport->Enabled=true;

	return;
}


//---------------------------------------------------------------------------
void TForm_Main::TrxFixObject(bool Fix)
{
	Cbx_NoLink_Ch->Enabled=Fix;
	Cbx_PktType->Enabled=Fix;
	Cbx_PayloadType->Enabled=Fix;
	Edit_PktCount->Enabled=Fix;

	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn8Click(TObject *Sender)
{
	int rtn=0;
	int Page = 0;
	String str_RW_Addr = Edit_RW_ADDR->Text;
	String str_Value = Edit_RW_VALUE->Text;
	unsigned long RegStartAddr;
	unsigned char Msb=StrToInt(Edit_RW_MSB->Text);
	unsigned char Lsb=StrToInt(Edit_RW_LSB->Text);
	unsigned long Value;
	String szType,dstr;


	if( (str_RW_Addr.Pos("0x")==0) &&(str_RW_Addr.Pos("0X")==0) )
	{
		RegStartAddr = StrToInt("0x"+str_RW_Addr);
	}
	else
	{
		RegStartAddr = StrToInt(str_RW_Addr);
	}
	

	if( (str_Value.Pos("0x")==0) && (str_Value.Pos("0X")==0) )
	{
		Value = StrToInt("0x"+str_Value);
	}
	else
	{
		Value = StrToInt(str_Value);
	}

	Value=0;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}
	if (RadioButton_RF->Checked)
	{
		szType= "RF Regiser:";
		pBluetoothModule->GetRfRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,&Value);
	}
	else  if (RadioButton_MD->Checked)
	{
		szType= "Modem Regiser:";
		rtn=pBluetoothModule->GetMdRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,&Value);
	}
	else  if (RadioButton_BT->Checked)
	{
		szType= "BT Regiser:";
		Page = Combo_BBRegPageNo->ItemIndex;
		rtn=pBluetoothModule->GetBBRegMaskBits(pBluetoothModule,Page,RegStartAddr,Msb,Lsb,&Value);
	}
	else if (RadioButton_MAC->Checked)
	{
		szType= "MAC Regiser:";
		rtn=pBluetoothModule->GetSysRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,&Value);
	}

	if (rtn==0)
	{
		dstr.sprintf(">>%sRead<--%d,0x%x,[%d:%d] = 0x%x",szType,Page,RegStartAddr,Msb,Lsb,Value);
		Memo_msg->Lines->Add(dstr);
		dstr.sprintf("%x",Value);
		Edit_RW_VALUE->Text=dstr;
                Assign_DataToBtn();
	}
	else
	{
		dstr.sprintf(">>%s Read Error!!...",szType);Memo_msg->Lines->Add(dstr);
	}

	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn14Click(TObject *Sender)
{
	int rtn=0;
	int Page = 0;
	unsigned long RegStartAddr;
	unsigned char Msb=StrToInt(Edit_RW_MSB->Text);
	unsigned char Lsb=StrToInt(Edit_RW_LSB->Text);
	unsigned long Value;
	String str_RW_Addr = Edit_RW_ADDR->Text;
	String str_Value = Edit_RW_VALUE->Text;

	if( (str_RW_Addr.Pos("0x")==0) &&(str_RW_Addr.Pos("0X")==0) )
	{
		RegStartAddr = StrToInt("0x"+str_RW_Addr);
	}
	else
	{
		RegStartAddr = StrToInt(str_RW_Addr);
	}
	

	if( (str_Value.Pos("0x")==0) && (str_Value.Pos("0X")==0) )
	{
		Value = StrToInt("0x"+str_Value);
	}
	else
	{
		Value = StrToInt(str_Value);
	}

	String szType,dstr;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}
	if (RadioButton_RF->Checked)
	{
		szType= "RF Register:";
		pBluetoothModule->SetRfRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
	}
	else  if (RadioButton_MD->Checked)
	{
		szType= "Modem Register:";
		rtn=pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
	}
	else  if (RadioButton_BT->Checked)
	{
		szType= "BT Register:";
		Page = Combo_BBRegPageNo->ItemIndex;
		rtn=pBluetoothModule->SetBBRegMaskBits(pBluetoothModule,Page,RegStartAddr,Msb,Lsb,Value);
	}
	else if (RadioButton_MAC->Checked)
	{
		szType= "MAC Register:";
		rtn=pBluetoothModule->SetSysRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
	}

	if (rtn==0)
	{
		dstr.sprintf(">>%sWrite-->%d, 0x%x,[%d:%d] = 0x%x",szType,Page,RegStartAddr,Msb,Lsb,Value);Memo_msg->Lines->Add(dstr);
                Assign_DataToBtn();
	}
	else
	{
		dstr.sprintf(">>%s Write Error!!...",szType);Memo_msg->Lines->Add(dstr);
	}
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::BitBtn_GetChipInfoClick(TObject *Sender)
{
	Memo_msg->Lines->Add("=============================");
	if (API_bt_GetChipInfo(NULL) !=0 )
	{
		Memo_msg->Lines->Add(">>Get Chip info error!!");
	}
	Memo_msg->Lines->Add("=============================");
	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ClearLog1Click(TObject *Sender)
{
	Memo_msg->Lines->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::SaveLogas1Click(TObject *Sender)
{
	SaveDialog1->Options.Clear();
	SaveDialog1->Options << ofAllowMultiSelect << ofFileMustExist;
	SaveDialog1->Filter = "Txt files (*.txt)|All files (*.*)|*.*";
	SaveDialog1->FileName="rtkBtApp.txt";
	SaveDialog1->FilterIndex=0;
	if(SaveDialog1->Execute())
	{
		Memo_msg->Lines->SaveToFile(SaveDialog1->FileName);
	}
	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::LoadLog1Click(TObject *Sender)
{
	OpenDialog1->Options.Clear();
        OpenDialog1->Title = "Load Log File";
	OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist;
	OpenDialog1->Filter = "Txt files (*.txt)|All files (*.*)|*.*";
	OpenDialog1->FileName="rtkBtApp.txt";
	OpenDialog1->FilterIndex=0;
	if(OpenDialog1->Execute())
	{
		Memo_msg->Lines->LoadFromFile(OpenDialog1->FileName);
	}
	return ;
}


void __fastcall TForm_Main::BitBtn_TestModeEnableClick(TObject *Sender)
{

	BT_PARAMETER *pParam=&mBT_PARAMETER;
	String dstr;

 	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return ;
	}

	pParam->ParameterIndex = TEST_MODE_ENABLE;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Test Mode Enable Fail...");
	}
	else
	{
		Memo_msg->Lines->Add("Test Mode Enable...");
	}
		
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::BitBtn_SetTxGainTable2DefaultClick(TObject *Sender)
{

	BT_PARAMETER 	*pParam=&mBT_PARAMETER;

	String dstr;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	pParam->ParameterIndex= SET_DEFAULT_TX_GAIN_TABLE;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);	
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule)!=0)
	{
		dstr.sprintf(">>Set Default Tx Gain Table Fail..!!");Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf(">>Set Default Tx Gain Table Success..!!");Memo_msg->Lines->Add(dstr);
	}




	return;

}



//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_SetTxDACTable2DefaultClick(
      TObject *Sender)
{


	BT_PARAMETER *pParam=&mBT_PARAMETER;

	String dstr;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	pParam->ParameterIndex= SET_DEFAULT_TX_DAC_TABLE;
	
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule)!=0)
	{
		dstr.sprintf(">>Set Default Tx DAC Table Fail..!!");Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf(">>Set Default Tx DAC Table Success..!!");Memo_msg->Lines->Add(dstr);
	}
	return ;

}

//---------------------------------------------------------------------------


void __fastcall TForm_Main::BitBtn_SetRtl8761XtalClick(TObject *Sender)
{

	BT_PARAMETER *pParam=&mBT_PARAMETER;

	String dstr;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return ;
	}

	pParam->ParameterIndex = SET_XTAL;

        pParam->Rtl8761Xtal = Cbx_RTL8761_XTAL->ItemIndex;

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
                Memo_msg->Lines->Add("Set Crystal Fail...");
	}
	else
	{
		dstr.sprintf("Set Crystal = 0x%x",pParam->Rtl8761Xtal);
		Memo_msg->Lines->Add(dstr);
	}
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_ReadThermalClick(TObject *Sender)
{
	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionReport(pBluetoothModule,REPORT_THERMAL, &mBT_DEVICE_REPORT)!=0)
	{
		Memo_msg->Lines->Add("Read Thermal Fail...");
	}
	else
	{
        	dstr.sprintf("0x%x", mBT_DEVICE_REPORT.CurrThermalValue);
		Memo_msg->Lines->Add("Read Thermal..."+dstr);
	}	
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::BitBtn_GetRtl8761XtalClick(TObject *Sender)
{
	//   BT_PARAMETER 	*pParam=&mBT_PARAMETER;

	String dstr;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if(pBluetoothModule->ActionReport(pBluetoothModule,REPORT_XTAL, &mBT_DEVICE_REPORT)!=0)
	{
                Memo_msg->Lines->Add("Get Crystal Fail...");
		return;
	}
	else
	{
		dstr.sprintf("Get Crystal = 0x%x",mBT_DEVICE_REPORT.CurrRtl8761Xtal);
		Memo_msg->Lines->Add(dstr);
	}


        Cbx_RTL8761_XTAL->ItemIndex = mBT_DEVICE_REPORT.CurrRtl8761Xtal;
        return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_GetBTStageClick(TObject *Sender)
{
	//BT_PARAMETER 	*pParam=&mBT_PARAMETER;

	String dstr;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return ;
	}

	if(pBluetoothModule->ActionReport(pBluetoothModule, REPORT_BT_STAGE, &mBT_DEVICE_REPORT)!=0)
	{
		Memo_msg->Lines->Add(">>Get BT Stage Fail...");
		Edit_BT_Stage->Text="Unknow";
	}
	else
	{
		dstr.sprintf(">>Get BT Stage... Stage= %d",mBT_DEVICE_REPORT.CurrStage) ;
		Memo_msg->Lines->Add(dstr);
		dstr.sprintf("0x%x",mBT_DEVICE_REPORT.CurrStage);
		Edit_BT_Stage->Text=dstr;
	}
	return;

}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::TXRXThreadDisable1Click(TObject *Sender)
{
	TXRXThreadDisable1->Checked=! TXRXThreadDisable1->Checked;
}

//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_PGMPDataClick(TObject *Sender)
{
	String dstr;
	unsigned long long  BDADDR= StrToInt64(Edit_Efuse_BDAddr->Text) ;
	unsigned char Thermal=StrToInt(Edit_Efuse_Thermal->Text)&0xFF;
	unsigned char dac=StrToInt(Edit_Efuse_Dac->Text)&0xFF;
	unsigned char Xtal=StrToInt(Edit_Efuse_Xtal->Text)&0xFF;

	BitBtn_PGMPData->Enabled=false;
	WriteMpParamterToEfuse((unsigned char *)&BDADDR,Thermal,dac,Xtal);

	if (CheckBox_Efuse_PowerOn->Checked)
		WriteMpPowerOnFunctionToEfuse(ComboBox_PowerOnEnable->ItemIndex,ComboBox_PowerOnActive->ItemIndex);

	dstr.sprintf(">>Write Efuse MP Data process end... \n");
	Memo_msg->Lines->Add(dstr);

	BitBtn_PGMPData->Enabled=true;
		
	return;
}
//---------------------------------------------------------------------------




int TForm_Main::BaseWriteMpParamterToEfuse(unsigned char Index, unsigned char *pData)
{
	BT_PARAMETER *pParam=	&mBT_PARAMETER;

	int n=0;

	unsigned char *pPGRawData;

	DBGPRINTF(">>++RTKBT_BaseWriteMpParamterToEfuse()\n");

	pParam->ParameterIndex = WRITE_EFUSE_DATA;
	pPGRawData = pParam->mPGRawData;
	memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

	if (Index == SET_INDEX_BT_ADDR)
	{
		if ((pData[0] != 0x00) || (pData[1] != 0x00) ||(pData[2] != 0x00)
		||  (pData[3] != 0x00)|| (pData[4] != 0x00) ||(pData[5] != 0x00))
		{
			pPGRawData[0] = 0x01; // BT Efuse
			pPGRawData[1] = 0x3c; // offset low byte
			pPGRawData[2] = 0x00; // offset high byte
			pPGRawData[3] = 0x06; // len
			for (n=0; n < 6; n++) // 6-byte mac addr
				pPGRawData[n+4]= pData[n];
		}
	}
	else if (Index == SET_INDEX_TX_POWER_DAC)
	{
		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x60; // offset low byte
		pPGRawData[2] = 0x01; // offset high byte
		pPGRawData[3] = 0x02; // len
		pPGRawData[4] = 0xfe; // low byte value
		pPGRawData[5] = pData[0]; // dac value
	}
	else if (Index == SET_INDEX_THERMAL)
	{
		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x80; // offset low byte
		pPGRawData[2] = 0x01; // offset high byte
		pPGRawData[3] = 0x02; // len
		pPGRawData[4] = 0x00; // low byte value
		pPGRawData[5] = pData[0]; // thermal value
	}
	else if(Index == SET_INDEX_XTAL)
	{
		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0xe6; // offset low byte
		pPGRawData[2] = 0x01; // offset hight byte
		pPGRawData[3] = 0x01; // len
		pPGRawData[4] = pData[0] & 0x3f; // 1-byte crystal	
	}
	else if(Index == SET_INDEX_USB_VID_PID)
	{
		pPGRawData[0] = 0x02; // SYS Efuse
		pPGRawData[1] = 0x24; // offset low byte
		pPGRawData[2] = 0x00; // offset high byte
		pPGRawData[3] = 0x04; // len
		for (n = 0; n < 4; n++) // 4-byte usb vid, pid
			pPGRawData[n+4] = pData[n];	
	}		
	else
	{
		DBGPRINTF(">>No Write efuse MP Data...\n");	
		return 0;
	}

	if (pBluetoothModule == NULL)
	{
		DBGPRINTF(">>BluetoothModule is NULL...!!\n");
		goto exit;
	}
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);


	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		DBGPRINTF(">>Raw Data Exec Fail...\n");
		goto exit;
	}
	else
	{
		DBGPRINTF(">>Raw Data Exec Success...\n");
	}

	DBGPRINTF(">>--RTKBT_BaseWriteMpParamterToEfuse\n");
	
	return 0;
exit:

	DBGPRINTF(">>--RTKBT_BaseWriteMpParamterToEfuse : ERROR\n");
	
	return 1;
}





//---------------------------------------------------------------------------
int TForm_Main:: WriteMpParamterToEfuse(unsigned char *BD_Addr,unsigned char ThermalValue,unsigned char TxPowerDac, unsigned char Xtal)  //Output
{
	
	if (CheckBox_Efuse_BDAddr->Checked)
	{
		BaseWriteMpParamterToEfuse(SET_INDEX_BT_ADDR, BD_Addr);
	}

	if (CheckBox_Efuse_Thermal->Checked)
	{
		BaseWriteMpParamterToEfuse(SET_INDEX_THERMAL, &ThermalValue);
	}

	if (CheckBox_Efuse_Dac->Checked)
	{
		BaseWriteMpParamterToEfuse(SET_INDEX_TX_POWER_DAC, &TxPowerDac);
	}

	if (CheckBox_Efuse_Xtal->Checked)
	{
		BaseWriteMpParamterToEfuse(SET_INDEX_XTAL, &Xtal);
	}

	return 0;

}


int TForm_Main:: WriteMpPowerOnFunctionToEfuse(int PowerOn_enable,int PowerOn_Active)  //Output
{
        String dstr;
        BT_PARAMETER 	*pParam=&mBT_PARAMETER;
        pParam->ParameterIndex = WRITE_EFUSE_DATA;
        unsigned char *pData = pParam->mPGRawData;
        memset(pData,0x00,64);

        if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}

        pData[0] = 0x01; // BT Efuse
        pData[1] = 0x76; // offset low byte
        pData[2] = 0x01; // offset high byte
        pData[3] = 0x02; // len
        pData[4] = 0x20; // low byte value

       if (PowerOn_enable == 0)
                pData[5]=0x3c;
       else
                pData[5]=0x3d;

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Raw Data Exec Fail...");
		return -1;
	}
	else
	{
		Memo_msg->Lines->Add("Raw Data Exec Success...");
	}
	
	pData[0] = 0x01; // BT Efuse
	pData[1] = 0x30; // offset low byte
	pData[2] = 0x00; // offset high byte
	pData[3] = 0x02; // len

	if (PowerOn_Active == 0) // high level active, keep low when idle
	{
		pData[4]=0x40;
		pData[5]=0x52;
	}
	else // low level active, keep high when idle
	{
		pData[4]=0x52;
		pData[5]=0x50;
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Raw Data Exec Fail...");
		return -1;
	}
	else
	{
		Memo_msg->Lines->Add("Raw Data Exec Success...");
	}
	return 0;
}



//---------------------------------------------------------------------------



#define LE_TX_DUT_TEST 0
#define LE_RX_DUT_TEST 1


void __fastcall TForm_Main::Btn_LeTest_StartClick(TObject *Sender)
{
	String dstr;

	BT_PARAMETER *pParam=&mBT_PARAMETER;
	DWORD t_start,t_end,t;

	unsigned char LeTest_Action = ComboBox_LeTest_Action->ItemIndex;
	unsigned char LeTest_Channel = ComboBox_LeTest_Channel->ItemIndex;
	unsigned char LeTest_DataLen = ComboBox_LeTest_DataLen->ItemIndex;
	unsigned char LeTest_PayloadType =ComboBox_LeTest_PayloadType->ItemIndex;
	unsigned long LeTest_TxGainIndex = StrToInt(ComboBox_LeTest_TxGainIndex->Text);
	unsigned long LeTest_PHY = ComboBox_LEE_PHY->ItemIndex;
	unsigned long LeTest_Modulation = ComboBox_LEE_Modulation->ItemIndex;	


        //////////////////////////////////////////////////////////////////
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

#if 0
	if(pBTInfo->ChipType == RTK_BT_CHIP_ID_RTL8723D)
	{
		pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x3C, 13, 13, 0);
	}
	
	pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x3C, 12, 12, 0);
	pBluetoothModule->SetBBRegMaskBits(pBluetoothModule, 0, 0x178, 15, 0, LeTest_TxGainValue);
	pBluetoothModule->SetBBRegMaskBits(pBluetoothModule, 0, 0x17A, 15, 0, 0x382);
#endif

	pParam->mChannelNumber= LeTest_Channel;
	pParam->mParamData[0] = LeTest_DataLen;
	pParam->mPayloadType= LeTest_PayloadType;
	pParam->PHY = LeTest_PHY + 1; //from 1
	pParam->ModulationIndex = LeTest_Modulation;	
	pParam->mTxGainIndex = LeTest_TxGainIndex;

        Memo_msg->Lines->Add(dstr);

	if(LeTest_Action == LE_TX_DUT_TEST)
	{
		pParam->ParameterIndex = LE_TX_DUT_TEST_CMD;
		dstr.sprintf(">>LeTest_Start : PKT TX\n");
	}
	else
	{
		pParam->ParameterIndex = LE_RX_DUT_TEST_CMD;
		dstr.sprintf(">>LeTest_Start : PKT RX\n");
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		dstr.sprintf(">>ActionControlExcute(%d) Fail...!!\n",pParam->ParameterIndex );
		Memo_msg->Lines->Add(dstr);
		return ;
	}

	Btn_LeTest_Start->Enabled = false;
	Btn_LeTest_Stop->Enabled = true;

	Memo_msg->Lines->Add(dstr);

        return ;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Btn_LeTest_StopClick(TObject *Sender)
{
	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	//RadioGroup_Thermal_Panel->Enabled=true;
	if (ShowUI != NULL)
	{
		ShowUI->Terminate();
		ShowUI =NULL;
	}
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if( (ComboBox_LeTest_Action->ItemIndex == LE_TX_DUT_TEST) || 
		(ComboBox_LeTest_Action->ItemIndex == LE_RX_DUT_TEST) )
	{
		pParam->ParameterIndex = LE_DUT_TEST_END_CMD;
	}

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		dstr.sprintf(">>ActionControlExcute(%d) Fail...!!\n",pParam->ParameterIndex );
		Memo_msg->Lines->Add(dstr);
		return;
	}

	pBluetoothModule->ActionReport(pBluetoothModule,REPORT_LE_RX, &mBT_DEVICE_REPORT);

	dstr.sprintf("%d",mBT_DEVICE_REPORT.TotalRxCounts);
	
	Edit_LeTest_RxCount->Text=dstr;	
	
	Btn_LeTest_Start->Enabled = true;
	Btn_LeTest_Stop->Enabled = false;

	dstr.sprintf(">>LeTest_Stop\n");
	Memo_msg->Lines->Add(dstr);

}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ComboBox_LeTest_ActionChange(TObject *Sender)
{

	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;

	if(ComboBox_LeTest_Action->ItemIndex == LE_TX_DUT_TEST)
	{
		ComboBox_LeTest_DataLen->Enabled = true;
		ComboBox_LeTest_PayloadType->Enabled = true;
		Edit_LeTest_RxCount->Enabled = false;

		if(pModuleBtReport->pBTInfo->ChipType==RTK_BT_CHIP_ID_RTL8763B)
		{
			ComboBox_LEE_PHY->Enabled = true;
			ComboBox_LEE_Modulation->Enabled = false;

			ComboBox_LEE_PHY->Items->Clear();
			ComboBox_LEE_PHY->Items->Add("LE 1M PHY");
			ComboBox_LEE_PHY->Items->Add("LE 2M PHY");
			ComboBox_LEE_PHY->Items->Add("LE Coded PHY with S=8");
			ComboBox_LEE_PHY->Items->Add("LE Coded PHY with S=2");
			ComboBox_LEE_PHY->ItemIndex = 0;
		}

	}
	else if(ComboBox_LeTest_Action->ItemIndex == LE_RX_DUT_TEST)
	{
		ComboBox_LeTest_DataLen->Enabled = false;
		ComboBox_LeTest_PayloadType->Enabled = false;
		Edit_LeTest_RxCount->Enabled = true;

		if(pModuleBtReport->pBTInfo->ChipType==RTK_BT_CHIP_ID_RTL8763B)
		{
			ComboBox_LEE_PHY->Enabled = true;
			ComboBox_LEE_Modulation->Enabled = true;

			ComboBox_LEE_PHY->Items->Clear();
			ComboBox_LEE_PHY->Items->Add("LE 1M PHY");
			ComboBox_LEE_PHY->Items->Add("LE 2M PHY");
			ComboBox_LEE_PHY->Items->Add("LE Coded PHY");
			ComboBox_LEE_PHY->ItemIndex = 0;
		}
	}
	else
	{
		ComboBox_LeTest_DataLen->Enabled = false;
		ComboBox_LeTest_PayloadType->Enabled = false;
		Edit_LeTest_RxCount->Enabled = false;
	}
	
}
//---------------------------------------------------------------------------
#if 0
#define LEN_6_BYTE	6

int TForm_Main::WriteMpParamterToConfig(unsigned char Index, unsigned char *pData) 
{
	BT_PARAMETER *pParam =	&mBT_PARAMETER;

	unsigned char *pParamData;

	unsigned long i;

	String dstr;
	
	pParam->ParameterIndex = WRITE_PARAM_TO_FACTORY_AREA;
	pParamData = pParam->mParamData;
	
	pParamData[0] = Index;

	if(Index == SET_INDEX_BT_ADDR)
	{
		for( i = 0; i <LEN_6_BYTE; i++)
		{
			pParamData[i+1] = pData[i];
		}
	}
	else if(Index == SET_INDEX_XTAL)
	{
		pParamData[1] = pData[0];
		pParamData[2] = pData[0];
		pParamData[3] = 1;
		pParamData[4] = pData[0];
	}
	else
	{
		dstr.sprintf(">>No Write MP Data To Config...");
		Memo_msg->Lines->Add(dstr);
		goto exit;
	}

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!");
		Memo_msg->Lines->Add(dstr);		
		goto exit;
	}
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);


	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		goto exit;
	}
	
	dstr.sprintf(">>--RTKBT_WriteMpParamterToConfig");
	Memo_msg->Lines->Add(dstr);	
	return 0;
	
exit:
	dstr.sprintf(">>--RTKBT_WriteMpParamterToConfig : ERROR");
	Memo_msg->Lines->Add(dstr);	
	
	return 1;

}
#endif

void __fastcall TForm_Main::Button_ToFactoryAreaClick(TObject *Sender)
{
#if 0
	unsigned long long  BDADDR= StrToInt64(Edit1->Text) ;
	unsigned char Thermal=StrToInt(Edit2->Text)&0xFF;
	unsigned char dac=StrToInt(Edit3->Text)&0xFF;
	unsigned char Xtal=StrToInt(Edit4->Text)&0xFF;

	WriteMpParamterToConfig(SET_INDEX_BT_ADDR, (unsigned char *)&BDADDR);

	WriteMpParamterToConfig(SET_INDEX_XTAL, &Xtal);

#endif
	return ;    
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::CheckBox_EnableTxDacClick(TObject *Sender)
{
	unsigned int i;
	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER;

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}	
		
	pParam->ParameterIndex= SET_DEFAULT_TX_DAC_TABLE;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule)!=0)
	{
		goto error;
	}

	pBluetoothModule->ActionReport(pBluetoothModule,REPORT_TX_DAC_TABLE, &mBT_DEVICE_REPORT);

	if (CheckBox_EnableTxDac->Checked)
	{
		Cbx_TxDacIndex->Enabled = true;
	}
	else
	{
		Cbx_TxDacIndex->Enabled = false;
	}

	Cbx_TxDacIndex->Items->Clear();
	for (i=0; i<MAX_TXDAC_TABLE_SIZE; i++ )
	{
		dstr.sprintf("0x%.2x",mBT_DEVICE_REPORT.CurrTXDACTable[i]);
		Cbx_TxDacIndex->Items->Add(dstr);
	}

error:

	return;
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::Button_LedSetClick(TObject *Sender)
{

	String dstr;

	unsigned char pData[512];
	unsigned char pEvtBuf[512];

	pData[0] = ComboBox_LedNo->ItemIndex;
	pData[1] = ComboBox_LedLevel->ItemIndex;
	
	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, 0xfc37, 2, pData, 0x0E, pEvtBuf);

	if(pEvtBuf[5] != 0)
	{
		dstr.sprintf("Led Set : ERROR !!\n");Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf("Led Set : Success !!\n");Memo_msg->Lines->Add(dstr);
	}
	return;        
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::BitBtn_ReadEfuseClick(TObject *Sender)
{


	unsigned char *pPGRawData;
	unsigned char *pReport;
	
	String dstr;
	BT_PARAMETER *pParam;
	pParam=	&mBT_PARAMETER;
	
	pParam->ParameterIndex = READ_EFUSE_DATA;
	pPGRawData = pParam->mPGRawData;
	pReport = mBT_DEVICE_REPORT.ReportData;

 	BitBtn_ReadEfuse->Enabled=false;	

	if (CheckBox_Efuse_BDAddr->Checked)
	{
		memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x3c;
		pPGRawData[2] = 0x00;
		pPGRawData[3] = 0x06;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>Failed to read BDAddr efuse");
			Memo_msg->Lines->Add(dstr);

			dstr.sprintf("Error");
			Edit_Efuse_BDAddr->Text=dstr;
		}
		else
		{
			memset(pReport,0x00, MAX_USERAWDATA_SIZE);
			pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);
			dstr.sprintf("0X%02X%02X%02X%02X%02X%02X",pReport[9], pReport[8], pReport[7], pReport[6], pReport[5], pReport[4]);
			Edit_Efuse_BDAddr->Text=dstr;
			Memo_msg->Lines->Add(">>Read BDAddr Efuse Success: "+dstr);
		}
	}

	if (CheckBox_Efuse_Thermal->Checked)
	{
		memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x81;
		pPGRawData[2] = 0x01;
		pPGRawData[3] = 0x01;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
		     	dstr.sprintf(">>Failed to read Thermal efuse");
		      	Memo_msg->Lines->Add(dstr);

			dstr.sprintf("Error");
			Edit_Efuse_BDAddr->Text=dstr;
		}
		else
		{
			memset(pReport,0x00, MAX_USERAWDATA_SIZE);
			pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);
			dstr.sprintf("0x%02x",pReport[4]);
			Edit_Efuse_Thermal->Text=dstr;
			Memo_msg->Lines->Add(">>Read Thermal Efuse Success: " + dstr);
		}
	}

	if (CheckBox_Efuse_Dac->Checked)
	{

		memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x61;
		pPGRawData[2] = 0x01;
		pPGRawData[3] = 0x01;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>Failed to read DAC Efuse");
			Memo_msg->Lines->Add(dstr);

			dstr.sprintf("Error");
			Edit_Efuse_BDAddr->Text=dstr;
		}
		else
		{
			memset(pReport,0x00, MAX_USERAWDATA_SIZE);
			pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);
			dstr.sprintf("0x%.2x",pReport[4]);
			Edit_Efuse_Dac->Text=dstr;
                        Memo_msg->Lines->Add(">>Read DAC Efuse Success: " + dstr);
		}
	}

	if (CheckBox_Efuse_Xtal->Checked)
	{
		memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0xE6;
		pPGRawData[2] = 0x01;
		pPGRawData[3] = 0x01;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>Failed to Read Xtal Efuse");
			Memo_msg->Lines->Add(dstr);

			dstr.sprintf("Error");
			Edit_Efuse_BDAddr->Text=dstr;
		}
		else
		{
			memset(pReport,0x00, MAX_USERAWDATA_SIZE);
			pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);
			dstr.sprintf("0x%02x",pReport[4]);
			Edit_Efuse_Xtal->Text=dstr;
			Memo_msg->Lines->Add(">>Read Xtal Efuse Success: " + dstr);
		}
	}


	if (CheckBox_Efuse_PowerOn->Checked)
	{

		memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x76;
		pPGRawData[2] = 0x01;
		pPGRawData[3] = 0x02;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>Failed to Read PowerOn Efuse");
			Memo_msg->Lines->Add(dstr);
		}
		else
		{
			memset(pReport,0x00, MAX_USERAWDATA_SIZE);
			pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);

			if( (pReport[4] == 0x20) && (pReport[5] == 0x3C) )
			{
				ComboBox_PowerOnEnable->ItemIndex=0;
				dstr.printf("0x%02x,0x%02x", pReport[4], pReport[5]);
				Memo_msg->Lines->Add(">>Read PowerOn Efuse Successl[Disable]: " + dstr);
			}
			else if ( (pReport[4] == 0x20) && (pReport[5] == 0x3D) ) 
			{
				ComboBox_PowerOnEnable->ItemIndex=1;
				dstr.printf("0x%02x,0x%02x", pReport[4], pReport[5]);
				Memo_msg->Lines->Add(">>Read PowerOn Efuse Success[Enable]: " + dstr);
			}
			else
			{
				dstr.printf("0x%02x,0x%02x", pReport[4], pReport[5]);
				Memo_msg->Lines->Add(">>Read PowerOn Efuse Success[Invalid data]: " + dstr);
			}
		}



		memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

		pPGRawData[0] = 0x01; // BT Efuse
		pPGRawData[1] = 0x30;
		pPGRawData[2] = 0x00;
		pPGRawData[3] = 0x02;
		pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
		if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
		{
			dstr.sprintf(">>Failed to Read PowerOn Active level Efuse");
			Memo_msg->Lines->Add(dstr);
		}
		else
		{
			memset(pReport,0x00, MAX_USERAWDATA_SIZE);
			pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);

			if( (pReport[4] == 0x40) && (pReport[5] == 0x52) )
			{
				ComboBox_PowerOnActive->ItemIndex=0;
				dstr.printf("0x%02x,0x%02x", pReport[4], pReport[5]);
				Memo_msg->Lines->Add(">>Read PowerOn Active level Efuse Success[High active]: " + dstr);
			}
			else if ( (pReport[4] == 0x52) && (pReport[5] == 0x50) ) 
			{
				ComboBox_PowerOnActive->ItemIndex=1;
				dstr.printf("0x%02x,0x%02x", pReport[4], pReport[5]);
				Memo_msg->Lines->Add(">>Read PowerOn Active level Efuse Success[Low active]: " + dstr);
			}
			else
			{
				dstr.printf("0x%02x,0x%02x", pReport[4], pReport[5]);
				Memo_msg->Lines->Add(">>Read PowerOn Active level Efuse Success[Invalid data]: " + dstr);
			}
		}
	}

 	BitBtn_ReadEfuse->Enabled=true;
	
	return;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Btn_LoadScriptClick(TObject *Sender)
{
	OpenDialog1->Options.Clear();
	OpenDialog1->Title = "Load Script"  ;
	OpenDialog1->Options << ofAllowMultiSelect << ofFileMustExist;
	OpenDialog1->Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*";
	OpenDialog1->FileName="scrip.txt";
	OpenDialog1->FilterIndex=0;
	if(OpenDialog1->Execute())
	{
		Sctipt_Process(OpenDialog1->FileName.c_str());
	}
}
//---------------------------------------------------------------------------
int  TForm_Main::Register_Write(unsigned char regType,
                                unsigned long RegStartAddr,
                                unsigned char Page,
                                unsigned char Msb,
                                unsigned char Lsb,
                                unsigned long Value)
{
	int rtn=0;
	String szType,dstr;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");
                Memo_msg->Lines->Add(dstr);
                rtn=-1;
		goto exit;
	}
        switch (regType)
        {
            case 0 :
            		szType= "RF Regiser:";
		        pBluetoothModule->SetRfRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
            break;
            case 1:
		szType= "Modem Regiser:";
		rtn=pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
            break;
            case 2:
		szType= "MAC Regiser:";
		rtn=pBluetoothModule->SetSysRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
            break;
            case 3:
		szType= "BT Regiser:";
		rtn=pBluetoothModule->SetBBRegMaskBits(pBluetoothModule,Page,RegStartAddr,Msb,Lsb,Value);
            break;

        }
	if (rtn==0)
	{
                if (regType == 3)
                dstr.sprintf(">>%sWrite-->%d, 0x%x,[%d:%d] = 0x%x",szType,Page,RegStartAddr,Msb,Lsb,Value);
                else
		dstr.sprintf(">>%sWrite-->0x%x,[%d:%d] = 0x%x",szType,RegStartAddr,Msb,Lsb,Value);
	}
	else
	{
		dstr.sprintf(">>%s Write Error!!...",szType);
	}
        Memo_msg->Lines->Add(dstr);
exit:
        return rtn;
}

//---------------------------------------------------------------------------

int  TForm_Main::Sctipt_Process(char *filename)
{
	FILE *DataFile = NULL;
	char cmd[100];
	unsigned long  address,value;
	unsigned char page;
	int rtn;
	String szType,dstr;

	DataFile = fopen(filename, "r+");
	
	page=0;
	while(!feof(DataFile))
	{
		memset(cmd, 0, 100);
		fscanf(DataFile,"%s", cmd);

		if (strcmp(cmd , "ow") ==0)
		{
			fscanf(DataFile,"%x %x", &address, &value);
			szType = "Modem Regiser:";
			rtn = pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, address, 15, 0, value);
		}
		else if (strcmp(cmd , "iw") ==0)
		{
			fscanf(DataFile,"%x", &address);
			szType = "Modem Regiser:";
			rtn = pBluetoothModule->GetMdRegMaskBits(pBluetoothModule, address, 15, 0, &value);
		}
		else if (strcmp(cmd , "orf") == 0)
		{
			fscanf(DataFile,"%x %x", &address, &value);
			szType = "RF Regiser:";
			rtn = pBluetoothModule->SetRfRegMaskBits(pBluetoothModule, address, 15, 0, value);			
		}
		else if (strcmp(cmd , "irf") == 0)
		{
			fscanf(DataFile,"%x", &address);
			szType = "RF Regiser:";
			rtn = pBluetoothModule->GetRfRegMaskBits(pBluetoothModule, address, 15, 0, &value);
		}
	}

	Memo_msg->Lines->Add(dstr);

	if (DataFile != NULL)
		fclose(DataFile);

	return 0;
}

void __fastcall TForm_Main::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  switch(Key)
  {
    case 112:  //F1
  //  LoadScipt1Click(Sender);
    break;
    case 113:  //F2
  //  SaveScipt1Click(Sender);
    break;
    case 116:  //F5
        Btn_LoadScriptClick(Sender);
    break;

  }
}
//---------------------------------------------------------------------------
#define sbtnArray_TOP_SHIFT 130     //150
int TForm_Main::CreatsButtonArray()
{

   int i=0;
   String dstr;
   int count=0;
   for (i=0;i<MAX_SBTN_NUM_BTAPP;i++)
   {
      if (sbtnArray[i] == NULL)
      {
        sbtnArray[i]= new TSpeedButton(this);
        sbtnArray[i]->Tag=i;
        sbtnArray[i]->Parent=TabSheet_RW;
        sbtnArray[i]->Width=25;
        sbtnArray[i]->Height=25;
        sbtnArray[i]->Top= (i/16)*50 + sbtnArray_TOP_SHIFT;
        sbtnArray[i]->Cursor=crHandPoint;
        if (i%4 ==0)
        {
         count++;

        }
        sbtnArray[i]->Left= (TabSheet_RW->Left+TabSheet_RW->Width)- 25 *i -count *20 - 100;
     //   if (((i/8)%2) == 0) {
      //  sbtnArray[i]->Left= (GroupBox1->Left+GroupBox1->Width) - (((i%16)+1)*(sbtnArray[i]->Height+5));
     //   }
     //   else{
     //   sbtnArray[i]->Left= (GroupBox1->Left+GroupBox1->Width)-(((i%16)+1)*(sbtnArray[i]->Height+5))-20;
    //    }
        sbtnArray[i]->Caption="0";//IntToStr(i);
        sbtnArray[i]->Font->Color=clRed;
        sbtnArray[i]->Font->Size=12;
        sbtnArray[i]->OnClick = sButtonOnClick;
        sbtnArray[i]->Show();
        //Lable
        sLabelArray[i] = new TLabel(this);
        sLabelArray[i]->Tag=i;
        sLabelArray[i]->Parent=TabSheet_RW;
        sLabelArray[i]->Width=25;
        sLabelArray[i]->Height=25;
        sLabelArray[i]->Font->Size=12;
        sLabelArray[i]->Top= sbtnArray[i]->Top -20;  //(i/16)*50 + 150
        sLabelArray[i]->Left=sbtnArray[i]->Left;
        sLabelArray[i]->Caption=IntToStr(i);
       } 

   }
   sButtonOnClick(NULL);
   return 0;

}
void __fastcall TForm_Main::sButtonOnClick(TObject *Sender)
{

  TSpeedButton *btn = NULL;
 // int Index =0;

  if (Sender !=NULL)
  {
        btn=dynamic_cast<TSpeedButton *>(Sender);
        if (btn->Caption == "0")
        {
        btn->Caption ="1";
        btn->Font->Color=clLime;
        }
        else
        {
        btn->Caption ="0";
        btn->Font->Color=clRed;
        }
   }
   Assign_BtnToData();
   return ;


}
void  TForm_Main::Assign_DataToBtn()
{
	unsigned long Value;
	int i;
	String str_Value = Edit_RW_VALUE->Text;


	if( (str_Value.Pos("0x")==0) && (str_Value.Pos("0X")==0) )
	{
		Value = StrToInt("0x"+str_Value);
	}
	else
	{
		Value = StrToInt(str_Value);
	}

	for (i=0;i<16;i++)
	{
		if (((Value >> i) & 0x01 )  == 0x01)
		{
			sbtnArray[i]->Caption ="1";
			sbtnArray[i]->Font->Color=clLime;
		}
		else
		{
			sbtnArray[i]->Caption ="0";
			sbtnArray[i]->Font->Color=clRed;
		}
	}
	
	return;
}
void  TForm_Main::Assign_BtnToData()
{
	unsigned long Value = 0;//StrToInt(Edit_RW_VALUE->Text);
	int i=0;
	String dstr;

	for (i=0;i<16;i++)
	{
		Value = Value<<1;
		if (sbtnArray[15-i]->Caption =="1")
		{
			Value |= 0x01;
		}
	}
	dstr.sprintf("%x",Value);
	dstr=dstr.UpperCase();
	Edit_RW_VALUE->Text=dstr;
	return;
}

void  TForm_Main::Assign_BtnShow()
{
	int i=0;
	unsigned char Msb=StrToInt(Edit_RW_MSB->Text);
	unsigned char Lsb=StrToInt(Edit_RW_LSB->Text);
	for (i=0;i<16;i++)
	{
		if ((i>=Lsb )  && (i<=Msb))
			sbtnArray[i]->Enabled = true;
		else
			sbtnArray[i]->Enabled = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Edit_RW_MSBKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
         if (Key==13)
        {
         Assign_BtnShow();
        }
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Edit_RW_LSBKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
        if (Key==13)
        {
           Assign_BtnShow();
        }
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Edit_RW_MSBExit(TObject *Sender)
{
        Assign_BtnShow();
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Edit_RW_LSBExit(TObject *Sender)
{
        Assign_BtnShow();        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Edit_RW_VALUEKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
         if (Key==13)
        {
           Assign_DataToBtn();
        }
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Edit_RW_VALUEExit(TObject *Sender)
{
        Assign_DataToBtn();        
}
//---------------------------------------------------------------------------

int   TForm_Main::API_ReadThermalValue(unsigned long *Value)
{

        /*        if (pBluetoothModule->SetBBRegMaskBits(pBluetoothModule,0,0x1ba,15,0,0x800f) !=0)
                {
                        return -1;
                }

                if (pBluetoothModule->GetBBRegMaskBits(pBluetoothModule,0,0x1ba,13,9,Value) !=0 )
                {
                        return -1;
                }
         */
 	String dstr;
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;
     //	BT_CHIPINFO	        *pBTInfo=NULL;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}

	if (pBluetoothModule->ActionReport(pBluetoothModule,REPORT_THERMAL,pModuleBtReport) !=0)
	{
		dstr.sprintf(">>Get Thermal  is Fail...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}
	dstr.sprintf(">>Thermal=(%d) use SI\n",pModuleBtReport->CurrThermalValue ); Memo_msg->Lines->Add(dstr);



                return 0;
}
//---------------------------------------------------------------------------
int   TForm_Main::API_SetNewPowerValue(unsigned long Value)
{
     	pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x3C, 12, 12, 0);
	pBluetoothModule->SetBBRegMaskBits(pBluetoothModule, 0, 0x178, 15, 8, Value&0xFF);
	pBluetoothModule->SetBBRegMaskBits(pBluetoothModule, 0, 0x17A, 15, 0, 0x382);
        return 0;
}
//---------------------------------------------------------------------------
void __fastcall TForm_Main::BitBtn_TRXReadThermalClick(TObject *Sender)
{
                unsigned long newThermalValue=0;
                String dstr;


	        if (pBluetoothModule == NULL)
	        {
		        dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
                        return ;
	        }
                if (API_ReadThermalValue(&newThermalValue) !=0)
                {
                  Memo_msg->Lines->Add("Read Thermal Fail...");
                  return ;
                }

                return ;
}










void __fastcall TForm_Main::SpeedButton1Click(TObject *Sender)
{
	unsigned char  TxDacValue=0;
	API_ReadCurrentTxDacValue( &TxDacValue);

	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn1Click(TObject *Sender)
{
	unsigned char  TxDacValue=0;
	API_ReadCurrentTxDacValue( &TxDacValue);
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::EnableControlBTTxPowerIndex1Click(
      TObject *Sender)
{
	EnableControlBTTxPowerIndex1->Checked =!EnableControlBTTxPowerIndex1->Checked;
	if (EnableControlBTTxPowerIndex1->Checked)
	{
		Cbx_TxGainIndex->Enabled=true;
	}
}
//------CALLBACK----------------------------------------------------------------------
int TForm_Main::Verify_GetLastError(BT_VERIFY_PARMERTER *pCfoParamter)
{

     int error=0;
     String dstr;
     char Msg[][100] = {
     "The correction job is fail, please re-test!!",
     "The Offset correction process is succress.",
     "The Gold sample open fail ,please reconnect the SUT Device in PC...!!",
     "The DUT open failAPlease reconnect the DUT device and PC!!",
     };
     pCfoParamter->ParamterIndex = VERIFY_GET_LAST_ERROR;


     error =pBaseDLLObject->BTMPAPI_BluetoothVerify(pCfoParamter,NULL);

     dstr.sprintf("%s",Msg[error+1]);
     Form_Main->Memo_msg->Lines->Add(dstr);

     return error;

}
void __fastcall TForm_Main::BitBtn_CFO_BEGINClick(TObject *Sender)
{

        int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
        unsigned long Value;
        float cfo_kHz;
        String in_dstr;
        String dstr;
        DWORD t1,t2,t;
        int test_item=0;
        BT_VERIFY_PARMERTER btCfoParamter;
        BT_VERIFY_REPORT    btCfoReport;

        t1=GetTickCount();

        btCfoParamter.GoldSample_PortNumber= 1;

        btCfoParamter.ParamterIndex = VERIFY_TEST_BEGIN;

        btCfoParamter.InterfaceType = InterfaceType;
        btCfoParamter.PortNo= StrToInt(Cbx_Interface_port->Text);
        btCfoParamter.Baudrate =  BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
        btCfoParamter.pFunc =CFO_CALLBACK;
        if (FWExeJobMode1->Checked)
        {
           btCfoParamter.ExeMode = 1;

	}
        else
         btCfoParamter.ExeMode = 0;

        Label1_CFOResult->Caption="Testing....";
        Label1_CFOResult->Color =  clWhite;

        btCfoParamter.Test_XTAL = FALSE;
        if (CheckBox_CALXTAL->Checked)
        {
                Label_CFO_RET->Caption= "Begin Test....";
                btCfoParamter.Test_CALXTAL=TRUE;
                Label_CFO_RET->Update();
        }
        else
         btCfoParamter.Test_CALXTAL=FALSE;
        if (CheckBox_VERIFYTX->Checked)
        {
         Label_VERIFY_TX->Caption= "Begin Test....";
         btCfoParamter.Test_TX=TRUE ;
         Label_VERIFY_TX->Update();
        }
        else
        btCfoParamter.Test_TX=FALSE;

        if (CheckBox_VERIFYRX->Checked)
        {
         Label_VERIFY_RX->Caption= "Begin Test....";
         btCfoParamter.Test_RX=TRUE;
          Label_VERIFY_RX->Update();
        }
        else
        btCfoParamter.Test_RX=FALSE;

        in_dstr = Edit_CFO_IN->Text;
        if (in_dstr.Length() ==0)
        btCfoParamter.def_CFOVaule=0x00000000;
        else
        btCfoParamter.def_CFOVaule= StrToInt(in_dstr);

    //    Label_CFO_RET->Caption= "Begin Test....";
    //    Label_CFO_RET->Update();
        //Sleep(50);

        btCfoReport.mFloatData=0;  btCfoReport.CFO_Value =0;
       if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,&btCfoReport) != 0)
        {
            t2=GetTickCount();
            t=abs(t2-t1);
             if (CheckBox_CALXTAL->Checked)
            {
            dstr.sprintf("[Test ERROR]CFO = %f KHz CFO Value = 0x%x (Time= %d )",btCfoReport.mFloatData,btCfoReport.CFO_Value,t);
            Label_CFO_RET->Caption=  dstr;
            Form_Main->Memo_msg->Lines->Add(dstr);
            Verify_GetLastError(&btCfoParamter);
            }
            else
            {
                dstr.sprintf("[Test ERROR]Time= %d ",t);
                Verify_GetLastError(&btCfoParamter);
            }
        }
        else
        {

            t2=GetTickCount();
            t=abs(t2-t1);
            if (CheckBox_CALXTAL->Checked)
            {
                test_item=1;
                dstr.sprintf("CFO = %f KHz ,CFO Value = 0x%x (Time = %d )",btCfoReport.mFloatData,btCfoReport.CFO_Value,t);
                Form_Main->Memo_msg->Lines->Add(dstr);
                Label_CFO_RET->Caption= dstr;
                dstr.sprintf("0x%x",btCfoReport.CFO_Value);

                Edit_CFO->Text=dstr;
                int thIndex =  ComboBox_CFO_TH->ItemIndex;
                float thoffset=(float) ((thIndex+1)*5 );
                float getoffset =0;
                if (btCfoReport.mFloatData < 0)
                   getoffset = ((-1)*btCfoReport.mFloatData);
                else
                   getoffset = btCfoReport.mFloatData;
                if ( getoffset<=thoffset)
                { //pass
                  Label1_CFOResult->Caption="PASS";
                  Label1_CFOResult->Color = clLime;
                  if (CheckBox_CFO_NOCHANGE->Checked)
                  {
                          dstr.sprintf("Write CFO Value = 0x%x to k-default value",btCfoReport.CFO_Value);
                          Form_Main->Memo_msg->Lines->Add(dstr);
                          dstr.sprintf("0x%x",btCfoReport.CFO_Value);
                          Edit_CFO_IN->Text = dstr;
                  }
                  if (CheckBox_CFO_Efuse->Checked)
                  {
                        btCfoParamter.ParamterIndex = VERIFY_EFUSE_WRITE;
                        btCfoParamter.def_CFOVaule = btCfoReport.CFO_Value;


                        if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,NULL) != 0)
                        {
                                dstr.sprintf("[ERROR]Failed to Write Efuse CFO Value = 0x%x",btCfoReport.CFO_Value);
                                Form_Main->Memo_msg->Lines->Add(dstr);
                        }
                        else
                        {
                        dstr.sprintf("To Write Efuse CFO Value = 0x%x",btCfoReport.CFO_Value);
                        Form_Main->Memo_msg->Lines->Add(dstr);
                        }

                   }

                }
                else
                {
                 Label1_CFOResult->Caption="FAIL";
                 Label1_CFOResult->Color = clRed;
                }

            }

            if (CheckBox_VERIFYTX->Checked)
            {
              test_item=2;
              dstr.sprintf("rssi = %d , ber = %f", btCfoReport.VerifyTX_Rssi,btCfoReport.VerifyTX_ber);
              Label_VERIFY_TX->Caption= dstr;
            }
            if (CheckBox_VERIFYRX->Checked)
            {
               test_item=3;
               dstr.sprintf("rssi= %d , ber= %f, recv_bits=%d,err_bits =%d", btCfoReport.VerifyRX_Rssi,btCfoReport.VerifyRX_ber,btCfoReport.VerifyRX_bits,btCfoReport.VerifyRX_error_bits);
               Label_VERIFY_RX->Caption= dstr;
            }


            dstr.sprintf("Test End (Time = %d )",t);
            Form_Main->Memo_msg->Lines->Add(dstr);
        }

        if (test_item == 0)
        {

                 Label1_CFOResult->Caption="Ready ";
                 Label1_CFOResult->Color =  clWhite;

        }
        return ;

}
//---------------------------------------------------------------------------
void __fastcall TForm_Main::BitBtn_CFO_STOPClick(TObject *Sender)
{
	BT_VERIFY_PARMERTER btCfoParamter;

	btCfoParamter.ParamterIndex = VERIFY_TEST_STOP;

	pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,NULL);
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Page_functionChange(TObject *Sender)
{
        if (FormBTDebug_flag)
	{
          GroupBox3->Caption="Interface";
          return ;
        }
	Btn_Dev_Open->Visible =true;
	Btn_Dev_Close->Visible =true;

	GroupBox3->Caption="Interface";
	if (Page_function->ActivePage == TabSheet_CFO)
	{
		Btn_Dev_Open->Visible =false;
		Btn_Dev_Close->Visible =false;
		GroupBox3->Caption="DUT Interface";
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm_Main::BitBtn_CFO_EFUSEWRClick(TObject *Sender)
{
                unsigned long Value;
                String dstr;
                BT_VERIFY_PARMERTER btCfoParamter;
                int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
                btCfoParamter.InterfaceType = InterfaceType;
                btCfoParamter.PortNo= StrToInt(Cbx_Interface_port->Text);
                btCfoParamter.Baudrate =  BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
                btCfoParamter.pFunc =CFO_CALLBACK;
                btCfoParamter.ParamterIndex = VERIFY_EFUSE_WRITE;
                 dstr = Edit_CFO->Text;
                if (dstr.Length() ==0)
                {
                   Form_Main->Memo_msg->Lines->Add("Input Vaule is NULL!!");
                   return ;
                }
                Value = StrToInt(Edit_CFO->Text);
                btCfoParamter.def_CFOVaule = Value;

                if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,NULL) != 0)
                {
                        dstr.sprintf("[ERROR]Failed to Write Efuse CFO Value = 0x%x",Value);
                        Form_Main->Memo_msg->Lines->Add(dstr);
                }
                else
                {
                      dstr.sprintf("Write Efuse CFO Value = 0x%x",Value);
                      Form_Main->Memo_msg->Lines->Add(dstr);
                }
                return ;
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::BitBtn_CFO_REGWRClick(TObject *Sender)
{
                unsigned long Value;
                int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
                String dstr;
                BT_VERIFY_PARMERTER btCfoParamter;
                btCfoParamter.InterfaceType = InterfaceType;
                btCfoParamter.PortNo= StrToInt(Cbx_Interface_port->Text);
                btCfoParamter.Baudrate =  BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
                btCfoParamter.pFunc =CFO_CALLBACK;
                btCfoParamter.ParamterIndex = VERIFY_REG_WRITE;
                dstr = Edit_CFO->Text;
                if (dstr.Length() ==0)
                {
                   Form_Main->Memo_msg->Lines->Add("Input Vaule is NULL!!");
                   return ;
                }

                Value = StrToInt(Edit_CFO->Text);
                btCfoParamter.def_CFOVaule = Value;

                if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,NULL) != 0)
                {
                        dstr.sprintf("[ERROR]Failed to Write Efuse CFO Value = 0x%x",Value);
                        Form_Main->Memo_msg->Lines->Add(dstr);
                }
                else
                {
                      dstr.sprintf("Write Efuse CFO Value = 0x%x",Value);
                      Form_Main->Memo_msg->Lines->Add(dstr);
                }
                return ;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_CFO_REGRDClick(TObject *Sender)
{

                String dstr;
                BT_VERIFY_PARMERTER btCfoParamter;
                BT_VERIFY_REPORT    btCfoReport;
                int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
                btCfoParamter.InterfaceType = InterfaceType;
                btCfoParamter.PortNo= StrToInt(Cbx_Interface_port->Text);
                btCfoParamter.Baudrate =  BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
                btCfoParamter.pFunc =CFO_CALLBACK;
                btCfoParamter.ParamterIndex = VERIFY_REG_READ;

                if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,&btCfoReport) != 0)
                {
                        dstr.sprintf("[ERROR]Failed to Read Xtal CFO Value...");
                        Form_Main->Memo_msg->Lines->Add(dstr);

                }
                else
                {
                      dstr.sprintf("Read Xtal CFO Value = 0x%x",btCfoReport.CFO_Value);
                      Form_Main->Memo_msg->Lines->Add(dstr);
                      dstr.sprintf("0x%x",btCfoReport.CFO_Value);
                      Edit_CFO->Text = dstr;
                }
                return ;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_CFO_EFUSERDClick(TObject *Sender)
{

                String dstr;
                BT_VERIFY_PARMERTER btCfoParamter;
                int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
                BT_VERIFY_REPORT    btCfoReport;
                btCfoParamter.InterfaceType = InterfaceType;
                btCfoParamter.PortNo= StrToInt(Cbx_Interface_port->Text);
                btCfoParamter.Baudrate =  BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];
                btCfoParamter.pFunc =CFO_CALLBACK;
                btCfoParamter.ParamterIndex = VERIFY_EFUSE_READ;
                 if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,&btCfoReport) != 0)
                {
                        dstr.sprintf("[ERROR]Failed to Read EFUSE Xtal CFO Value....");
                        Form_Main->Memo_msg->Lines->Add(dstr);
                }
                else
                {
                       dstr.sprintf("Read Efuse CFO Value = 0x%x",btCfoReport.CFO_Value);
                       Form_Main->Memo_msg->Lines->Add(dstr);
                       dstr.sprintf("0x%x",btCfoReport.CFO_Value);
                       Edit_CFO->Text=  dstr;
                }
                return ;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_GETCFOClick(TObject *Sender)
{

	int BarudRate_Arrary[]={9600,115200,921600,1500000,3000000,4000000};
	unsigned long Value;
	float cfo_kHz;
	String dstr;
	BT_VERIFY_PARMERTER btCfoParamter;
	BT_VERIFY_REPORT    btCfoReport;

	btCfoParamter.GoldSample_PortNumber= 1;

	btCfoParamter.ParamterIndex = VERIFY_GET_CFOVALUE;

	btCfoParamter.InterfaceType = InterfaceType;
	btCfoParamter.PortNo= StrToInt(Cbx_Interface_port->Text);
	btCfoParamter.Baudrate =  BarudRate_Arrary[Cbx_Interface_baudrate->ItemIndex ];

	btCfoParamter.def_CFOVaule= StrToInt(Edit_CFO->Text);
	btCfoParamter.Test_XTAL = TRUE;
	btCfoParamter.Test_CALXTAL=FALSE;
	btCfoParamter.Test_TX=FALSE;
	btCfoParamter.Test_RX=FALSE;

	Label_CFO_RET->Caption= "Begin Test....";
	Label_CFO_RET->Update();
	Sleep(50);
	if (pBaseDLLObject->BTMPAPI_BluetoothVerify(&btCfoParamter,&btCfoReport) != 0)
	{
		dstr.sprintf("[ERROR]CFO = %f KHz CFO Value = 0x%x",btCfoReport.mFloatData,btCfoReport.CFO_Value);
		Label_CFO_RET->Caption=  dstr;
		Form_Main->Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf("CFO = %f KHz ",btCfoReport.mFloatData);
		Form_Main->Memo_msg->Lines->Add(dstr);
		Label_CFO_RET->Caption= dstr;
	}

	return;

}
//---------------------------------------------------------------------------

int CFO_CALLBACK(BT_VERIFY_REPORT *pReport)
{
	String dstr;
	int index = pReport->pData[0];
	switch(index)
	{
	case 1: //CFO
		if (Form_Main->InterfaceType == TYPE_BUMBLE_BEE_USB)
		{
			dstr.sprintf("HOSCI_BC_SEL = 0x%x ,HOSCI_TC_SEL =0x%x ==>%f ",pReport->pData[1],pReport->pData[2],pReport->mFloatData) ;
		}
		else
		{
			dstr.sprintf("xtal = 0x%x  ==>%f ",pReport->pData[2],pReport->mFloatData) ;
		}
	break;
	
	case 2: //TX
		dstr.sprintf("Rssi = %d Bits = %d ErrorBits = %d  ",pReport->Rssii,pReport->pData[2],pReport->pData[4]) ;
		Form_Main->Label_VERIFY_TX->Caption=dstr;
		dstr ="Tx Test -->"+dstr;
	break;
	
	case 3: //RX
		dstr.sprintf("Rssi = %d Bits = %d ErrorBits = %d ber = %f ",pReport->Rssii,pReport->pData[2],pReport->pData[4],pReport->ber) ;
		Form_Main->Label_VERIFY_RX->Caption=dstr;
		dstr ="Rx Test -->"+dstr;
	break;
	}

	if (dstr.Length() ==0)
		return 0;
       
	Form_Main->Memo_msg->Lines->Add(dstr);
	Form_Main->Memo_msg->Update();

	return 0;
}

void __fastcall TForm_Main::CFOPage1Click(TObject *Sender)
{
	CFOPage1->Checked= !CFOPage1->Checked;
	if (CFOPage1->Checked)
	{
		TabSheet_CFO->TabVisible= true;
	}
	else
	{
		TabSheet_CFO->TabVisible= false;
	}
}
//---------------------------------------------------------------------------

void TForm_Main::DebugCFOUI()
{
	if (Debug2->Checked)
	{
		BitBtn_CFO_REGWR->Visible = true;
		BitBtn_CFO_REGRD->Visible = true;
		BitBtn_CFO_EFUSEWR->Visible = true;
		BitBtn_CFO_EFUSERD->Visible = true;
		BitBtn_GETCFO->Visible=true;
	}
	else
	{
		BitBtn_CFO_REGWR->Visible = false;
		BitBtn_CFO_REGRD->Visible = false;
		BitBtn_CFO_EFUSEWR->Visible = false;
		BitBtn_CFO_EFUSERD->Visible = false;
		BitBtn_GETCFO->Visible= false;
	}

	if (DebugRFProgram1->Checked )
	{
		TabSheet_NONLINK->TabVisible =false;

		TabSheet_Hopping->TabVisible =false;
		TabSheet_RW->TabVisible =false;
		TabSheet_LETest->TabVisible =false;

		Page_function->ActivePage = TabSheet_CFO;
		Cbx_Interface->Enabled=false;
		Image1->Left = 488;

	}
	else
	{
		TabSheet_NONLINK->TabVisible =true;

		TabSheet_Hopping->TabVisible =true;
		TabSheet_RW->TabVisible =true;
		TabSheet_LETest->TabVisible =true;
		Cbx_Interface->Enabled=true;
		Image1->Left = 568;
	}
	TObject *Sender;
	Page_functionChange(Sender);
	return;
}

void __fastcall TForm_Main::Debug2Click(TObject *Sender)
{
	Debug2->Checked = !Debug2->Checked ;
	DebugCFOUI();
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::DebugRFProgram1Click(TObject *Sender)
{
	DebugRFProgram1->Checked = !DebugRFProgram1->Checked;
	DebugCFOUI();
}
//---------------------------------------------------------------------------
//
//   Matlab  call BTAPP  Begin
//
//---------------------------------------------------------------------------
enum MPCOMMAND_TAG{
       BT_MP_REGRW =0,
       BT_MP_HCICOMMAND,
       BT_MP_REPORT,
       BT_MP_EXEC,
       BT_MP_SETPARAM,
       BT_MP_GETPARAM,
       RTLBTMP,
       BT_MP_RECVEVT,
  //     BT_MP_DEVICE_DISABLE,
       ///////////
       NUMBEROFMPCOMMAND

};
enum  MPREGTYPE_TAG{
       BT_MP_REG_MODEM=0,
       BT_MP_REG_RF,
       BT_MP_REG_SYS,
       BT_MP_REG_BB
};
#define BT_MP_REG_WRITE 1
#define BT_MP_REG_READ  0

typedef struct   _BTREG_Offset_struct_{
       UINT16   page_16b;
       UINT16   addr_16b;
}BTREG_Offset_struct;

union  BTREG_Offset{
       BTREG_Offset_struct   addr_32b;
       UINT32   BTREG_Offset_32b;
};

typedef struct  _MEX_MP_BTREG{
       UINT8   id_8b;
       UINT8   rw_8b;
       BTREG_Offset  Offset_32b;
       UINT8   msb_8b;
       UINT8   lsb_8b;
       UINT16  data_16b;
}MEX_MP_BTREG;
typedef struct  _MEX_MP_BTDEVICECTRL{
       UINT8   InterfaceType;
       UINT8   Actions;
       UINT8   Port;
       UINT16  Baudrate;

}MEX_MP_BTDEVICECTRL;
#define MAX_MEX_BUF_LEN     512
#define MAX_MEX_MP_CMD_SIZE 50
char szMPCommand[NUMBEROFMPCOMMAND][MAX_MEX_MP_CMD_SIZE]={
      "bt_mp_regrw",          //
      "bt_mp_hcicmd",
      "bt_mp_report",
      "bt_mp_exec",
      "bt_mp_setparam",
      "bt_mp_getparam",
      "rtlbtmp",
      "bt_mp_RecvEvt"
};
int TForm_Main::api_tcpip_bt_mp_Exec_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen)
{
       int rtn =0;
	BT_PARAMETER 	*pParam=&mBT_PARAMETER;
	String dstr;      
       UINT8  pbuf[MAX_MEX_BUF_LEN];
       int  buf_len=0;
       UINT8    Actions=0xFF;


       DBGPRINTF("+ api_tcpip_bt_mp_Exec_process() \n");
       *pRtnLen=0;

       memset(pbuf,0,sizeof(UINT8)*MAX_MEX_BUF_LEN);

       if (api_parse_str2buf(pcmd,pbuf,&buf_len) !=0)
       {
           goto exit;
       }
       Actions = pbuf[0];

       DBGPRINTF("Actions = %d \n",Actions );
        //---------------------------------------------
       //call process
       //---------------------------------------------

	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return -1;
	}
	pParam->ParameterIndex = Actions;
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		rtn= -1;
                goto exit;
	}
        rtn=0;

exit:
       pRtn[0] = rtn;
       DBGPRINTF("- api_tcpip_bt_mp_Exec_process(%x) \n",rtn);
       return rtn;

}
int TForm_Main::api_tcpip_bt_mp_rtlbtmp_enable_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen)
{
       int rtn =0;
       UINT8  pbuf[MAX_MEX_BUF_LEN];

     //  UINT16   Type =0;
       UINT8    Port=0;
       UINT32   Baudrate=0;
       char     szType[50];
       char     szmode[50];
       String   dstr;
       char     *dest= NULL;
    //   char     *sour=NULL;

       DBGPRINTF("+ api_tcpip_bt_mp_rtlbtmp_enable_process() \n");
       *pRtnLen=0;

  //     dstr.sprintf("");

       memset(szType,0,50);
       memset(szmode,0,50);
       dest = pcmd;

       while(*dest)
       {
          if ((*dest == ',') || (*dest == ':'))
          {
              *dest=' ';
          }
          *dest++;
       }
       sscanf(pcmd,"%s %s %d %d",szmode,szType,&Port,&Baudrate);

       if (strncmp(szmode,"enable",strlen("enable")) ==0)
       {
          DBGPRINTF(">> to enable the Device\n");
          DBGPRINTF(">> Type = %s  port= %d , baudrate = %d\n",szType,Port,Baudrate);
          if (strncmp(szType,"usb",strlen("usb")) ==0)
          {
                //---------------------------------------------
                //call process
                //---------------------------------------------
                Cbx_Interface->ItemIndex =TYPE_USB;

          }
          else if (strncmp(szType,"uart",strlen("uart")) ==0)
          {
       //---------------------------------------------
       //call process
       //---------------------------------------------
                Cbx_Interface->ItemIndex =TYPE_UART;
          }
          else
          {
           rtn=-1;
           goto exit;
          }
                TObject *Sender;
                Cbx_InterfaceChange(Sender);
                rtn=OpenDevice();
                if (rtn !=0)
                {
                   goto exit;
                }

       }
       else if (strncmp(szmode,"disable",strlen("disable")) ==0)
       {
          DBGPRINTF(">> to Disable the Device\n");
       //---------------------------------------------
       //call process
       //---------------------------------------------
          CloseDevice();
       }
       else
       {
          rtn=-1;
          goto exit;
       }

       rtn=0;

exit:
       pRtn[0]=rtn;
       *pRtnLen=1;
       DBGPRINTF("- api_tcpip_bt_mp_rtlbtmp_enable_process(%x) \n",rtn);
       return rtn;

}
int TForm_Main::api_tcpip_bt_mp_HciCmd_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen)
{
       int rtn =0;
       UINT8  pbuf[MAX_MEX_BUF_LEN];
       int  buf_len=0;
       UINT16   OpCode =0;
       UINT16    para_len=0;
       UINT16   EVT_length=0;
       UINT8    para[MAX_MEX_BUF_LEN];
       unsigned char pEvtBuf[512];
       DBGPRINTF("+ api_tcpip_bt_mp_HciCmd_process() \n");

       memset(pbuf,0,sizeof(UINT8)*MAX_MEX_BUF_LEN);
       memset(para,0,sizeof(UINT8)*MAX_MEX_BUF_LEN);
       memset(pEvtBuf,0,512);
       *pRtnLen =0;
       if (api_parse_str2buf(pcmd,pbuf,&buf_len) !=0)
       {

          goto exit;
       }
       OpCode =  (pbuf[1]<<8) + pbuf[0];
       para_len= pbuf[2];
       if (para_len > MAX_MEX_BUF_LEN)
          para_len = MAX_MEX_BUF_LEN;

       memcpy(para,&pbuf[3],para_len);
       DBGPRINTF(">>OpCode = 0x%x  , para_len = %d para[] = %x %x %x %x %x %x %x %x \n",OpCode,para_len,para[0],para[1],para[2],para[3],para[4],para[5],para[6],para[7] );
       //---------------------------------------------
       //call process
      //	String dstr;

    //	unsigned char pData[512];


	if(pBluetoothModule == NULL)
	{
	     //	dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
                DBGPRINTF(">>[ERROR]OpCode = 0x%x  , para_len = %d para[] = %x %x %x %x %x %x %x %x \n",OpCode,para_len,para[0],para[1],para[2],para[3],para[4],para[5],para[6],para[7] );
                DBGPRINTF(">>[ERROR]BluetoothModule is NULL...!!\n");
		rtn=-1;
                goto exit;
	}

	rtn=pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, OpCode, para_len, para, 0x0E, pEvtBuf);

	if((pEvtBuf[5] != 0) || (rtn !=0))
	{
	       //	dstr.sprintf("Led Set : ERROR !!\n");Memo_msg->Lines->Add(dstr);
                   DBGPRINTF(">>[ERROR]OpCode = 0x%x  , para_len = %d para[] = %x %x %x %x %x %x %x %x  is Error!!(Status !=0)\n",OpCode,para_len,para[0],para[1],para[2],para[3],para[4],para[5],para[6],para[7] );
                   rtn=-1;
                   goto exit;
	}
        else
        {
                DBGPRINTF(">>OpCode = 0x%x  , para_len = %d para[] = %x %x %x %x %x %x %x %x \n",OpCode,para_len,para[0],para[1],para[2],para[3],para[4],para[5],para[6],para[7] );
               // dstr.sprintf("Led Set : Success !!\n");Memo_msg->Lines->Add(dstr);
                DBGPRINTF("EVT[]= %x %x %x %x %x %x %x %x %x %x %x %x %x  \n",pEvtBuf[0],pEvtBuf[1],pEvtBuf[2],pEvtBuf[3],pEvtBuf[4],pEvtBuf[5],pEvtBuf[6],pEvtBuf[7],pEvtBuf[8],pEvtBuf[9],pEvtBuf[10],pEvtBuf[11],pEvtBuf[12]);
        }
        //---------------------------------------------
       rtn=0;
       EVT_length = pEvtBuf[1]+1;
       if (EVT_length > 255 )
           EVT_length = 255;
       memcpy(&pRtn[0],pEvtBuf,EVT_length);
       *pRtnLen = EVT_length;
exit:
    //   pRtn[0] = rtn;
       DBGPRINTF("- api_tcpip_bt_mp_HciCmd_process(%x) \n",rtn);
       return rtn;
}
int TForm_Main::api_tcpip_bt_mp_parse_data(char *psur,ULONG *data,int max_dataNumber,int *dataNum,char *pdesc)
{
          int n=0;
          String dstr,tmpstr;
          int end=0;
          int pos=0;
          int rtn=0;
          tmpstr.printf ("%s",psur);
          tmpstr=StringReplace(tmpstr," ","",TReplaceFlags()<<rfReplaceAll);
          tmpstr=StringReplace(tmpstr,"\n","",TReplaceFlags()<<rfReplaceAll);
          tmpstr=StringReplace(tmpstr,"\0","",TReplaceFlags()<<rfReplaceAll);
          memset(data,0,sizeof(ULONG)*max_dataNumber);
          *dataNum=0;
          while(tmpstr.Length() >0)
          {
               pos=tmpstr.Pos(",");
               if (pos <=0)
               {
                 dstr= tmpstr;
                 end=1;
               }
               else
              {
              dstr=tmpstr.SubString(0,pos-1);
              }
               dstr=StringReplace(dstr,";","",TReplaceFlags()<<rfReplaceAll);
              if (dstr.Length()<=0)
                  break;
               if (n >=max_dataNumber)
                  break;

               data[n]= StrToInt(dstr);
               tmpstr = tmpstr.SubString(pos+1,tmpstr.Length());
               n++;

               if (end)
               break;

          }
          *dataNum = n;
          if (pdesc != NULL)
          {
            memcpy(pdesc,tmpstr.c_str(),tmpstr.Length());
          }
          rtn=0;
exit:
          return rtn;
}
int TForm_Main::api_tcpip_bt_mp_RegRW_process(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen)
{
       int rtn =-1,Buf_Num;
       ULONG pBuf[10];
       char  pdesc[MAX_MEX_BUF_LEN];
       int Page = 0;
	unsigned long RegStartAddr=0;
	unsigned char Msb=0;
	unsigned char Lsb=0;
	unsigned long Value = 0;
        UINT8 id_8b=0,rw_8b=0;


       DBGPRINTF("+ api_tcpip_bt_mp_RegRW_process() \n");
       *pRtnLen=0;
       memset(pBuf,0,sizeof(ULONG)*10);
       if (api_tcpip_bt_mp_parse_data(pcmd,pBuf,10,&Buf_Num,NULL) !=0)
       {

          rtn=-1;
          goto exit;
       }
       rtn=0;
       id_8b = pBuf[0];
       rw_8b=  pBuf[1];
       RegStartAddr =pBuf[2] ;
       Msb = pBuf [3];
       Lsb =pBuf [4] ;
       Value = pBuf[5];

      if (BT_MP_REG_WRITE ==rw_8b)
       { //write
        switch(id_8b)
        {
        case BT_MP_REG_MODEM:
                if ((Msb > 15) || (Msb < Lsb) )
                {
                  rtn=-1;
                  goto exit;

                }
            DBGPRINTF("reg[MD][w]0x%x[%d:%d]=0x%x",RegStartAddr,Msb,Lsb,Value );
            rtn=pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
        break;
        case BT_MP_REG_RF:
                if ((Msb > 15) || (Msb < Lsb) )
                {
                  rtn=-1;
                  goto exit;

                }
             DBGPRINTF("reg[RF][w]0x%x[%d:%d]=0x%x",RegStartAddr,Msb,Lsb,Value );
            rtn = pBluetoothModule->SetRfRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
        break;

        case BT_MP_REG_SYS:
                if ((Msb > 15) || (Msb < Lsb) )
                {
                  rtn=-1;
                  goto exit;

                }
             DBGPRINTF("reg[SY][w]0x%x[%d:%d]=0x%x",RegStartAddr,Msb,Lsb,Value );
                rtn=pBluetoothModule->SetSysRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,Value);
        break;
        case BT_MP_REG_BB:
                Page = pBuf[2];
                RegStartAddr =pBuf[3] ;
                Msb = pBuf [4];
                Lsb =pBuf [5] ;
                Value = pBuf[6];
                 if ((Msb > 15) || (Msb < Lsb) || (Page > 15) )
                {
                  rtn=-1;
                  goto exit;

                }                
             DBGPRINTF("reg[BB][w] page =%d,0x%x[%d:%d]=0x%x",Page,RegStartAddr,Msb,Lsb,Value );
             rtn=pBluetoothModule->SetBBRegMaskBits(pBluetoothModule,Page,RegStartAddr,Msb,Lsb,Value);
        break;
        default :
            DBGPRINTF("[ERR]no match  registe id ...");
                rtn = -1;
        }
         if (rtn !=0)
          goto exit;
       }
       else
       {//read
        Value=0;
        switch(id_8b)
        {

        case BT_MP_REG_MODEM:
                 if ((Msb > 15) || (Msb < Lsb) )
                {
                  rtn=-1;
                  goto exit;

                }
                rtn=pBluetoothModule->GetMdRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,&Value);
                DBGPRINTF("reg[MD][R]0x%x[%d:%d]=0x%x(%x)",RegStartAddr,Msb,Lsb,Value,rtn);
        break;
        case BT_MP_REG_RF:
                if ((Msb > 15) || (Msb < Lsb) )
                {
                  rtn=-1;
                  goto exit;

                }
                rtn = pBluetoothModule->GetRfRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,&Value);
                DBGPRINTF("reg[RF][R]0x%x[%d:%d]=0x%x(%x)",RegStartAddr,Msb,Lsb,Value,rtn);
        break;

        case BT_MP_REG_SYS:
                if ((Msb > 15) || (Msb < Lsb) )
                {
                  rtn=-1;
                  goto exit;

                }
                rtn=pBluetoothModule->GetSysRegMaskBits(pBluetoothModule,RegStartAddr,Msb,Lsb,&Value);
                DBGPRINTF("reg[SY][R]0x%x[%d:%d]=0x%x(%x)",RegStartAddr,Msb,Lsb,Value,rtn);
        break;
        case BT_MP_REG_BB:
                Page = pBuf[2];
                RegStartAddr =pBuf[3] ;
                Msb = pBuf [4];
                Lsb =pBuf [5] ;
                 if ((Msb > 15) || (Msb < Lsb) || (Page > 15) )
                {
                  rtn=-1;
                  goto exit;

                }
            //    pBluetoothModule->RecvAnyHciEvent
                rtn=pBluetoothModule->GetBBRegMaskBits(pBluetoothModule,Page,RegStartAddr,Msb,Lsb,&Value);
                DBGPRINTF("reg[BB][R] Page =%d,0x%x[%d:%d]=0x%x(%x)",Page,RegStartAddr,Msb,Lsb,Value,rtn);
        break;
        default :
                rtn = -1;
        }



       }

       //---------------------------------------------
         if (rtn !=0)
           goto exit;       
        //assign tje return data
        pRtn[0] = Value & 0xFF;
        pRtn[1] = (Value>>8) & 0xFF;
        *pRtnLen=2;
        rtn=0;
exit:
      // pRtn[0] = rtn;

       DBGPRINTF("- api_tcpip_bt_mp_RegRW_process(%x) \n",rtn);
       return rtn;

}
int TForm_Main::api_parse_str2buf(char *parse_str,char *pbuf,int *pbuf_len)
{
        int rtn=0;
        char *pch;
        char *p;
        String tmpstr;
        int  pLen=0;
        int  size =0;
        int  n=0;
        UINT32  max_value;
        p= parse_str;
        pch = strtok(p,",");

        while (pch != NULL)
        {


                tmpstr.printf ("%s",pch);
                tmpstr=StringReplace(tmpstr," ","",TReplaceFlags()<<rfReplaceAll);
                tmpstr=StringReplace(tmpstr,"\n","",TReplaceFlags()<<rfReplaceAll);
                tmpstr=StringReplace(tmpstr,"\0","",TReplaceFlags()<<rfReplaceAll);
             //   if ( tmpstr.SubString(0,2) != "0x")
             //   {
             //      tmpstr= "0x"+tmpstr;
              //  }
                max_value =StrToInt(tmpstr);
                if (max_value <=0xFF ){
                 size=1;
                }else if (max_value <=0xFFFF ){
                 size=2;
                }else{
                 size=4;
                }
                for (n=0;n<size;n++)
                {
                    pbuf[pLen] =  ((max_value>>(n*8))&0xFF);
                    pLen++;
                }


                if (pLen > MAX_MEX_BUF_LEN)
                        goto exit;

                pch = strtok (NULL, ",");
        }
exit:
       *pbuf_len =  pLen;
       if (pLen ==0)
        rtn = -1;

       return rtn;


}
int TForm_Main::api_tcpip_bt_mp_RecvEvtprocess(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen)
{
        int rtn =0;
    DBGPRINTF("+ api_tcpip_bt_mp_RecvEvtprocess() \n");
    rtn=pBluetoothModule->RecvAnyHciEvent(pBluetoothModule,pRtn);
    if (rtn !=0)
      *pRtnLen =255;
    else
       *pRtnLen=0;
         
exit:
    DBGPRINTF("- api_tcpip_bt_mp_RecvEvtprocess(%x) \n",rtn);
 return rtn;

}
int TForm_Main::api_process_tcpip_command(char *pcmd, int Index,UINT8 *pRtn,UINT16 *pRtnLen)
{
       int rtn =0;
       switch (Index)
       {

       case BT_MP_REGRW:      rtn = api_tcpip_bt_mp_RegRW_process(pcmd,pRtn,pRtnLen);  break;
       case BT_MP_HCICOMMAND: rtn = api_tcpip_bt_mp_HciCmd_process(pcmd,pRtn,pRtnLen);  break;
     //  case BT_MP_REPORT:       break;
       case BT_MP_EXEC:       rtn = api_tcpip_bt_mp_Exec_process(pcmd,pRtn,pRtnLen);  break;
     //  case BT_MP_SETPARAM:     break;
     //  case BT_MP_GETPARAM:     break;
       case RTLBTMP:     rtn=api_tcpip_bt_mp_rtlbtmp_enable_process(pcmd,pRtn,pRtnLen);break;
       case BT_MP_RECVEVT : rtn = api_tcpip_bt_mp_RecvEvtprocess(pcmd,pRtn,pRtnLen);   break;
       default:
            DBGPRINTF("No support the cmd  = %s \n",pcmd);
            rtn =-1;
       }
exit:
      return rtn;
}
int TForm_Main::api_parse_tcpip_command(char *pcmd,UINT8 *pRtn,UINT16 *pRtnLen)
{
  int n=0;
  int Cmd_Index=-1;
  int cmd_length=0;
  int rtn =-1;
  if (pcmd == NULL)
  {
     DBGPRINTF("tcpip_cmd is NULL!!\n");
     goto exit;
  }
  cmd_length = strlen(pcmd);
  if (cmd_length <= 0)
  {
     DBGPRINTF("tcpip_cmd length is  zero!!\n");
     goto exit;
  }
  DBGPRINTF("tcpip_cmd  = %s length =%d  \n",pcmd,cmd_length);
  Cmd_Index=-1;
  // parse the string
   if ((pcmd[0] == '%') || ((pcmd[0] == '/')&& (pcmd[1] == '/')))
   {
        DBGPRINTF("is bypass tcpip_cmd is %s(%d) \n",cmd_length);
        goto exit;
   }
   for (n=0;n<NUMBEROFMPCOMMAND;n++)
   {
        if (strncmp(szMPCommand[n],pcmd,strlen(szMPCommand[n])) == 0)
        {
               Cmd_Index=n;
               break;
        }

   }
   if (Cmd_Index < 0)
   {
      DBGPRINTF("tcpip_cmd is %s(%d)  no match mp command!!\n",pcmd,cmd_length);
      goto exit;
   }
   DBGPRINTF("tcpip_cmd is %s(%d) , Index = %d \n",szMPCommand[n],cmd_length,n);


   if (api_process_tcpip_command(&pcmd[strlen(szMPCommand[n])], Cmd_Index,pRtn,pRtnLen) !=0)
   {

     goto exit;
   }
   rtn=0;
exit:
     return  rtn;
 
}
//---------------------------------------------------------------------------
//
//   Matlab  call BTAPP  End
//
//---------------------------------------------------------------------------







#define RTNBUFFER_RTN    4
#define RTNBUFFER_SIZE  256+RTNBUFFER_RTN




void __fastcall TForm_Main::FWExeJobMode1Click(TObject *Sender)
{
        FWExeJobMode1->Checked != FWExeJobMode1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Internet1Click(TObject *Sender)
{
        String  dstr;
        Internet1->Checked = !Internet1->Checked;
         if (Internet1->Checked)
         {
              TabSheet_LED->Caption="LED/TCPIP"  ;
              api_tcpip_GetHostNameAndIPAddress();
              dstr.sprintf(">>Host Server is enable...");
              ServerSocket1->Active=true;
         }
         else
         {
               TabSheet_LED->Caption="LED"  ;
               dstr.sprintf(">>Host Server is disable...");
               ServerSocket1->Active=false;
         }
         Memo_msg->Lines->Add(dstr);
         return ;
}
//---------------------------------------------------------------------------
void TForm_Main::api_tcpip_GetHostNameAndIPAddress()
{
        WORD   wVersionRequested;
        String dstr;
        WSADATA   wsaData;
        wVersionRequested   =   MAKEWORD(1,   1);
        WSAStartup(wVersionRequested,   &wsaData);
        hostent   *host;
        char   hostname[80];
        char   *ipaddress;
        gethostname(hostname,   80);
        host   =   gethostbyname(hostname);
        ipaddress   =   inet_ntoa(*((in_addr   *)host-> h_addr));
        Label14-> Caption=ipaddress;

        GroupBox4-> Caption   =hostname   ;
        dstr.sprintf(">>HostName:%s",hostname);
        Memo_msg->Lines->Add(dstr);
        dstr.sprintf(">>HostIP:%s",ipaddress);
        Memo_msg->Lines->Add(dstr);
    //    dstr.sprintf(">>Control Port:%d",ServerSocket_BTMPAPP->Port);
    //    Memo_msg->Lines->Add(dstr);
        WSACleanup();
        return ;
}
//---------------------------------------------------------------------------
void __fastcall TForm_Main::GetIPHostName1Click(TObject *Sender)
{
        api_tcpip_GetHostNameAndIPAddress();        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ServerSocket1Accept(TObject *Sender,
      TCustomWinSocket *Socket)
{

    String dstr;
  //  int Port= Socket->RemotePort;

    dstr.sprintf(">>[TCPIP]RTKBTMPAPP Accept...Addr = %s ,Port = %d\n",Socket->LocalAddress,Socket->LocalPort );
   // DBGPRINTF(">>[TCPIP]ServerSocket RTKBTMPAPP Accept...Port = %d\n",Port );
    Memo_msg->Lines->Add(dstr);
    return ;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ServerSocket1ClientConnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
            String dstr;
            dstr.sprintf(">>[TCPIP]RTKBTMPAPP->ClientConnect...Addr = %s ,Port = %d\n",Socket->LocalAddress,Socket->LocalPort );
          // DBGPRINTF(">>[TCPIP]ServerSocket RTKBTMPAPP->ClientConnect...\n")  ;
          Memo_msg->Lines->Add(dstr);
          
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ServerSocket1ClientDisconnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
         String dstr;
        // DBGPRINTF(">>[TCPIP]ServerSocket RTKBTMPAPP -->ClientDisconnect...")  ;
          dstr.sprintf(">>[TCPIP]RTKBTMPAPP -->ClientDisconnect...")  ;
         Memo_msg->Lines->Add(dstr);
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ServerSocket1ClientRead(TObject *Sender,
      TCustomWinSocket *Socket)
{
 String dstr;
 UINT16 Rtn_Len =0;
 UINT8  Rtnbuf[RTNBUFFER_SIZE];
 //DBGPRINTF(">>[TCPIP]RTKBTMPAPP ClientRead<--%s",sRecv)  ;
 AnsiString sRecv =  Socket->ReceiveText();
 dstr.sprintf(">>[TCPIP]RTKBTMPAPP ClientRead<--%s",sRecv)  ;
 Memo_msg->Lines->Add(dstr);
 sRecv =  sRecv.LowerCase();
 memset(Rtnbuf,0,RTNBUFFER_SIZE);
 if (api_parse_tcpip_command(sRecv.c_str(),&Rtnbuf[RTNBUFFER_RTN],&Rtn_Len) !=0)
  {
       //Socket->SendText("NAK");      //Fail

      // Socket->SendBuf(Rtnbuf);

     Rtnbuf[0] = 0xFF;
     Rtnbuf[1] = 0x00;
     Rtnbuf[2] = 0x00;
     Rtnbuf[3] = 0xFF;

     Rtn_Len =4;

  }
 else
  {
     Rtnbuf[0] =0x00;
     Rtnbuf[1] =Rtn_Len & 0xFF;
     Rtnbuf[2] =(Rtn_Len>>8) & 0xFF;
     Rtnbuf[3] =0x00;

     Rtn_Len += 4;

   }
   Socket->SendBuf(Rtnbuf,Rtn_Len);

   return ;

}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn_SendTcpipClick(TObject *Sender)
{
  String dstr,astr;
  UINT16 Rtn_Len =0;
  int n=0;
  UINT8  Rtnbuf[RTNBUFFER_SIZE];
  memset(Rtnbuf,0,RTNBUFFER_SIZE);
   if (api_parse_tcpip_command(Edit_tcpip->Text.c_str(),&Rtnbuf[RTNBUFFER_RTN],&Rtn_Len) !=0)
  {
     Rtnbuf[0] = 0xFF;
     Rtnbuf[1] = 0x00;
     Rtnbuf[2] = 0x00;
     Rtnbuf[3] = 0xFF;

     Rtn_Len =4;

  }
 else
  {
     Rtnbuf[0] =0x00;
     Rtnbuf[1] =Rtn_Len & 0xFF;
     Rtnbuf[2] =(Rtn_Len>>8) & 0xFF;
     Rtnbuf[3] =0x00;

     Rtn_Len += 4;

   }
  dstr.sprintf("[%x %x %x %x]",Rtnbuf[0],Rtnbuf[1],Rtnbuf[2],Rtnbuf[3]);
  for (n=0;n<Rtn_Len;n++);
  {
    astr.sprintf(",%x",Rtnbuf[4+n]);
    dstr+=astr;
  }
  Memo_msg->Lines->Add(dstr);
  return ;
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
void TForm_Main::api_tcpip_bt_mp_InitDefaultParameter()
{

  	BT_PARAMETER *pParam=&tcpip_mBT_PARAMETER;

	pParam->mChannelNumber = Cbx_NoLink_Ch->ItemIndex;
	pParam->mPacketType = Cbx_PktType->ItemIndex;
	pParam->mPayloadType = Cbx_PayloadType->ItemIndex;
	pParam->mTxPacketCount = StrToInt(Edit_PktCount->Text);
	pParam->mTxGainIndex = StrToInt(Cbx_TxGainIndex->ItemIndex);
	pParam->mPacketHeader = StrToInt(Edit_PktHeader->Text);
	pParam->mTxDAC = StrToInt(Cbx_TxDacIndex->Text);
	if(CheckBox_WhiteningEnable->Checked == true)
	{
		pParam->mWhiteningCoeffValue = 0x7f;
	}
	else
	{
		pParam->mWhiteningCoeffValue = 0x80;
	}
	//hit address
        pParam->mHitTarget= StrToInt64(ComboBox_HitAddr->Text);

        return ;

}

//---------------------------------------------------------------------------

void __fastcall TForm_Main::Cbx_PktTypeChange(TObject *Sender)
{
        String dstr;
	BT_CHIPINFO	        *pBTInfo=&mBT_CHIPINFO;
        int PacketHeader[] = {0x33820, 0x39858, 0xA078, 0x33820, 0xC050, 0x3F870, 0x15C40, 0x39858, 0xA078};

	if(pBTInfo->ChipType >= RTK_BT_CHIP_ID_RTL8822B)
	{
		if(Cbx_PktType->ItemIndex<= BT_PKT_1DH5)
		{
			dstr.sprintf("%d", TxPowerLevelInfo[DEFAULT_1M_TX_POWER_INDEX]);
		}
		else if(Cbx_PktType->ItemIndex<= BT_PKT_2DH5)
		{
			dstr.sprintf("%d", TxPowerLevelInfo[DEFAULT_2M_TX_POWER_INDEX]);

		}
		else
		{
			dstr.sprintf("%d", TxPowerLevelInfo[DEFAULT_3M_TX_POWER_INDEX]);
		}

		Cbx_TxGainIndex->Text = dstr;
	}
        dstr.sprintf("0x%x", PacketHeader[Cbx_PktType->ItemIndex]);     
        Edit_PktHeader->Text = dstr;

	Update();
	return;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Cbx_ActionexecChange(TObject *Sender)
{

	String dstr;
	unsigned char ChannelNum;
	unsigned char OldChannelIndex;
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;

	OldChannelIndex = Cbx_NoLink_Ch->ItemIndex;
	
	switch (Cbx_Actionexec->ItemIndex)
	{
		case SINGLE_TONE_ACTION :
			CheckBox_WhiteningEnable->Enabled = false;
			Edit_PktCount->Enabled = false;
			Cbx_PayloadType->Enabled = false;
			Cbx_PktType->Enabled = false;
			
			CheckBox_WhiteningEnable->Checked = false;
			Cbx_PayloadType->ItemIndex = BT_PAYLOAD_TYPE_ALL0;
			Cbx_PktType->ItemIndex = BT_PKT_3DH5;
			ComboBox_LEE_ContTx_PHY->Enabled = false;
			ChannelNum = 79;
		break;
		
		case LE_CONT_TX_ACTION :
			CheckBox_WhiteningEnable->Enabled = false;
			Edit_PktCount->Enabled = false;
			Cbx_PayloadType->Enabled = false;
			Cbx_PktType->Enabled = false;
			
			CheckBox_WhiteningEnable->Checked = true;
			Cbx_PayloadType->ItemIndex = BT_PAYLOAD_TYPE_PRBS9;
			Cbx_PktType->ItemIndex = BT_PKT_1DH1;

			if(pModuleBtReport->pBTInfo->ChipType==RTK_BT_CHIP_ID_RTL8763B)
			{
				ComboBox_LEE_ContTx_PHY->Enabled = true;
			}
			
			ChannelNum = 40;
		break;
		
		default:
			CheckBox_WhiteningEnable->Enabled = true;
			Edit_PktCount->Enabled = true;
			Cbx_PayloadType->Enabled = true;
			Cbx_PktType->Enabled = true;
			ComboBox_LEE_ContTx_PHY->Enabled = false;
			ChannelNum = 79;
		break;
	}

	Cbx_NoLink_Ch->Items->Clear();
	for (int i=0; i<ChannelNum; i++)
	{
		dstr.sprintf("%d",i);
		Cbx_NoLink_Ch->Items->Add(dstr);
	}

	if(OldChannelIndex < ChannelNum)
	{
		Cbx_NoLink_Ch->ItemIndex = OldChannelIndex;
	}
	else
	{
		Cbx_NoLink_Ch->ItemIndex = ChannelNum-1;
	}
	
	return;        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_SetPowerTrackingClick(TObject *Sender)
{

	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	pParam->ParameterIndex = TX_POWER_TRACKING;

	pParam->mParamData[0] = 0; //set
	pParam->mParamData[1] = RadioGroup_PowerTracking->ItemIndex; //on or off

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Set Power Tracking failed");
 	}
	else
	{
		dstr.sprintf("Set Power Tracking : %d", RadioGroup_PowerTracking->ItemIndex);
		Memo_msg->Lines->Add(dstr);
 	}
      
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Button_PhysicalEfuseReadClick(TObject *Sender)
{
	String dstr, astr;

	BT_PARAMETER *pBtParam=&mBT_PARAMETER;
	BT_DEVICE_REPORT *pBtReport= &mBT_DEVICE_REPORT;

	unsigned char *pReportData;
	unsigned char *pPGRawData;

   //	int PhyEfuseBank =0;
	int PhyEfuseAddr =0;
	int PhyEfuseLen =0;

    //	PhyEfuseBank = StrToInt( Edit_PhyEfuseBank->Text );
	PhyEfuseAddr = StrToInt( Edit_PhyEfuseAddr->Text );
	PhyEfuseLen = StrToInt( Edit_PhyEfuseLen->Text );
	
	pPGRawData = pBtParam->mPGRawData;
	pReportData = pBtReport->ReportData;

	pBtParam->ParameterIndex = READ_EFUSE_DATA;
	
	memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

	pPGRawData[0] = 0x03; // BT Efuse
	pPGRawData[1] = (PhyEfuseAddr&0xFF); // offset low byte
	pPGRawData[2] = ((PhyEfuseAddr>>BYTE_SHIFT)&0xFF); // offset high byte
	pPGRawData[3] = (PhyEfuseLen&0xFF);  //Len 

	DBGPRINTF(">>++BT_ReadUserDefinedFromEfuse() : header : 0X%02X%02X%02X%02X\n", pPGRawData[0], pPGRawData[1], pPGRawData[2], pPGRawData[3]);
	
	pBluetoothModule->UpDataParameter(pBluetoothModule,pBtParam);
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		DBGPRINTF(">>BT_ReadUserDefinedFromEfuse Exec Fail...\n");
	}
	else
	{
		memset(pReportData,0x00, MAX_USERAWDATA_SIZE);
		pBluetoothModule->ActionReport(pBluetoothModule, REPORT_LOGICAL_EFUSE, &mBT_DEVICE_REPORT);
		astr.sprintf("0x%02X%02X%02X%02X%02X%02X%02X%02X",pReportData[11], pReportData[10],pReportData[9], pReportData[8], pReportData[7], pReportData[6], pReportData[5], pReportData[4]);
		Edit_PhyEfuseValue->Text = astr;
	}


error:
	return;
}

//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_PhysicalEfuseWriteClick(TObject *Sender)
{
	String dstr, astr;
	
	BT_PARAMETER *pParam = &mBT_PARAMETER;	
	unsigned char *pPGRawData;
	
       //	int PhyEfuseBank;
	int PhyEfuseAddr;
	int PhyEfuseLen;
	unsigned int PhyEfuseValueLow;
	unsigned int PhyEfuseValueHigh;

	unsigned int PhyEfuseValueTextLen;

	String tmp;

     //	PhyEfuseBank = StrToInt( Edit_PhyEfuseBank->Text );
	PhyEfuseAddr = StrToInt( Edit_PhyEfuseAddr->Text );
	PhyEfuseLen = StrToInt( Edit_PhyEfuseLen->Text );
	PhyEfuseValueTextLen = Edit_PhyEfuseValue->Text.Length();

	astr = Edit_PhyEfuseValue->Text;

	while( (18 - PhyEfuseValueTextLen) > 0 )
	{
		astr.Insert("0", 3);
		PhyEfuseValueTextLen++;
	}

	tmp = astr.SubString(1, 10);
	PhyEfuseValueHigh = StrToInt(tmp);

	tmp = astr.SubString(11, 18);
	tmp.Insert("0x", 1);
	PhyEfuseValueLow = StrToInt(tmp);

	pPGRawData = pParam->mPGRawData;
	
	pParam->ParameterIndex = WRITE_EFUSE_DATA;
	
	memset(pPGRawData,0x00,MAX_USERAWDATA_SIZE);

	pPGRawData[0] = 0x03; // BT Efuse
	pPGRawData[1] = (PhyEfuseAddr&0xFF); // offset low byte
	pPGRawData[2] = ((PhyEfuseAddr>>BYTE_SHIFT)&0xFF); // offset high byte
	pPGRawData[3] = (PhyEfuseLen&0xFF);  //Len 

	pPGRawData[4] = (PhyEfuseValueLow&0xFF);
	pPGRawData[5] = ((PhyEfuseValueLow>>BYTE_SHIFT*1)&0xFF); 
	pPGRawData[6] = ((PhyEfuseValueLow>>BYTE_SHIFT*2)&0xFF); 
	pPGRawData[7] = ((PhyEfuseValueLow>>BYTE_SHIFT*3)&0xFF);
	pPGRawData[8] = (PhyEfuseValueHigh&0xFF);
	pPGRawData[9] = ((PhyEfuseValueHigh>>BYTE_SHIFT*1)&0xFF);
	pPGRawData[10] = ((PhyEfuseValueHigh>>BYTE_SHIFT*2)&0xFF);
	pPGRawData[11] = ((PhyEfuseValueHigh>>BYTE_SHIFT*3)&0xFF);
	
	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);

	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add(">>BT_WriteUserDefinedToEfuse Exec Fail...\n");
		goto exit;
	}
	else
	{
		Memo_msg->Lines->Add(">>BT_WriteUserDefinedToEfuse Success...\n");
	}

exit:
 
	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::CheckBox_Fw_TxRx_ModeClick(TObject *Sender)
{
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	if (CheckBox_Fw_TxRx_Mode->Checked)
	{
		bFwTxRxMode = 1;
		if(pBTInfo->ChipType < RTK_BT_CHIP_ID_RTL8822B)
		{
			API_bt_fw_read_power_info();
		}
	}
	else
	{
		bFwTxRxMode = 0;
		if(pBTInfo->ChipType < RTK_BT_CHIP_ID_RTL8822B)
		{
			API_bt_get_power_index();
		}
	}

	return;        
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::Cbx_Hopping_PktTypeChange(TObject *Sender)
{
	String dstr;
	int i;
	
	if(Cbx_Hopping_PktType->ItemIndex == BT_PKT_LE)
	{
		ComboBox_Hopping_Type->ItemIndex = 0;
		ComboBox_Hopping_Type->Enabled = false;

		ComboBox_Hopping_StopCh->Items->Clear();
		
		for (i=2; i<=39; i++)
		{
			dstr.sprintf("%d",i);
			ComboBox_Hopping_StopCh->Items->Add(dstr);
		}
		
		ComboBox_Hopping_StopCh->Text = "39";
	}
	else
	{
		ComboBox_Hopping_Type->Enabled = true;

		ComboBox_Hopping_StopCh->Items->Clear();		
		for (i=20; i<=78; i++)
		{
			dstr.sprintf("%d",i);
			ComboBox_Hopping_StopCh->Items->Add(dstr);
		}
		ComboBox_Hopping_StopCh->Text = "78";		
	}

        ComboBox_Hopping_TypeChange(Sender);
	return;        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::DumpRFRegister1Click(TObject *Sender)
{
	String dstr;
        int n=0;
	unsigned long  Value=0;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}
                for (n=0;n<0x3f;n++)
                {
		pBluetoothModule->GetRfRegMaskBits(pBluetoothModule,n,15,0,&Value);
                dstr.sprintf(">>Read rf 0x%x = 0x%x",n,Value);
		Memo_msg->Lines->Add(dstr);
                }

	return;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Page01Click(TObject *Sender)
{
         Page01->Checked = ! Page01->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_GetPowerTrackingClick(TObject *Sender)
{
	String dstr;
	BT_PARAMETER *pParam=&mBT_PARAMETER;	
	BT_CHIPINFO *pBTInfo=&mBT_CHIPINFO;

	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	pParam->ParameterIndex = TX_POWER_TRACKING;

	pParam->mParamData[0] = 1; //set

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	
	if (pBluetoothModule->ActionControlExcute(pBluetoothModule) !=0)
	{
		Memo_msg->Lines->Add("Get Power Tracking failed");
		goto error;
 	}

	pBluetoothModule->ActionReport(pBluetoothModule, REPORT_POWER_TRACKING, &mBT_DEVICE_REPORT);
	RadioGroup_PowerTracking->ItemIndex = mBT_DEVICE_REPORT.ReportData[0];

	dstr.sprintf("Get Power Tracking : %d", mBT_DEVICE_REPORT.ReportData[0]);
	Memo_msg->Lines->Add(dstr);
 

error:
	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::MDPage21Click(TObject *Sender)
{
        MDPage21->Checked = ! MDPage21->Checked;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Dump1Click(TObject *Sender)
{
	String dstr;
        int n=0;
	unsigned long  Value=0;
	if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

                pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x0000,15,0,0x0000);
                if (Page01->Checked)
                {
                        Memo_msg->Lines->Add("===== Modem Page 0 ==============");
                        for (n=0;n<0x7e;n+=2)
                        {
		        pBluetoothModule->GetMdRegMaskBits(pBluetoothModule,n,15,0,&Value);
                        dstr.sprintf(">>Read md 0x%x = 0x%x",n,Value);
		        Memo_msg->Lines->Add(dstr);
     	                }
                }
                if (MDPage21->Checked)
                {
                        Memo_msg->Lines->Add("===== Modem Page 1 ==============");
                        pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x0000,15,0,0x0001);
                        for (n=0;n<0x7e;n+=2)
                        {
		        pBluetoothModule->GetMdRegMaskBits(pBluetoothModule,n,15,0,&Value);
                        dstr.sprintf(">>Read md 0x%x = 0x%x",n,Value);
		        Memo_msg->Lines->Add(dstr);
     	                }
                }
                pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x0000,15,0,0x0000);

	return;        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::EnableEfusePageClick(TObject *Sender)
{

	if(EnableEfusePage->Checked == false)
	{
		EnableEfusePage->Checked = true;
	}
	else
	{
		EnableEfusePage->Checked = false;
	}

	if (EnableEfusePage->Checked)
	{
		TabSheet_Efuse->TabVisible= true;
	}
	else
	{
		TabSheet_Efuse->TabVisible= false;
	}

	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::DisableReportUpdateMenuItemClick(
      TObject *Sender)
{
        if(DisableReportUpdateMenuItem->Checked == false)
        {
                DisableReportUpdateMenuItem->Checked = true;
        }
        else
        {
                DisableReportUpdateMenuItem->Checked = false;
        }
}
//---------------------------------------------------------------------------





void __fastcall TForm_Main::EnableMPDebugPage_PopMenuClick(TObject *Sender)
{
	if(EnableMPDebugPage_PopMenu->Checked == false)
	{
		EnableMPDebugPage_PopMenu->Checked = true;
	}
	else
	{
		EnableMPDebugPage_PopMenu->Checked = false;
	}

	if (EnableMPDebugPage_PopMenu->Checked)
	{
		TabSheet_MPDebug->TabVisible= true;
	}
	else
	{
		TabSheet_MPDebug->TabVisible= false;
	}

        return;

}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ComboBox_MPDebugReportChange(TObject *Sender)
{
 	int i;

	if(ComboBox_MPDebugReport->ItemIndex == 0)
	{
		StringGrid_MPDebugReport->ColCount=2;
		StringGrid_MPDebugReport->RowCount=15;
		StringGrid_MPDebugReport->Cells[0][0] = "Item";
		StringGrid_MPDebugReport->Cells[1][0] = "Value";

		StringGrid_MPDebugReport->Cells[0][1] = "efuse max tx power index";
		StringGrid_MPDebugReport->Cells[0][2] = "efuse 1M tx power index";
		StringGrid_MPDebugReport->Cells[0][3] = "efuse 2M tx power index";
		StringGrid_MPDebugReport->Cells[0][4] = "efuse 3M tx power index";
		StringGrid_MPDebugReport->Cells[0][5] = "efuse LE tx power index";
		StringGrid_MPDebugReport->Cells[0][6] = "current 1M tx power index";
		
		StringGrid_MPDebugReport->Cells[0][7] = "current 2M tx power index";
		StringGrid_MPDebugReport->Cells[0][8] = "current 3M tx power index";
		StringGrid_MPDebugReport->Cells[0][9] = "current LE tx power index";
		StringGrid_MPDebugReport->Cells[0][10] = "thermal_now";
		StringGrid_MPDebugReport->Cells[0][11] = "thermal_default";		
		StringGrid_MPDebugReport->Cells[0][12] = "1M bluewiz max power gain";	
		StringGrid_MPDebugReport->Cells[0][13] = "2M bluewiz max power gain";	
		StringGrid_MPDebugReport->Cells[0][14] = "3M bluewiz max power gain";			

		StringGrid_MPDebugReport->ColWidths[0]=150;
		StringGrid_MPDebugReport->ColWidths[1]=50;

		for( i = 1; i<StringGrid_MPDebugReport->RowCount; i++)
			StringGrid_MPDebugReport->Cells[1][i]="0x00";
	        
		for ( i = 0; i<StringGrid_MPDebugReport->RowCount; i++)
			StringGrid_MPDebugReport->RowHeights[i]=15;
	}
	else
	{

		StringGrid_MPDebugReport->ColCount=2;
		StringGrid_MPDebugReport->RowCount=10;
		StringGrid_MPDebugReport->Cells[0][0] = "Item";
		StringGrid_MPDebugReport->Cells[1][0] = "Value";

		StringGrid_MPDebugReport->Cells[0][1] = "iqk_x";
		StringGrid_MPDebugReport->Cells[0][2] = "iqk_y";
		StringGrid_MPDebugReport->Cells[0][3] = "lok";
		StringGrid_MPDebugReport->Cells[0][4] = "thermal value";
		StringGrid_MPDebugReport->Cells[0][5] = "RCK";
		StringGrid_MPDebugReport->Cells[0][6] = "lok valid";
		
		StringGrid_MPDebugReport->Cells[0][7] = "txiqk valid";
		StringGrid_MPDebugReport->Cells[0][8] = "tmeter valid";
		StringGrid_MPDebugReport->Cells[0][9] = "rck valid";

		StringGrid_MPDebugReport->ColWidths[0]=150;
		StringGrid_MPDebugReport->ColWidths[1]=50;

		for( i = 1; i<StringGrid_MPDebugReport->RowCount; i++)
			StringGrid_MPDebugReport->Cells[1][i]="0x00";
	        
		for ( i = 0; i<StringGrid_MPDebugReport->RowCount; i++)
			StringGrid_MPDebugReport->RowHeights[i]=15;

	}

        return;        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_MPDebugReportClick(TObject *Sender)
{
	String dstr;

	if(ComboBox_MPDebugReport->ItemIndex == 0)
	{
		pBluetoothModule->ActionReport(pBluetoothModule,REPORT_MP_DEBUG_MESSAGE, &mBT_DEVICE_REPORT);
		
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[0]);		StringGrid_MPDebugReport->Cells[1][1] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[1]);		StringGrid_MPDebugReport->Cells[1][2] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[2]);		StringGrid_MPDebugReport->Cells[1][3] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[3]);		StringGrid_MPDebugReport->Cells[1][4] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[4]);		StringGrid_MPDebugReport->Cells[1][5] = dstr;

		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[5]);		StringGrid_MPDebugReport->Cells[1][6] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[6]);		StringGrid_MPDebugReport->Cells[1][7] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[7]);		StringGrid_MPDebugReport->Cells[1][8] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[8]);		StringGrid_MPDebugReport->Cells[1][9] = dstr;
		
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[9]);		StringGrid_MPDebugReport->Cells[1][10] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[10]);		StringGrid_MPDebugReport->Cells[1][11] = dstr;

		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[11]);		StringGrid_MPDebugReport->Cells[1][12] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[12]);		StringGrid_MPDebugReport->Cells[1][13] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[13]);		StringGrid_MPDebugReport->Cells[1][14] = dstr;	

	}
	else
	{

		pBluetoothModule->ActionReport(pBluetoothModule,REPORT_MP_FT_VALUE, &mBT_DEVICE_REPORT);

		dstr.sprintf("0x%.2x%.2x", mBT_DEVICE_REPORT.ReportData[1], mBT_DEVICE_REPORT.ReportData[0]);		StringGrid_MPDebugReport->Cells[1][1] = dstr;
		dstr.sprintf("0x%.2x%.2x", mBT_DEVICE_REPORT.ReportData[3], mBT_DEVICE_REPORT.ReportData[2]);		StringGrid_MPDebugReport->Cells[1][2] = dstr;
		dstr.sprintf("0x%.2x%.2x", mBT_DEVICE_REPORT.ReportData[5], mBT_DEVICE_REPORT.ReportData[4]);		StringGrid_MPDebugReport->Cells[1][3] = dstr;

		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[6]);			StringGrid_MPDebugReport->Cells[1][4] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[7]);			StringGrid_MPDebugReport->Cells[1][5] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[8]);			StringGrid_MPDebugReport->Cells[1][6] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[9]);			StringGrid_MPDebugReport->Cells[1][7] = dstr;
		
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[10]);			StringGrid_MPDebugReport->Cells[1][8] = dstr;
		dstr.sprintf("0x%x", mBT_DEVICE_REPORT.ReportData[11]);			StringGrid_MPDebugReport->Cells[1][9] = dstr;

	}

        return;        
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::Button_ReadBDAddrClick(TObject *Sender)
{
	String dstr;
	unsigned char pData[512];
	unsigned char pEvtBuf[512];
	
	if (pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, HCI_READ_BD_ADDR, LEN_0_BYTE, pData, 0x0E, pEvtBuf)!=BT_FUNCTION_SUCCESS)
	{
                Memo_msg->Lines->Add(">>Failed to Read BD Address...");
 		goto error;
	}
	else
	{
		dstr.sprintf(">>Read BD Address 0x%.2x%.2x%.2x%.2x%.2x%.2x", pEvtBuf[11], pEvtBuf[10], pEvtBuf[9], pEvtBuf[8], pEvtBuf[7], pEvtBuf[6]);
		Memo_msg->Lines->Add(dstr);
	}
	
error:
	return;      
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Button_SendHciCmdClick(TObject *Sender)
{   
	int i;
	String dstr, astr;
	unsigned char pData[512];
	unsigned char pEvtBuf[512];
	char *pch;	
	unsigned char DataLen;
	unsigned char pDataChar[512];
	
	unsigned int Opcode = StrToInt(Edit_SendHciCmd_Opcode->Text);
	unsigned char Len = StrToInt(Edit_SendHciCmd_Len->Text);
	String strData = Edit_SendHciCmd_Data->Text;

	DataLen = 0;
	strcpy(pDataChar, strData.c_str());
	pch = strtok(pDataChar, ",");

	while(pch != NULL)
	{
		pData[DataLen] = string_to_num(&pch, 0);

		DataLen++;

		if(DataLen > Len)
			break;

		pch = strtok(NULL, ",");
	}
	
	if (pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, Opcode, Len, pData, 0x0E, pEvtBuf)!=BT_FUNCTION_SUCCESS)
	{
		Memo_msg->Lines->Add(">>Failed to Send Hci Cmd...");
 		goto error;
	}
	else
	{
		dstr.sprintf("->Send Hci Cmd : opcode=0x%.4x, len=%d, data = ", Opcode, Len);
		for( i =0; i <Len; i++)
		{
			astr.sprintf("0x%.2x, ", pData[i]);
			dstr+=astr;
		}
		Memo_msg->Lines->Add(dstr);

		dstr.sprintf("<-Recv Hci Event : code=0x%.2x, len=%d, ", pEvtBuf[0], pEvtBuf[1]);

		for( i=0; i <pEvtBuf[1]; i++)
		{
			astr.sprintf("0x%.2x, ", pEvtBuf[i+2]);
			dstr+=astr;
		}
		Memo_msg->Lines->Add(dstr);

			
	}
	
error:

	return; 	
		
}
//---------------------------------------------------------------------------




void __fastcall TForm_Main::BitBtn_ShowTxPowerClick(TObject *Sender)
{
        API_bt_ShowTxDefaultPower();        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_Set_TPM_IQMClick(TObject *Sender)
{

	String dstr;
	unsigned char pData[512];
	unsigned char pEvtBuf[512];
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;

	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if(pModuleBtReport->pBTInfo->ChipType!=RTK_BT_CHIP_ID_RTL8763B)
	{
		return;
	}

	if(RadioGroup_BBPro_TPM_IQM->ItemIndex == BBPRO_TPM) //TPM
	{
		pData[0] = 1;
		pData[1] = 1;
	}
	else //IQM
	{
		pData[0] = 1;
		pData[1] = 0;
	}

	pBluetoothModule->SendHciCommandWithEvent(pBluetoothModule, 0xfd87, LEN_2_BYTE, pData, 0x0E, pEvtBuf);

	if(pEvtBuf[5] != 0)
	{
		dstr.sprintf("Set Mode : failed !!\n");Memo_msg->Lines->Add(dstr);
	}
	else
	{
		dstr.sprintf("Set Mode : Success !!\n");Memo_msg->Lines->Add(dstr);
	}

	return;        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_Get_TPM_IQMClick(TObject *Sender)
{
	String dstr;
	unsigned long data;
	BT_DEVICE_REPORT	*pModuleBtReport=&mBT_DEVICE_REPORT;

	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if(pModuleBtReport->pBTInfo->ChipType!=RTK_BT_CHIP_ID_RTL8763B)
	{
		return;
	}

	pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x00, 15, 0, 0x03);

	pBluetoothModule->GetMdRegMaskBits(pBluetoothModule, 0x62, 7, 0, &data);

	pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x00, 15, 0, 0x00);
	

	if(data == 3)
	{
		RadioGroup_BBPro_TPM_IQM->ItemIndex = BBPRO_IQM;
	}
	else if(data == 1)
	{
		RadioGroup_BBPro_TPM_IQM->ItemIndex = BBPRO_TPM;
	}

	dstr.sprintf("Get Mode : 0x%x Success !!\n", data);Memo_msg->Lines->Add(dstr);

	if(RadioGroup_BBPro_TPM_IQM->ItemIndex == BBPRO_TPM)
	{
		Cbx_Actionexec->Items->Clear();
		Cbx_Actionexec->Items->Add("Tx (for Certification)");
		Cbx_Actionexec->Items->Add("Pkt-Tx (for MP)");
		Cbx_Actionexec->Items->Add("Pkt-Rx (for MP)");
		Cbx_Actionexec->Items->Add("LE Tx (for Certification)");
		Cbx_Actionexec->ItemIndex=0;

		Cbx_PktType->Items->Clear();
		Cbx_PktType->Items->Add("DH1");
		Cbx_PktType->Items->Add("DH3");
		Cbx_PktType->Items->Add("DH5");
		Cbx_PktType->ItemIndex=0;

		Cbx_Hopping_PktType->Items->Clear();
		Cbx_Hopping_PktType->Items->Add("DH1");
		Cbx_Hopping_PktType->Items->Add("DH3");
		Cbx_Hopping_PktType->Items->Add("DH5");
		Cbx_Hopping_PktType->Items->Add("LE");
		Cbx_Hopping_PktType->ItemIndex=0;
		isTPM = 1; 
		
	}
	else
	{
		Cbx_Actionexec->Items->Clear();
		Cbx_Actionexec->Items->Add("Tx (for Certification)");
		Cbx_Actionexec->Items->Add("Pkt-Tx (for MP)");
		Cbx_Actionexec->Items->Add("Pkt-Rx (for MP)");
		Cbx_Actionexec->Items->Add("LE Tx (for Certification)");
		Cbx_Actionexec->Items->Add("Single Tone (for MP)");
		Cbx_Actionexec->ItemIndex=0;

		Cbx_PktType->Items->Clear();
		Cbx_PktType->Items->Add("DH1");
		Cbx_PktType->Items->Add("DH3");
		Cbx_PktType->Items->Add("DH5");
		Cbx_PktType->Items->Add("2DH1");
		Cbx_PktType->Items->Add("2DH3");
		Cbx_PktType->Items->Add("2DH5");
		Cbx_PktType->Items->Add("3DH1");
		Cbx_PktType->Items->Add("3DH3");
		Cbx_PktType->Items->Add("3DH5");
		Cbx_PktType->ItemIndex=0;

		Cbx_Hopping_PktType->Items->Clear();
		Cbx_Hopping_PktType->Items->Add("DH1");
		Cbx_Hopping_PktType->Items->Add("DH3");
		Cbx_Hopping_PktType->Items->Add("DH5");
		Cbx_Hopping_PktType->Items->Add("2DH1");
		Cbx_Hopping_PktType->Items->Add("2DH3");
		Cbx_Hopping_PktType->Items->Add("2DH5");
		Cbx_Hopping_PktType->Items->Add("3DH1");
		Cbx_Hopping_PktType->Items->Add("3DH3");
		Cbx_Hopping_PktType->Items->Add("3DH5");		
		Cbx_Hopping_PktType->Items->Add("LE");
		Cbx_Hopping_PktType->Items->Add("NULL");
		Cbx_Hopping_PktType->ItemIndex=0;
		isTPM = 0;
	}


	return;        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_Dump_RegClick(TObject *Sender)
{
	int i;
	unsigned long Value;
	FILE *p_fp;

        Button_Dump_Reg->Enabled = false;
	p_fp=fopen("dump_reg.txt","w");

	fputs ("------Rf Register-----\n", p_fp);
	
	for(i=0; i<=0xff; i++)
	{
		pBluetoothModule->GetRfRegMaskBits(pBluetoothModule, i, 15, 0, &Value);
		fprintf(p_fp, "0x%x\t0x%x\n", i, Value);
		fflush(p_fp);
	}
	Memo_msg->Lines->Add("Rf Register dump successfully....");

	fputs ("------Md Register Page 0-----\n", p_fp);
	for(i=0; i<=0xff; i++)
	{
		pBluetoothModule->GetMdRegMaskBits(pBluetoothModule, i, 15, 0, &Value);
		fprintf(p_fp, "0x%x\t0x%x\n", i, Value);
		fflush(p_fp);
	}
	Memo_msg->Lines->Add("Md Register dump successfully....");

	fputs ("------BB Register Page 0-----\n", p_fp);
	for(i=0; i<=0x1fff; i++ )
	{
		pBluetoothModule->GetBBRegMaskBits(pBluetoothModule, 0, i, 15, 0, &Value);
		fprintf(p_fp, "0x%x\t0x%x\n", i, Value);
		fflush(p_fp);
	}
	Memo_msg->Lines->Add("BB Register dump successfully....");

	fputs ("------SYS Register-----\n", p_fp);
	for(i=0; i<=0xff; i++ )
	{
		pBluetoothModule->GetSysRegMaskBits(pBluetoothModule, i, 15, 0,&Value);
		fprintf(p_fp, "0x%x\t0x%x\n", i, Value);
		fflush(p_fp);
	}
	Memo_msg->Lines->Add("SYS Register dump successfully....");

	fclose (p_fp);

        Button_Dump_Reg->Enabled = true;

	return;        
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Enable8723dAntInfoClick(TObject *Sender)
{
	if(Enable8723dAntInfo->Checked == false)
	{
		Enable8723dAntInfo->Checked = true;
	}
	else
	{
		Enable8723dAntInfo->Checked = false;
	}

	if(Enable8723dAntInfo->Checked)
	{
		TabSheet_Ant_Info_8723d->TabVisible = true;
	}
	else
	{
		TabSheet_Ant_Info_8723d->TabVisible = false;
	}
	
	return;        
}

//---------------------------------------------------------------------------

void __fastcall TForm_Main::Button_Set_Diff_S0S1Click(TObject *Sender)
{

	String dstr;
	unsigned long data;
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	BT_DEVICE_REPORT *pModuleBtReport=&mBT_DEVICE_REPORT;	

	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if(pModuleBtReport->pBTInfo->ChipType!=RTK_BT_CHIP_ID_RTL8723D)
	{
		return;
	}

	pParam->ParameterIndex = SET_ANT_DIFF_S0S1;

	pParam->mParamData[0] = RadioGroup_Ant_Info->ItemIndex;	
	pParam->mParamData[1] = StrToInt(Edit_Diff_S0S1->Text);

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionControlExcute(pBluetoothModule) != BT_FUNCTION_SUCCESS)
		goto error;	

	Memo_msg->Lines->Add("Set Diff S0 S1 successfully....");

        return; 

error:

	Memo_msg->Lines->Add("Set Diff S0 S1 error....");
	return;
		
}
//---------------------------------------------------------------------------






void __fastcall TForm_Main::BitBtn2Click(TObject *Sender)
{
        int rtn=0;
        String dstr;
        unsigned long Value =0;
        if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}
        //PAGE 6 OFFSET = 0X14[7:4]
	if (pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x00,15,0,0x06) != 0)
        {
                        goto error;
        }
        if (pBluetoothModule->GetMdRegMaskBits(pBluetoothModule,0x14,7,4,&Value) !=0)
        {
                        goto error;
        }
	if (pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x00,15,0,0x00)!=0)
        {
                        goto error;
        }

        if (Value == 1)
        {
                dstr.sprintf(">>LBT Mode Modem =1  Not Tx Mode\n" );
                Memo_msg->Lines->Add(dstr);
                R_LBTMode2->Checked = false;
                R_LBTMode1->Checked = true;
        }
        else  if (Value == 2)
        {
                dstr.sprintf(">>LBT Mode Modem =2  Reduce Tx Mode\n" );
                Memo_msg->Lines->Add(dstr);
                R_LBTMode2->Checked = true;
                R_LBTMode1->Checked = false;
        }
        else
        {
                    dstr.sprintf(">>[warning] LBT Mode  = %x\n",Value );
                    Memo_msg->Lines->Add(dstr);

        }

        return ;

error :
                dstr.sprintf(">>Get LBT Mode Fail\n");Memo_msg->Lines->Add(dstr);
		return;

}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::BitBtn4Click(TObject *Sender)
{

        String dstr;
        unsigned long Value =0;
        if (pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}
        //PAGE 6 OFFSET = 0X14[7:4]
	if (pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x00,15,0,0x06) !=0)
        {
                        goto error;
        }
        if (R_LBTMode1->Checked == true)
        {
                 Value =1;
        }
        else
         {
                 Value=2;
         }
        if (pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x14,7,4,Value) !=0)
        {
                        goto error;
        }
	if (pBluetoothModule->SetMdRegMaskBits(pBluetoothModule,0x00,15,0,0x00) !=0)
        {
                        goto error;
        }
        dstr.sprintf(">>Set LBT Mode Modem = %x\n",Value );
        Memo_msg->Lines->Add(dstr);
        return ;

error :
        dstr.sprintf(">>Set LBT Mode Fail\n");Memo_msg->Lines->Add(dstr);
        return;
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Button_BBPro_WriteToFlashConfigClick(
      TObject *Sender)
{
        

	String dstr;
	unsigned long data;
	BT_PARAMETER *pParam=&mBT_PARAMETER;
	BT_DEVICE_REPORT *pModuleBtReport=&mBT_DEVICE_REPORT;

	if(pBluetoothModule == NULL)
	{
		dstr.sprintf(">>BluetoothModule is NULL...!!\n");Memo_msg->Lines->Add(dstr);
		return;
	}

	if(pModuleBtReport->pBTInfo->ChipType!=RTK_BT_CHIP_ID_RTL8763B)
	{
		return;
	}

	pParam->ParameterIndex = WRITE_FLASH_CONFIG;

	pParam->mParamData[0] = 0xa;
	pParam->mParamData[1] = 0x0;
	
	//0x5B, 0x04, 0x01, value, 0x7F
	pParam->mParamData[2] = 0x5B;
	pParam->mParamData[3] = 0x04;
	pParam->mParamData[4] = 0x01;
	pParam->mParamData[5] = StrToInt(Cbx_RTL8761_XTAL->Text);
	pParam->mParamData[6] = 0xFF;

	//0x45C
	pParam->mParamData[7] = 0x5C;
	pParam->mParamData[8] = 0x04;
	pParam->mParamData[9] = 0x01;
	pParam->mParamData[10] =StrToInt(Cbx_RTL8761_XTAL->Text);
	pParam->mParamData[11] = 0xFF;

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionControlExcute(pBluetoothModule) != BT_FUNCTION_SUCCESS)
		goto error;

	Memo_msg->Lines->Add("Write Crystal value To Flash Config successfully....");

        return; 

error:

	Memo_msg->Lines->Add("Write Crystal value To Flash Config error....");
	return;
		  
}
//---------------------------------------------------------------------------






void __fastcall TForm_Main::Button_WriteRFtoFlashConfigClick(
      TObject *Sender)
{
	unsigned char TotalConfigEntry[1024];
	unsigned char ConfigEntry[10];
	unsigned int TotalConfigEntryLen = 0;
	BT_PARAMETER *pParam=&mBT_PARAMETER;

	String text;
	int value;
	unsigned char isFlatnessSet = 0;
	unsigned int FlatnessVal;
	unsigned int FlatnessMask;
	
	int blank_pos;

        Button_WriteRFtoFlashConfig->Enabled = false;
        
	memset(TotalConfigEntry, 0, 1024);
			
	if(ComboBox_MaxTxPowerofLegacy1M->Text != "No Used")
	{
		//0x3DD
		text = ComboBox_MaxTxPowerofLegacy1M->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xDD;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}

	if(ComboBox_MaxTxPowerofLegacy2M->Text != "No Used")
	{
		//0x3DE
		text = ComboBox_MaxTxPowerofLegacy2M->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xDE;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);		
		TotalConfigEntryLen +=5;
	}

	if(ComboBox_MaxTxPowerofLegacy3M->Text != "No Used")
	{
		//0x3DF
		text = ComboBox_MaxTxPowerofLegacy3M->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xDF;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}

	if(ComboBox_TxPowerofLE1MLR->Text != "No Used")
	{
		//0x3E0
		text = ComboBox_TxPowerofLE1MLR->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xE0;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}

	if(ComboBox_TxPowerofLE2M->Text != "No Used")
	{
		//0x3E1
		text = ComboBox_TxPowerofLE2M->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xE1;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}	

	if(ComboBox_TxPowerofLE2M_2402MHz->Text != "No Used")
	{
		//0x3E2
		text = ComboBox_TxPowerofLE2M_2402MHz->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xE2;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	} 

	if(ComboBox_TxPowerofLE2M_2480MHz->Text != "No Used")
	{
		//0x3E3
		text = ComboBox_TxPowerofLE2M_2480MHz->Text.SubString(1,4);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xE3;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}	

	if(ComboBox_BREDRPowerControlLevelNumber->Text != "No Used")
	{
		//0x3E8
		text = ComboBox_BREDRPowerControlLevelNumber->Text.SubString(1,1);
		value = StrToInt(text);  

		ConfigEntry[0] = 0xE8;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}	

	FlatnessVal = 0;
	FlatnessMask = 0;

	if(ComboBox_Flatness2402_2423MHz->Text != "No Used")
	{
		//0x3FB  value : signed char to unsigned char
		blank_pos= ComboBox_Flatness2402_2423MHz->Text.Pos(" ");
		text = ComboBox_Flatness2402_2423MHz->Text.SubString(1, blank_pos-1);
		value = StrToInt(text);
		
		FlatnessVal |= (unsigned char)value&0x0F;
		FlatnessMask |= 0x0F;
		
		isFlatnessSet = 1;
	}

	if(ComboBox_Flatness2424_2445MHz->Text != "No Used")
	{
		//0x3FB
		blank_pos= ComboBox_Flatness2424_2445MHz->Text.Pos(" ");
		text = ComboBox_Flatness2424_2445MHz->Text.SubString(1, blank_pos-1);
		value = StrToInt(text);  

		FlatnessVal |= ((unsigned char)value&0x0F)<<4;
		FlatnessMask |= 0xF0;
		
		isFlatnessSet = 1;
	}

	if(ComboBox_Flatness2446_2463MHz->Text != "No Used")
	{
		//0x3FC
		blank_pos= ComboBox_Flatness2446_2463MHz->Text.Pos(" ");
		text = ComboBox_Flatness2446_2463MHz->Text.SubString(1, blank_pos-1);
		value = StrToInt(text);  

		FlatnessVal |= ((unsigned char)value&0x0F)<<8;
		FlatnessMask |= 0xF00;
		
		isFlatnessSet = 1;
	}

	if(ComboBox_Flatness2464_2480MHz->Text != "No Used")
	{
		//0x3FC
		blank_pos= ComboBox_Flatness2464_2480MHz->Text.Pos(" ");
		text = ComboBox_Flatness2464_2480MHz->Text.SubString(1, blank_pos-1);
		value = StrToInt(text);  

		FlatnessVal |= ((unsigned char)value&0x0F)<<12;
		FlatnessMask |= 0xF000;

		isFlatnessSet = 1;
	}

	if( isFlatnessSet == 1 )
	{
		ConfigEntry[0] = 0xFB;
		ConfigEntry[1] = 0x03;
		ConfigEntry[2] = 0x02;
		ConfigEntry[3] = (unsigned char)FlatnessVal&0xFF;
		ConfigEntry[4] = (unsigned char)((FlatnessVal>>8)&0xFF);
		ConfigEntry[5] = (unsigned char)FlatnessMask&0xFF;
		ConfigEntry[6] = (unsigned char)((FlatnessMask>>8)&0xFF);
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_7_BYTE);
		TotalConfigEntryLen +=7;
		
		//0x419 BIT1 = 1
		ConfigEntry[0] = 0x19;
		ConfigEntry[1] = 0x04;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = 0x02;
		ConfigEntry[4] = 0x02;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5; 
	}

	if(ComboBox_AdaptivityEnable->Text != "No Used")
	{
		if(ComboBox_AdaptivityEnable->Text == "Disable")
		{
			ConfigEntry[0] = 0x19;
			ConfigEntry[1] = 0x04;
			ConfigEntry[2] = 0x01;
			ConfigEntry[3] = 0;
			ConfigEntry[4] = 0x01;
			memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
			TotalConfigEntryLen +=5;
		}
		else if(ComboBox_AdaptivityEnable->Text == "Enable")
		{
			ConfigEntry[0] = 0x19;
			ConfigEntry[1] = 0x04;
			ConfigEntry[2] = 0x01;
			ConfigEntry[3] = 1;
			ConfigEntry[4] = 0x01;
			memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
			TotalConfigEntryLen +=5;
		}
	}

	if(ComboBox_AdaptivityAntennaGain->Text != "No Used")
	{
		//0x41B
		value = (ComboBox_AdaptivityAntennaGain->ItemIndex+0xEC) & 0xff;

		ConfigEntry[0] = 0x1B;
		ConfigEntry[1] = 0x04;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0xFF;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}


	if(ComboBox_DefaultBREDRTxPowerLevel->Text != "No Used")
	{
		//0x041C
		text = ComboBox_DefaultBREDRTxPowerLevel->Text.SubString(1,1);
		value = StrToInt(text);  

		ConfigEntry[0] = 0x1C;
		ConfigEntry[1] = 0x04;
		ConfigEntry[2] = 0x01;
		ConfigEntry[3] = value;
		ConfigEntry[4] = 0x07;
		memcpy(TotalConfigEntry+TotalConfigEntryLen, ConfigEntry, LEN_5_BYTE);
		TotalConfigEntryLen +=5;
	}

	pParam->ParameterIndex = WRITE_FLASH_CONFIG;

	pParam->mParamData[0] = TotalConfigEntryLen&0xff;
	pParam->mParamData[1] = (TotalConfigEntryLen>>8)&0xff;

	memcpy(pParam->mParamData+2, TotalConfigEntry, TotalConfigEntryLen);

	pBluetoothModule->UpDataParameter(pBluetoothModule,pParam);
	if(pBluetoothModule->ActionControlExcute(pBluetoothModule) != BT_FUNCTION_SUCCESS)
		goto error;

	Memo_msg->Lines->Add("Write RF value To Flash Config successfully....");

        Button_WriteRFtoFlashConfig->Enabled = true;

	return;
	
error:	

	Memo_msg->Lines->Add("Write RF value To Flash Config error....");

        Button_WriteRFtoFlashConfig->Enabled = true;
	
	return;
        

}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ComboBox_BREDRPowerControlLevelNumberChange(
      TObject *Sender)
{
	int value;
	int i;
	String dstr;

	if(ComboBox_BREDRPowerControlLevelNumber->Text =="No Used")
	{
		ComboBox_DefaultBREDRTxPowerLevel->Text="No Used";
		return;
	}
	
	value = StrToInt(ComboBox_BREDRPowerControlLevelNumber->Text);
	
	ComboBox_DefaultBREDRTxPowerLevel->Items->Clear();
	for (i =0; i<value; i++)
	{
		dstr.sprintf("%d",i);
		ComboBox_DefaultBREDRTxPowerLevel->Items->Add(dstr);
	}
	ComboBox_DefaultBREDRTxPowerLevel->Items->Add("No Used");
	ComboBox_DefaultBREDRTxPowerLevel->ItemIndex = value-1;
	
	return;        
}
//---------------------------------------------------------------------------



void __fastcall TForm_Main::About1Click(TObject *Sender)
{
    MessageBox(NULL, "Version 5.1.2.4", "About RTLBTAPP", 0);
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::EnableReadWriteRegisterPageClick(
      TObject *Sender)
{
        if(EnableReadWriteRegisterPage->Checked == false)
        {
                EnableReadWriteRegisterPage->Checked = true;
        }
        else
        {
                EnableReadWriteRegisterPage->Checked = false;
        }

        if(EnableReadWriteRegisterPage->Checked ==true)
        {
                TabSheet_RW->TabVisible =true;
                TabSheet_SendHciCmd->TabVisible =true;
        }
        else
        {
                TabSheet_RW->TabVisible =false;
                TabSheet_SendHciCmd->TabVisible =false;
        }
        return;        
}
//---------------------------------------------------------------------------


void __fastcall TForm_Main::Button_Show_SNRClick(TObject *Sender)
{

	String dstr;
	unsigned long data;
	double snr;
	
	//set page0 reg18[12:13]=2'b11     //enable mse report reg
	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x00, 15, 0, 0)!=BT_FUNCTION_SUCCESS)
		goto error;

	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x18, 13, 12, 3)!=BT_FUNCTION_SUCCESS)
		goto error;

	//set page2 reg62 = 0x15d7           enable mse
	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x00, 15, 0, 2)!=BT_FUNCTION_SUCCESS)
		goto error;

	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x62, 15, 0, 0x15d7)!=BT_FUNCTION_SUCCESS)
		goto error;
	
	//set page3 reg62[0] = 1         // set reg_rpt_latch_rxneg = 1
	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x00, 15, 0, 3)!=BT_FUNCTION_SUCCESS)
		goto error;

	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x62, 0, 0, 1)!=BT_FUNCTION_SUCCESS)
		goto error;
	
	// read page0 reg68  : mse of payloadAu(16,16f)
	if(pBluetoothModule->SetMdRegMaskBits(pBluetoothModule, 0x00, 15, 0, 0)!=BT_FUNCTION_SUCCESS)
		goto error;

	if(pBluetoothModule->GetMdRegMaskBits(pBluetoothModule, 0x68, 15, 0, &data)!=BT_FUNCTION_SUCCESS)
		goto error;

	if( (data !=0) )
	{
		snr = ((double)10.0*log10((double)65536.0)) - ((double)10.0*log10((double)data));
	}
	else
	{
		snr = 0.0;
	}

        dstr.sprintf("##### snr= %lf, data= %d #####\n", snr, data );
        Memo_msg->Lines->Add(dstr);

	return;

error:

	return;
        
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ComboBox_Hopping_TypeChange(TObject *Sender)
{
	String dstr;
	int i;
	
	if(ComboBox_Hopping_Type->Text=="Fix Channel")
	{
		ComboBox_Hopping_StopCh->Visible = false;
		StaticText28->Visible = false;

		ComboBox_Hopping_StartCh->Items->Clear();
		
		for (i=0; i<=78; i++)
		{
			dstr.sprintf("%d",i);
			ComboBox_Hopping_StartCh->Items->Add(dstr);
		}
		ComboBox_Hopping_StartCh->Text = "0";

		
	}
	else
	{
		if(Cbx_Hopping_PktType->ItemIndex == BT_PKT_LE)
		{
			ComboBox_Hopping_StopCh->Visible = true;
			StaticText28->Visible = true;
			
			ComboBox_Hopping_StartCh->Items->Clear();
			
			for (i=0; i<=37; i++)
			{
				dstr.sprintf("%d",i);
				ComboBox_Hopping_StartCh->Items->Add(dstr);
			}
			ComboBox_Hopping_StartCh->Text = "0";

		}
		else
		{
			ComboBox_Hopping_StopCh->Visible = true;
			StaticText28->Visible = true;
			
			ComboBox_Hopping_StartCh->Items->Clear();
			
			for (i=0; i<=59; i++)
			{
				dstr.sprintf("%d",i);
				ComboBox_Hopping_StartCh->Items->Add(dstr);
			}
			ComboBox_Hopping_StartCh->Text = "0";
		}		
	}

	return;
}
//---------------------------------------------------------------------------

void __fastcall TForm_Main::ComboBox_Hopping_StartChChange(TObject *Sender)
{
	String dstr;
	int i;
	int StartCh = StrToInt(ComboBox_Hopping_StartCh->Text);

	if(ComboBox_Hopping_Type->Text=="Hopping")
	{
		if(Cbx_Hopping_PktType->Text=="LE")
		{
			ComboBox_Hopping_StopCh->Items->Clear();		
			for (i=StartCh+2; i<=39; i++)
			{
				dstr.sprintf("%d",i);
				ComboBox_Hopping_StopCh->Items->Add(dstr);
			}
			ComboBox_Hopping_StopCh->Text = "39";
		}
		else
		{
			ComboBox_Hopping_StopCh->Items->Clear();		
			for (i=StartCh+19; i<=78; i++)
			{
				dstr.sprintf("%d",i);
				ComboBox_Hopping_StopCh->Items->Add(dstr);
			}
			
			ComboBox_Hopping_StopCh->Text = "78";
		}
	}

	return;
}
//---------------------------------------------------------------------------



